/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.datagen;

import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.data.event.GatherDataEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import us.amon.stormward.datagen.StormwardBlockStateProvider;
import us.amon.stormward.datagen.StormwardDataGenProvider;
import us.amon.stormward.datagen.StormwardLootTableProvider;
import us.amon.stormward.datagen.StormwardRecipeProvider;
import us.amon.stormward.datagen.model.StormwardItemModelProvider;
import us.amon.stormward.datagen.model.VanillaItemModelProvider;
import us.amon.stormward.datagen.tag.StormwardBiomeTagsProvider;
import us.amon.stormward.datagen.tag.StormwardBlockTagsProvider;
import us.amon.stormward.datagen.tag.StormwardDamageTypeTagsProvider;
import us.amon.stormward.datagen.tag.StormwardEntityTypeTagsProvider;
import us.amon.stormward.datagen.tag.StormwardItemTagsProvider;

@Mod.EventBusSubscriber(modid="stormward", bus=Mod.EventBusSubscriber.Bus.MOD)
public class StormwardDataGenerators {
    @SubscribeEvent
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        PackOutput packOutput = generator.getPackOutput();
        ExistingFileHelper existingFileHelper = event.getExistingFileHelper();
        CompletableFuture lookupProvider = event.getLookupProvider();
        generator.addProvider(event.includeServer(), (DataProvider)new StormwardRecipeProvider(packOutput));
        generator.addProvider(event.includeServer(), (DataProvider)StormwardLootTableProvider.create(packOutput));
        generator.addProvider(event.includeClient(), (DataProvider)new StormwardBlockStateProvider(packOutput, existingFileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new StormwardItemModelProvider(packOutput, existingFileHelper));
        generator.addProvider(event.includeClient(), (DataProvider)new VanillaItemModelProvider(packOutput, existingFileHelper));
        StormwardBlockTagsProvider blockTagGenerator = (StormwardBlockTagsProvider)generator.addProvider(event.includeServer(), (DataProvider)new StormwardBlockTagsProvider(packOutput, lookupProvider, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new StormwardItemTagsProvider(packOutput, lookupProvider, blockTagGenerator.m_274426_(), existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new StormwardEntityTypeTagsProvider(packOutput, lookupProvider, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new StormwardBiomeTagsProvider(packOutput, lookupProvider, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new StormwardDamageTypeTagsProvider(packOutput, lookupProvider, existingFileHelper));
        generator.addProvider(event.includeServer(), (DataProvider)new StormwardDataGenProvider(packOutput, lookupProvider));
    }
}

