/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.entity;

import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowOwnerGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LeapAtTargetGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.SitWhenOrderedToGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NonTameRandomTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.OwnerHurtTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.monster.Ghast;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraftforge.event.ForgeEventFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import us.amon.stormward.entity.StormwardEntities;
import us.amon.stormward.entity.duel.Duel;
import us.amon.stormward.entity.duel.IDuelist;
import us.amon.stormward.entity.goal.FleeHighstormGoal;
import us.amon.stormward.entity.goal.RestrictHighstormGoal;
import us.amon.stormward.item.StormwardItems;
import us.amon.stormward.sound.StormwardSoundEvents;

public class Axehound
extends TamableAnimal
implements NeutralMob,
IDuelist {
    private static final EntityDataAccessor<Integer> DATA_COLLAR_COLOR = SynchedEntityData.m_135353_(Axehound.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Integer> DATA_REMAINING_ANGER_TIME = SynchedEntityData.m_135353_(Axehound.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final Predicate<LivingEntity> PREY_SELECTOR = entity -> {
        EntityType type = entity.m_6095_();
        return type == EntityType.f_20555_ || type == StormwardEntities.CREMLING.get();
    };
    private static final float START_HEALTH = 12.0f;
    private static final float TAME_HEALTH = 26.0f;
    private static final float START_DAMAGE = 2.5f;
    private static final float TAME_DAMAGE = 5.0f;
    private static final UniformInt PERSISTENT_ANGER_TIME = TimeUtil.m_145020_((int)20, (int)39);
    private UUID persistentAngerTarget;
    private Duel duel;

    protected Axehound(EntityType<? extends TamableAnimal> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.m_7105_(false);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Axehound.m_21552_().m_22268_(Attributes.f_22279_, (double)0.3f).m_22268_(Attributes.f_22276_, 12.0).m_22268_(Attributes.f_22281_, 2.5);
    }

    public static boolean checkSpawnRules(EntityType<Axehound> type, ServerLevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return Axehound.m_218104_(type, (LevelAccessor)level, (MobSpawnType)spawnType, (BlockPos)pos, (RandomSource)random);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_COLLAR_COLOR, (Object)DyeColor.RED.m_41060_());
        this.f_19804_.m_135372_(DATA_REMAINING_ANGER_TIME, (Object)0);
    }

    public void m_7380_(@NotNull CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128344_("CollarColor", (byte)this.getCollarColor().m_41060_());
        this.m_21678_(pCompound);
        this.addDuelistSaveData(pCompound);
    }

    public void m_7378_(@NotNull CompoundTag pCompound) {
        super.m_7378_(pCompound);
        if (pCompound.m_128425_("CollarColor", 99)) {
            this.setCollarColor(DyeColor.m_41053_((int)pCompound.m_128451_("CollarColor")));
        }
        this.m_147285_(this.m_9236_(), pCompound);
        this.readDuelistSaveData(this.m_9236_(), pCompound);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new FleeHighstormGoal((PathfinderMob)this, 0.5));
        this.f_21345_.m_25352_(2, (Goal)new RestrictHighstormGoal((PathfinderMob)this));
        this.f_21345_.m_25352_(3, (Goal)new AxehoundPanicGoal(1.5));
        this.f_21345_.m_25352_(4, (Goal)new SitWhenOrderedToGoal((TamableAnimal)this));
        this.f_21345_.m_25352_(5, (Goal)new LeapAtTargetGoal((Mob)this, 0.4f));
        this.f_21345_.m_25352_(6, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.0, true));
        this.f_21345_.m_25352_(7, (Goal)new FollowOwnerGoal((TamableAnimal)this, 1.0, 10.0f, 2.0f, false));
        this.f_21345_.m_25352_(8, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(9, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(10, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new OwnerHurtByTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(2, (Goal)new OwnerHurtTargetGoal((TamableAnimal)this));
        this.f_21346_.m_25352_(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]).m_26044_(new Class[0]));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, arg_0 -> ((Axehound)this).m_21674_(arg_0)));
        this.f_21346_.m_25352_(5, (Goal)new NonTameRandomTargetGoal((TamableAnimal)this, Mob.class, false, PREY_SELECTOR));
        this.f_21346_.m_25352_(8, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, true));
        this.registerDuelistGoals();
    }

    public void m_8107_() {
        super.m_8107_();
        if (!this.m_9236_().f_46443_) {
            this.m_21666_((ServerLevel)this.m_9236_(), true);
        }
    }

    public int m_8132_() {
        return this.m_21825_() ? 20 : super.m_8132_();
    }

    public boolean m_6469_(@NotNull DamageSource pSource, float pAmount) {
        if (this.m_6673_(pSource)) {
            return false;
        }
        Entity entity = pSource.m_7639_();
        if (!this.m_9236_().f_46443_) {
            this.m_21839_(false);
        }
        if (entity != null && !(entity instanceof Player) && !(entity instanceof AbstractArrow)) {
            pAmount = (pAmount + 1.0f) / 2.0f;
        }
        return super.m_6469_(pSource, pAmount);
    }

    public boolean m_7327_(Entity pEntity) {
        boolean flag = pEntity.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), (float)((int)this.m_21133_(Attributes.f_22281_)));
        if (flag) {
            this.m_19970_((LivingEntity)this, pEntity);
        }
        return flag;
    }

    public void m_7105_(boolean pTamed) {
        super.m_7105_(pTamed);
        if (pTamed) {
            this.m_21051_(Attributes.f_22276_).m_22100_(26.0);
            this.m_21153_(26.0f);
            this.m_21051_(Attributes.f_22281_).m_22100_(2.5);
        } else {
            this.m_21051_(Attributes.f_22276_).m_22100_(12.0);
            this.m_21051_(Attributes.f_22281_).m_22100_(5.0);
        }
    }

    @NotNull
    public InteractionResult m_6071_(Player pPlayer, @NotNull InteractionHand pHand) {
        ItemStack stack = pPlayer.m_21120_(pHand);
        Item item = stack.m_41720_();
        if (this.m_9236_().f_46443_) {
            boolean flag = this.m_21830_((LivingEntity)pPlayer) || this.m_21824_() || stack.m_150930_((Item)StormwardItems.GREATSHELL_BONE.get()) && !this.m_21824_() && !this.m_21660_();
            return flag ? InteractionResult.CONSUME : InteractionResult.PASS;
        }
        if (this.m_21824_()) {
            InteractionResult interactionresult;
            if (this.m_6898_(stack) && this.m_21223_() < this.m_21233_()) {
                this.m_5634_(stack.getFoodProperties((LivingEntity)this).m_38744_());
                if (!pPlayer.m_150110_().f_35937_) {
                    stack.m_41774_(1);
                }
                this.m_146852_(GameEvent.f_157806_, (Entity)this);
                return InteractionResult.SUCCESS;
            }
            if (item instanceof DyeItem) {
                DyeItem dye = (DyeItem)item;
                if (this.m_21830_((LivingEntity)pPlayer)) {
                    DyeColor color = dye.m_41089_();
                    if (color != this.getCollarColor()) {
                        this.setCollarColor(color);
                        if (!pPlayer.m_150110_().f_35937_) {
                            stack.m_41774_(1);
                        }
                        return InteractionResult.SUCCESS;
                    }
                    return super.m_6071_(pPlayer, pHand);
                }
            }
            if ((!(interactionresult = super.m_6071_(pPlayer, pHand)).m_19077_() || this.m_6162_()) && this.m_21830_((LivingEntity)pPlayer)) {
                this.m_21839_(!this.m_21827_());
                this.f_20899_ = false;
                this.f_21344_.m_26573_();
                this.m_6710_(null);
                return InteractionResult.SUCCESS;
            }
            return interactionresult;
        }
        if (stack.m_150930_((Item)StormwardItems.GREATSHELL_BONE.get()) && !this.m_21660_()) {
            if (!pPlayer.m_150110_().f_35937_) {
                stack.m_41774_(1);
            }
            if (this.f_19796_.m_188503_(3) == 0 && !ForgeEventFactory.onAnimalTame((Animal)this, (Player)pPlayer)) {
                this.m_21828_(pPlayer);
                this.f_21344_.m_26573_();
                this.m_6710_(null);
                this.m_21839_(true);
                this.m_9236_().m_7605_((Entity)this, (byte)7);
            } else {
                this.m_9236_().m_7605_((Entity)this, (byte)6);
            }
            return InteractionResult.SUCCESS;
        }
        return super.m_6071_(pPlayer, pHand);
    }

    public float getTailAngle() {
        if (this.m_21660_()) {
            return -0.03141593f;
        }
        return this.m_21824_() ? (0.05f - (this.m_21233_() - this.m_21223_()) * 0.02f) * (float)Math.PI : -1.0471976f;
    }

    public boolean m_6898_(ItemStack pStack) {
        Item item = pStack.m_41720_();
        return item.m_41472_() && pStack.getFoodProperties((LivingEntity)this).m_38746_();
    }

    public int m_6784_() {
        return (Integer)this.f_19804_.m_135370_(DATA_REMAINING_ANGER_TIME);
    }

    public void m_7870_(int pTime) {
        this.f_19804_.m_135381_(DATA_REMAINING_ANGER_TIME, (Object)pTime);
    }

    @Nullable
    public UUID m_6120_() {
        return this.persistentAngerTarget;
    }

    public void m_6925_(@Nullable UUID pTarget) {
        this.persistentAngerTarget = pTarget;
    }

    public void m_6825_() {
        this.m_7870_(PERSISTENT_ANGER_TIME.m_214085_(this.f_19796_));
    }

    public DyeColor getCollarColor() {
        return DyeColor.m_41053_((int)((Integer)this.f_19804_.m_135370_(DATA_COLLAR_COLOR)));
    }

    public void setCollarColor(DyeColor pCollarColor) {
        this.f_19804_.m_135381_(DATA_COLLAR_COLOR, (Object)pCollarColor.m_41060_());
    }

    public Axehound getBreedOffspring(@NotNull ServerLevel pLevel, @NotNull AgeableMob pOtherParent) {
        UUID uuid;
        Axehound axehound = (Axehound)((EntityType)StormwardEntities.AXEHOUND.get()).m_20615_((Level)pLevel);
        if (axehound != null && (uuid = this.m_21805_()) != null) {
            axehound.m_21816_(uuid);
            axehound.m_7105_(true);
        }
        return axehound;
    }

    public boolean m_7848_(@NotNull Animal pOtherAnimal) {
        if (pOtherAnimal == this) {
            return false;
        }
        if (!this.m_21824_()) {
            return false;
        }
        if (!(pOtherAnimal instanceof Axehound)) {
            return false;
        }
        Axehound axehound = (Axehound)pOtherAnimal;
        if (!axehound.m_21824_()) {
            return false;
        }
        if (axehound.m_21825_()) {
            return false;
        }
        return this.m_27593_() && axehound.m_27593_();
    }

    public boolean m_7757_(@NotNull LivingEntity pTarget, @NotNull LivingEntity pOwner) {
        if (!(pTarget instanceof Creeper) && !(pTarget instanceof Ghast)) {
            if (pTarget instanceof Axehound) {
                Axehound axehound = (Axehound)pTarget;
                return !axehound.m_21824_() || axehound.m_269323_() != pOwner;
            }
            if (pTarget instanceof Player && pOwner instanceof Player && !((Player)pOwner).m_7099_((Player)pTarget)) {
                return false;
            }
            if (pTarget instanceof AbstractHorse && ((AbstractHorse)pTarget).m_30614_()) {
                return false;
            }
            return !(pTarget instanceof TamableAnimal) || !((TamableAnimal)pTarget).m_21824_();
        }
        return false;
    }

    public boolean m_6573_(@NotNull Player pPlayer) {
        return !this.m_21660_() && super.m_6573_(pPlayer);
    }

    @NotNull
    public MobType m_6336_() {
        return MobType.f_21642_;
    }

    protected SoundEvent m_7515_() {
        if (this.m_21660_()) {
            return (SoundEvent)StormwardSoundEvents.AXEHOUND_ANGRY.get();
        }
        return (SoundEvent)StormwardSoundEvents.AXEHOUND_AMBIENT.get();
    }

    @Nullable
    protected SoundEvent m_7975_(@NotNull DamageSource pDamageSource) {
        return (SoundEvent)StormwardSoundEvents.AXEHOUND_HURT.get();
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)StormwardSoundEvents.AXEHOUND_DEATH.get();
    }

    @Override
    public Duel getDuel() {
        return this.duel;
    }

    @Override
    public void setDuel(Duel pDuel) {
        this.duel = pDuel;
    }

    class AxehoundPanicGoal
    extends PanicGoal {
        public AxehoundPanicGoal(double pSpeedModifier) {
            super((PathfinderMob)Axehound.this, pSpeedModifier);
        }

        protected boolean m_202729_() {
            return this.f_25684_.m_203117_() || this.f_25684_.m_6060_();
        }
    }
}

