/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.AnimationState;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.HasCustomInventoryScreen;
import net.minecraft.world.entity.ItemBasedSteering;
import net.minecraft.world.entity.ItemSteerable;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.Saddleable;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsRestrictionGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.ItemStackHandler;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;
import us.amon.stormward.damage.StormwardDamageTypes;
import us.amon.stormward.entity.StormwardDataSerializers;
import us.amon.stormward.entity.StormwardEntities;
import us.amon.stormward.entity.goal.ChullFollowParentGoal;
import us.amon.stormward.entity.goal.ChullHideGoal;
import us.amon.stormward.entity.thaylenmerchant.ThaylenMerchant;
import us.amon.stormward.item.StormwardItems;
import us.amon.stormward.menu.ChullMenu;
import us.amon.stormward.network.ClientboundChullScreenOpenPacket;
import us.amon.stormward.network.PacketHandler;
import us.amon.stormward.sound.StormwardSoundEvents;

public class Chull
extends Animal
implements ItemSteerable,
Saddleable,
HasCustomInventoryScreen {
    private static final EntityDataAccessor<Boolean> DATA_CHEST = SynchedEntityData.m_135353_(Chull.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Boolean> DATA_SADDLE = SynchedEntityData.m_135353_(Chull.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<Integer> DATA_BOOST_TIME = SynchedEntityData.m_135353_(Chull.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<State> DATA_STATE = SynchedEntityData.m_135353_(Chull.class, (EntityDataSerializer)((EntityDataSerializer)StormwardDataSerializers.CHULL_STATE.get()));
    public final AnimationState antennaeAnimationState = new AnimationState();
    public final AnimationState armsAnimationState = new AnimationState();
    private final ItemBasedSteering steering = new ItemBasedSteering(this.f_19804_, DATA_BOOST_TIME, DATA_SADDLE);
    private final ItemStackHandler inventory = new ItemStackHandler(1){

        protected void onContentsChanged(int slot) {
            super.onContentsChanged(slot);
            Chull.this.inventoryChanged();
        }
    };
    private final LazyOptional<ItemStackHandler> optional = LazyOptional.of(() -> this.inventory);
    public int animStartTick;

    public Chull(EntityType<? extends Chull> pEntityType, Level pLevel) {
        super((EntityType)StormwardEntities.CHULL.get(), pLevel);
        this.createInventory();
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_CHEST, (Object)false);
        this.f_19804_.m_135372_(DATA_SADDLE, (Object)false);
        this.f_19804_.m_135372_(DATA_BOOST_TIME, (Object)0);
        this.f_19804_.m_135372_(DATA_STATE, (Object)State.IDLING);
    }

    public void m_7380_(@NotNull CompoundTag pCompound) {
        super.m_7380_(pCompound);
        this.steering.m_20847_(pCompound);
        pCompound.m_128379_("Chest", this.hasChest());
        pCompound.m_128365_("Inventory", (Tag)this.inventory.serializeNBT());
    }

    public void m_7378_(@NotNull CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.steering.m_20852_(pCompound);
        this.setChest(pCompound.m_128471_("Chest"));
        this.inventory.deserializeNBT(pCompound.m_128469_("Inventory"));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Chull.m_21552_().m_22268_(Attributes.f_22279_, (double)0.16f).m_22268_(Attributes.f_22276_, 28.0).m_22268_(Attributes.f_22284_, 10.0).m_22268_(Attributes.f_22285_, 4.0).m_22268_(Attributes.f_22278_, 0.5);
    }

    public static boolean checkSpawnRules(EntityType<Chull> type, ServerLevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return Chull.m_218104_(type, (LevelAccessor)level, (MobSpawnType)spawnType, (BlockPos)pos, (RandomSource)random);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new ChullHideGoal(this, 80));
        this.f_21345_.m_25352_(3, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new TemptGoal((PathfinderMob)this, 1.0, Ingredient.m_43929_((ItemLike[])new ItemLike[]{(ItemLike)StormwardItems.LAVIS_GRAIN.get()}), false));
        this.f_21345_.m_25352_(5, (Goal)new MoveTowardsRestrictionGoal((PathfinderMob)this, 0.8));
        this.f_21345_.m_25352_(6, (Goal)new ChullFollowParentGoal(this, 1.1));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.8));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(9, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public boolean m_6898_(ItemStack pStack) {
        return pStack.m_150930_((Item)StormwardItems.LAVIS_GRAIN.get());
    }

    @Nullable
    public AgeableMob m_142606_(@NotNull ServerLevel pLevel, @NotNull AgeableMob pOtherParent) {
        return (AgeableMob)((EntityType)StormwardEntities.CHULL.get()).m_20615_((Level)pLevel);
    }

    public void m_8119_() {
        if (this.m_9236_().m_5776_()) {
            this.antennaeAnimationState.m_246184_(true, this.f_19797_);
            this.armsAnimationState.m_246184_(this.isIdling(), this.f_19797_);
        }
        super.m_8119_();
    }

    protected void m_274498_(@NotNull Player pPlayer, @NotNull Vec3 pTravelVector) {
        super.m_274498_(pPlayer, pTravelVector);
        this.m_19915_(pPlayer.m_146908_(), pPlayer.m_146909_() * 0.5f);
        this.f_20883_ = this.f_20885_ = this.m_146908_();
        this.f_19859_ = this.f_20885_;
        this.steering.m_274606_();
    }

    public void m_7350_(@NotNull EntityDataAccessor<?> pKey) {
        if (this.m_9236_().m_5776_()) {
            if (DATA_BOOST_TIME.equals(pKey)) {
                this.steering.m_20844_();
            } else if (DATA_STATE.equals(pKey)) {
                this.animStartTick = this.f_19797_;
            } else if (DATA_CHEST.equals(pKey)) {
                this.createInventory();
            }
        }
        super.m_7350_(pKey);
    }

    public State getState() {
        return (State)((Object)this.f_19804_.m_135370_(DATA_STATE));
    }

    public void setState(State pState) {
        this.f_19804_.m_135381_(DATA_STATE, (Object)pState);
        this.animStartTick = this.f_19797_;
    }

    public boolean isIdling() {
        return this.getState() == State.IDLING;
    }

    public boolean isHiding() {
        return !this.isIdling();
    }

    public boolean hasChest() {
        return (Boolean)this.f_19804_.m_135370_(DATA_CHEST);
    }

    public void setChest(boolean pChest) {
        this.f_19804_.m_135381_(DATA_CHEST, (Object)pChest);
        this.createInventory();
    }

    @NotNull
    public InteractionResult m_6071_(Player pPlayer, @NotNull InteractionHand pHand) {
        ItemStack stack = pPlayer.m_21120_(pHand);
        if (pPlayer.m_36341_() && !this.m_6162_()) {
            this.m_213583_(pPlayer);
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        InteractionResult result = super.m_6071_(pPlayer, pHand);
        if (this.m_6898_(stack)) {
            return result;
        }
        result = stack.m_41647_(pPlayer, (LivingEntity)this, pHand);
        if (result.m_19077_()) {
            return result;
        }
        if (stack.m_150930_(Items.f_42009_)) {
            this.equipChest(pPlayer, stack);
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        if (this.m_6254_() && !this.m_20160_() && !this.m_6162_()) {
            if (!this.m_9236_().f_46443_) {
                pPlayer.m_20329_((Entity)this);
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        return InteractionResult.PASS;
    }

    @NotNull
    public MobType m_6336_() {
        return MobType.f_21642_;
    }

    public LivingEntity m_6688_() {
        Player player;
        Entity entity;
        if (this.m_6254_() && (entity = this.m_146895_()) instanceof Player && (player = (Player)entity).m_21055_((Item)StormwardItems.STEERING_POLE.get())) {
            return player;
        }
        return super.m_6688_();
    }

    public boolean m_6746_() {
        return this.steering.m_217032_(this.m_217043_());
    }

    @NotNull
    protected Vec3 m_274312_(@NotNull Player pPlayer, @NotNull Vec3 pTravelVector) {
        return new Vec3(0.0, 0.0, 1.0);
    }

    protected float m_245547_(@NotNull Player pPlayer) {
        return (float)(this.m_21133_(Attributes.f_22279_) * 0.225 * (double)this.steering.m_274439_());
    }

    public boolean m_6741_() {
        return this.m_6084_() && !this.m_6162_();
    }

    public void m_5853_(@Nullable SoundSource pSource) {
        this.inventory.setStackInSlot(0, new ItemStack((ItemLike)Items.f_42450_));
        this.steering.m_20849_(true);
        if (pSource != null) {
            this.m_9236_().m_6269_(null, (Entity)this, SoundEvents.f_12236_, pSource, 0.5f, 1.0f);
        }
    }

    public boolean m_6254_() {
        return this.steering.m_20851_();
    }

    @NotNull
    protected Vector3f m_292594_(@NotNull Entity pEntity, @NotNull EntityDimensions pDimensions, float pScale) {
        return new Vector3f(0.0f, pDimensions.f_20378_ + this.getBodyAnchorAnimationYOffset(0.0f), 0.0f);
    }

    @NotNull
    public Vec3 m_245894_(float pPartialTick) {
        return new Vec3(0.0, (double)(this.m_20192_() + this.getBodyAnchorAnimationYOffset(pPartialTick)), (double)(this.m_20205_() * 0.35f));
    }

    protected float getBodyAnchorAnimationYOffset(float pPartialTick) {
        float percent = Math.min(((float)this.f_19797_ + pPartialTick - (float)this.animStartTick) / 8.0f, 1.0f);
        return switch (this.getState()) {
            default -> throw new IncompatibleClassChangeError();
            case State.IDLING -> 0.0f;
            case State.HIDING -> -0.078125f * percent;
            case State.HIDDEN -> -0.078125f;
            case State.REVEALING -> -0.078125f * (1.0f - percent);
        };
    }

    protected void m_5907_() {
        super.m_5907_();
        if (this.inventory != null) {
            for (int i = 0; i < this.inventory.getSlots(); ++i) {
                ItemStack stack = this.inventory.getStackInSlot(i);
                if (stack.m_41619_() || EnchantmentHelper.m_44924_((ItemStack)stack)) continue;
                this.m_19983_(stack);
            }
        }
        if (this.hasChest() && this.m_9236_().f_46443_) {
            this.m_19998_((ItemLike)Blocks.f_50087_);
        }
    }

    private void equipChest(Player pPlayer, ItemStack pChestStack) {
        this.setChest(true);
        this.playChestEquipsSound();
        if (!pPlayer.m_150110_().f_35937_) {
            pChestStack.m_41774_(1);
        }
    }

    protected void playChestEquipsSound() {
        this.m_5496_(SoundEvents.f_11811_, 1.0f, (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f);
    }

    protected int getInventorySize() {
        return this.hasChest() ? 16 : 1;
    }

    public int getInventoryColumns() {
        return 5;
    }

    private void createInventory() {
        if (this.inventory.getSlots() != this.getInventorySize()) {
            ItemStack stack = this.inventory.getStackInSlot(0);
            this.inventory.setSize(this.getInventorySize());
            if (stack != ItemStack.f_41583_) {
                this.inventory.setStackInSlot(0, stack);
            }
        }
    }

    protected void inventoryChanged() {
        if (!this.m_9236_().f_46443_) {
            boolean flag = this.m_6254_();
            this.steering.m_20849_(this.inventory.getStackInSlot(0).m_150930_(Items.f_42450_));
            if (this.f_19797_ > 20 && !flag && this.m_6254_()) {
                this.m_5496_(this.m_246265_(), 0.5f, 1.0f);
            } else if (flag && !this.m_6254_()) {
                this.m_20153_();
            }
        }
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.optional.cast();
        }
        return super.getCapability(cap, side);
    }

    public void invalidateCaps() {
        super.invalidateCaps();
        this.optional.invalidate();
    }

    public void m_213583_(@NotNull Player pPlayer) {
        if (pPlayer instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)pPlayer;
            if (serverPlayer.f_36096_ != serverPlayer.f_36095_) {
                serverPlayer.m_6915_();
            }
            serverPlayer.m_9217_();
            PacketHandler.sendToPlayer(new ClientboundChullScreenOpenPacket(serverPlayer.f_8940_, this.m_19879_()), serverPlayer);
            serverPlayer.f_36096_ = new ChullMenu(serverPlayer.f_8940_, serverPlayer.m_150109_(), this);
            serverPlayer.m_143399_(serverPlayer.f_36096_);
        }
    }

    public void m_246865_(@NotNull Vec3 pAddend) {
        if (!this.isHiding()) {
            super.m_246865_(pAddend);
        }
    }

    public boolean m_6673_(DamageSource pSource) {
        return pSource.m_276093_(StormwardDamageTypes.HIGHSTORM) && this.isHiding() || super.m_6673_(pSource);
    }

    public int m_8085_() {
        return 45;
    }

    public int m_8132_() {
        return 15;
    }

    protected float m_6431_(@NotNull Pose pPose, @NotNull EntityDimensions pDimensions) {
        return pDimensions.f_20378_ * 0.25f;
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)StormwardSoundEvents.CHULL_AMBIENT.get();
    }

    protected void m_7355_(@NotNull BlockPos pPos, @NotNull BlockState pState) {
        this.m_5496_((SoundEvent)StormwardSoundEvents.CHULL_STEP.get(), 1.0f, (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f);
    }

    protected float m_6059_() {
        return this.f_19788_ + 0.3f;
    }

    @Nullable
    protected SoundEvent m_7975_(@NotNull DamageSource pDamageSource) {
        return (SoundEvent)StormwardSoundEvents.CHULL_HURT.get();
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)StormwardSoundEvents.CHULL_DEATH.get();
    }

    public void m_8107_() {
        super.m_8107_();
        if (!this.m_9236_().f_46443_) {
            this.maybeDespawn();
        }
    }

    private void maybeDespawn() {
        ThaylenMerchant merchant;
        Entity entity = this.m_21524_();
        if (entity instanceof ThaylenMerchant && (merchant = (ThaylenMerchant)entity).getDespawnDelay() - 1 <= 0) {
            this.m_21455_(true, false);
            this.m_146870_();
        }
    }

    public static enum State {
        IDLING,
        HIDING,
        HIDDEN,
        REVEALING;

    }
}

