/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.entity;

import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import java.util.function.BiConsumer;
import java.util.function.DoubleSupplier;
import java.util.function.IntUnaryOperator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.util.TimeUtil;
import net.minecraft.util.valueproviders.UniformInt;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.NeutralMob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStandGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.goal.target.ResetUniversalAngerTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.animal.horse.Horse;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.JukeboxBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.DynamicGameEventListener;
import net.minecraft.world.level.gameevent.EntityPositionSource;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.gameevent.GameEventListener;
import net.minecraft.world.level.gameevent.PositionSource;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import us.amon.stormward.entity.goal.FleeHighstormGoal;
import us.amon.stormward.entity.goal.RestrictHighstormGoal;
import us.amon.stormward.entity.goal.RyshadiumBuckGoal;
import us.amon.stormward.entity.goal.RyshadiumListenGoal;
import us.amon.stormward.entity.navigation.WideMobPathNavigation;
import us.amon.stormward.particle.StormwardParticles;
import us.amon.stormward.sound.StormwardSoundEvents;
import us.amon.stormward.worldgen.dimension.StormwardDimensions;

public class Ryshadium
extends Horse
implements NeutralMob {
    private static final EntityDataAccessor<Integer> DATA_REMAINING_ANGER_TIME = SynchedEntityData.m_135353_(Ryshadium.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final int LISTEN_TIME = 40;
    private static final double LIKES_RECORD_CHANCE = (double)0.3f;
    private final DynamicGameEventListener<JukeboxListener> dynamicJukeboxListener;
    private final Set<Item> dislikedRecords = new HashSet<Item>();
    private Player jukeboxPlayer;
    private BlockPos jukeboxPos;
    private int listenTicks;
    private static final UniformInt PERSISTENT_ANGER_TIME = TimeUtil.m_145020_((int)20, (int)39);
    private UUID persistentAngerTarget;

    public Ryshadium(EntityType<? extends Ryshadium> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.dynamicJukeboxListener = new DynamicGameEventListener((GameEventListener)new JukeboxListener((PositionSource)new EntityPositionSource((Entity)this, this.m_20192_()), GameEvent.f_238690_.m_157827_()));
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22266_(Attributes.f_22288_).m_22268_(Attributes.f_22276_, 85.0).m_22268_(Attributes.f_22279_, 0.25).m_22268_(Attributes.f_22281_, 4.0);
    }

    protected void m_214179_(RandomSource pRandom) {
        this.m_21051_(Attributes.f_22276_).m_22100_((double)Ryshadium.m_271722_(arg_0 -> ((RandomSource)pRandom).m_188503_(arg_0)));
        this.m_21051_(Attributes.f_22279_).m_22100_(Ryshadium.m_271981_(() -> ((RandomSource)pRandom).m_188500_()));
        this.m_21051_(Attributes.f_22288_).m_22100_(Ryshadium.m_272017_(() -> ((RandomSource)pRandom).m_188500_()));
    }

    protected static float m_271722_(IntUnaryOperator pOperator) {
        return AbstractHorse.m_271722_((IntUnaryOperator)pOperator) * 2.0f;
    }

    protected static double m_272017_(DoubleSupplier pSupplier) {
        return AbstractHorse.m_272017_((DoubleSupplier)pSupplier) * 1.25;
    }

    protected static double m_271981_(DoubleSupplier pSupplier) {
        return AbstractHorse.m_271981_((DoubleSupplier)pSupplier) * 1.25;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_REMAINING_ANGER_TIME, (Object)0);
    }

    public static boolean checkSpawnRules(EntityType<Ryshadium> type, ServerLevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return Ryshadium.m_218104_(type, (LevelAccessor)level, (MobSpawnType)spawnType, (BlockPos)pos, (RandomSource)random);
    }

    public void m_213651_(@NotNull BiConsumer<DynamicGameEventListener<?>, ServerLevel> pListenerConsumer) {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverlevel = (ServerLevel)level;
            pListenerConsumer.accept(this.dynamicJukeboxListener, serverlevel);
        }
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new RyshadiumBuckGoal(this, 10));
        this.f_21345_.m_25352_(2, (Goal)new FleeHighstormGoal((PathfinderMob)this, 0.5));
        this.f_21345_.m_25352_(3, (Goal)new RestrictHighstormGoal((PathfinderMob)this));
        this.f_21345_.m_25352_(4, (Goal)new MeleeAttackGoal((PathfinderMob)this, 1.2, true));
        this.f_21345_.m_25352_(5, (Goal)new FollowParentGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(6, (Goal)new TemptGoal((PathfinderMob)this, 1.25, Ingredient.m_43929_((ItemLike[])new ItemLike[]{Items.f_42677_, Items.f_42436_, Items.f_42437_}), false));
        this.f_21345_.m_25352_(7, (Goal)new RyshadiumListenGoal(this));
        this.f_21345_.m_25352_(8, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.7));
        this.f_21345_.m_25352_(9, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(10, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(11, (Goal)new RandomStandGoal((AbstractHorse)this));
        this.f_21346_.m_25352_(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(4, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, 10, true, false, arg_0 -> ((Ryshadium)this).m_21674_(arg_0)));
        this.f_21346_.m_25352_(5, (Goal)new ResetUniversalAngerTargetGoal((Mob)this, false));
    }

    @NotNull
    protected PathNavigation m_6037_(@NotNull Level pLevel) {
        return new WideMobPathNavigation((Mob)this, pLevel);
    }

    public void m_7380_(@NotNull CompoundTag pCompound) {
        super.m_7380_(pCompound);
        if (!this.dislikedRecords.isEmpty()) {
            ListTag recordsTag = new ListTag();
            for (Item record : this.dislikedRecords) {
                ResourceLocation location = ForgeRegistries.ITEMS.getKey((Object)record);
                if (location == null) continue;
                recordsTag.add((Object)StringTag.m_129297_((String)location.toString()));
            }
            pCompound.m_128365_("DislikedRecords", (Tag)recordsTag);
        }
        this.m_21678_(pCompound);
    }

    public void m_7378_(@NotNull CompoundTag pCompound) {
        ListTag recordsTag;
        super.m_7378_(pCompound);
        this.dislikedRecords.clear();
        if (pCompound.m_128441_("DislikedRecords") && !(recordsTag = pCompound.m_128437_("DislikedRecords", 8)).isEmpty()) {
            HolderLookup lookup = this.m_9236_().m_246945_(Registries.f_256913_);
            for (Tag tag : recordsTag) {
                if (!(tag instanceof StringTag)) continue;
                StringTag recordTag = (StringTag)tag;
                ResourceLocation location = new ResourceLocation(recordTag.m_7916_());
                lookup.m_254902_(ResourceKey.m_135785_((ResourceKey)Registries.f_256913_, (ResourceLocation)location)).ifPresent(item -> this.dislikedRecords.add((Item)item.get()));
            }
        }
        this.m_147285_(this.m_9236_(), pCompound);
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_21224_() && this.f_19796_.m_188503_(3) == 0 && this.m_9236_().m_46472_() == StormwardDimensions.SHADESMAR_DIMENSION) {
            this.m_9236_().m_7106_((ParticleOptions)StormwardParticles.STORMLIGHT.get(), this.m_20208_(0.6), this.m_20187_(), this.m_20262_(0.6), 0.01 * (Math.random() * 2.0 - 1.0), 0.01 * (Math.random() * 2.0 - 1.0), 0.01 * (Math.random() * 2.0 - 1.0));
        }
    }

    public void m_8107_() {
        this.m_21203_();
        super.m_8107_();
        if (!this.m_9236_().f_46443_) {
            this.m_21666_((ServerLevel)this.m_9236_(), true);
        }
    }

    protected void m_8024_() {
        super.m_8024_();
        if (this.isListening()) {
            BlockEntity blockEntity;
            if (this.shouldStopListening()) {
                this.stopListening();
            } else if (!this.m_30614_() && ++this.listenTicks > 40 && (blockEntity = this.m_9236_().m_7702_(this.jukeboxPos)) instanceof JukeboxBlockEntity) {
                JukeboxBlockEntity jukeboxEntity = (JukeboxBlockEntity)blockEntity;
                Item record = jukeboxEntity.m_272036_().m_41720_();
                if (!this.dislikedRecords.contains(record) && this.f_19796_.m_188500_() <= (double)0.3f) {
                    this.m_30637_(this.jukeboxPlayer);
                    this.dislikedRecords.clear();
                } else {
                    this.dislikedRecords.add(record);
                    this.m_7564_();
                    this.m_9236_().m_7605_((Entity)this, (byte)6);
                    this.stopListening();
                }
            }
        }
    }

    public void m_27595_(@Nullable Player pPlayer) {
    }

    public boolean m_27593_() {
        return false;
    }

    public boolean m_5957_() {
        return false;
    }

    public boolean m_7848_(@NotNull Animal pOtherAnimal) {
        return false;
    }

    public boolean m_6779_(@NotNull LivingEntity pTarget) {
        return this.m_269323_() != pTarget && super.m_6779_(pTarget);
    }

    public boolean m_7559_() {
        return !this.m_21660_();
    }

    public void m_6674_(@NotNull InteractionHand pHand) {
        super.m_6674_(pHand);
        this.m_7564_();
    }

    public void setJukeboxPlaying(Player pPlayer, BlockPos pJukeboxPos) {
        if (this.jukeboxPos == null) {
            this.jukeboxPos = pJukeboxPos;
            this.jukeboxPlayer = pPlayer;
            this.listenTicks = 0;
        }
    }

    public BlockPos getJukeboxPos() {
        return this.jukeboxPos;
    }

    public void setJukeboxStopped(BlockPos pJukeboxPos) {
        if (pJukeboxPos == null || pJukeboxPos.equals((Object)this.jukeboxPos)) {
            this.stopListening();
        }
    }

    public boolean isListening() {
        return this.jukeboxPos != null;
    }

    private boolean shouldStopListening() {
        return this.jukeboxPos == null || !this.jukeboxPos.m_203195_((Position)this.m_20182_(), (double)GameEvent.f_238690_.m_157827_()) || !this.m_9236_().m_8055_(this.jukeboxPos).m_60713_(Blocks.f_50131_);
    }

    public void stopListening() {
        this.jukeboxPos = null;
        this.jukeboxPlayer = null;
        this.listenTicks = 0;
    }

    public int m_6784_() {
        return (Integer)this.f_19804_.m_135370_(DATA_REMAINING_ANGER_TIME);
    }

    public void m_7870_(int pTime) {
        this.f_19804_.m_135381_(DATA_REMAINING_ANGER_TIME, (Object)pTime);
    }

    public void m_6825_() {
        this.m_7870_(PERSISTENT_ANGER_TIME.m_214085_(this.f_19796_));
    }

    public UUID m_6120_() {
        return this.persistentAngerTarget;
    }

    public void m_6925_(UUID pTarget) {
        this.persistentAngerTarget = pTarget;
    }

    public void m_5757_(Container pInvBasic) {
        ItemStack oldArmor = this.m_30722_();
        boolean flag = this.m_6254_();
        this.m_7493_();
        if (this.f_19797_ > 20 && !flag && this.m_6254_()) {
            this.m_5496_(this.m_246265_(), 0.5f, 1.0f);
        }
        ItemStack newArmor = this.m_30722_();
        if (this.f_19797_ > 20 && this.m_6010_(newArmor) && oldArmor != newArmor) {
            this.m_5496_((SoundEvent)StormwardSoundEvents.RYSHADIUM_ARMOR.get(), 0.5f, 1.0f);
        }
    }

    protected void m_5877_(@NotNull SoundType pSoundType) {
        ItemStack stack;
        this.m_5496_((SoundEvent)StormwardSoundEvents.RYSHADIUM_GALLOP.get(), pSoundType.m_56773_() * 0.15f, pSoundType.m_56774_());
        if (this.f_19796_.m_188503_(10) == 0) {
            this.m_5496_((SoundEvent)StormwardSoundEvents.RYSHADIUM_BREATHE.get(), pSoundType.m_56773_() * 0.6f, pSoundType.m_56774_());
        }
        if (this.m_6010_(stack = this.f_30520_.m_8020_(1))) {
            stack.onHorseArmorTick(this.m_9236_(), (Mob)this);
        }
    }

    @NotNull
    protected SoundEvent m_7515_() {
        return (SoundEvent)StormwardSoundEvents.RYSHADIUM_AMBIENT.get();
    }

    @NotNull
    protected SoundEvent m_5592_() {
        return (SoundEvent)StormwardSoundEvents.RYSHADIUM_DEATH.get();
    }

    protected SoundEvent m_7872_() {
        return (SoundEvent)StormwardSoundEvents.RYSHADIUM_EAT.get();
    }

    @NotNull
    protected SoundEvent m_7975_(@NotNull DamageSource pDamageSource) {
        return (SoundEvent)StormwardSoundEvents.RYSHADIUM_HURT.get();
    }

    @NotNull
    protected SoundEvent m_7871_() {
        return (SoundEvent)StormwardSoundEvents.RYSHADIUM_ANGRY.get();
    }

    protected void m_7486_() {
        this.m_5496_((SoundEvent)StormwardSoundEvents.RYSHADIUM_JUMP.get(), 0.4f, 1.0f);
    }

    class JukeboxListener
    implements GameEventListener {
        private final PositionSource listenerSource;
        private final int listenerRadius;

        public JukeboxListener(PositionSource pListenerSource, int pListenerRadius) {
            this.listenerSource = pListenerSource;
            this.listenerRadius = pListenerRadius;
        }

        public PositionSource m_142460_() {
            return this.listenerSource;
        }

        public int m_142078_() {
            return this.listenerRadius;
        }

        public boolean m_214068_(@NotNull ServerLevel pLevel, @NotNull GameEvent pGameEvent, // Could not load outer class - annotation placement on inner may be incorrect
        @NotNull GameEvent.Context pContext, @NotNull Vec3 pPos) {
            if (pGameEvent == GameEvent.f_157792_) {
                Entity entity;
                BlockState state = pContext.f_223712_();
                if (state != null && state.m_60713_(Blocks.f_50131_) && (entity = pContext.f_223711_()) instanceof Player) {
                    Player player = (Player)entity;
                    Ryshadium.this.setJukeboxPlaying(player, BlockPos.m_274446_((Position)pPos));
                    return true;
                }
            } else if (pGameEvent == GameEvent.f_238649_) {
                Ryshadium.this.setJukeboxStopped(BlockPos.m_274446_((Position)pPos));
                return true;
            }
            return false;
        }
    }
}

