/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.entity;

import javax.annotation.Nullable;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import us.amon.stormward.damage.StormwardDamageSources;
import us.amon.stormward.entity.StormwardEntities;
import us.amon.stormward.item.StormwardItems;
import us.amon.stormward.item.weapon.TwoHandedWeaponItem;
import us.amon.stormward.sound.StormwardSoundEvents;

public class ThrownSpear
extends AbstractArrow {
    private static final EntityDataAccessor<Byte> ID_LOYALTY = SynchedEntityData.m_135353_(ThrownSpear.class, (EntityDataSerializer)EntityDataSerializers.f_135027_);
    private static final EntityDataAccessor<Boolean> ID_FOIL = SynchedEntityData.m_135353_(ThrownSpear.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<ItemStack> ID_ITEM = SynchedEntityData.m_135353_(ThrownSpear.class, (EntityDataSerializer)EntityDataSerializers.f_135033_);
    private boolean dealtDamage;
    public int clientSideReturnTridentTickCount;

    public ThrownSpear(EntityType<? extends AbstractArrow> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public ThrownSpear(Level pLevel, LivingEntity pShooter, ItemStack pStack) {
        super((EntityType)StormwardEntities.SPEAR.get(), pShooter, pLevel);
        this.f_19804_.m_135381_(ID_LOYALTY, (Object)((byte)EnchantmentHelper.m_44928_((ItemStack)pStack)));
        this.f_19804_.m_135381_(ID_FOIL, (Object)pStack.m_41790_());
        this.f_19804_.m_135381_(ID_ITEM, (Object)pStack.m_41777_());
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ID_LOYALTY, (Object)0);
        this.f_19804_.m_135372_(ID_FOIL, (Object)false);
        this.f_19804_.m_135372_(ID_ITEM, (Object)new ItemStack((ItemLike)StormwardItems.WOODEN_SPEAR.get()));
    }

    public ItemStack getSpearItem() {
        return (ItemStack)this.f_19804_.m_135370_(ID_ITEM);
    }

    public void m_8119_() {
        if (this.f_36704_ > 4) {
            this.dealtDamage = true;
        }
        Entity entity = this.m_19749_();
        byte i = (Byte)this.f_19804_.m_135370_(ID_LOYALTY);
        if (i > 0 && (this.dealtDamage || this.m_36797_()) && entity != null) {
            if (!this.isAcceptibleReturnOwner()) {
                if (!this.m_9236_().f_46443_ && this.f_36705_ == AbstractArrow.Pickup.ALLOWED) {
                    this.m_5552_(this.m_7941_(), 0.1f);
                }
                this.m_146870_();
            } else {
                this.m_36790_(true);
                Vec3 vec3 = entity.m_146892_().m_82546_(this.m_20182_());
                this.m_20343_(this.m_20185_(), this.m_20186_() + vec3.f_82480_ * 0.015 * (double)i, this.m_20189_());
                if (this.m_9236_().f_46443_) {
                    this.f_19791_ = this.m_20186_();
                }
                double d0 = 0.05 * (double)i;
                this.m_20256_(this.m_20184_().m_82490_(0.95).m_82549_(vec3.m_82541_().m_82490_(d0)));
                if (this.clientSideReturnTridentTickCount == 0) {
                    this.m_5496_((SoundEvent)StormwardSoundEvents.SPEAR_RETURN.get(), 10.0f, 1.0f);
                }
                ++this.clientSideReturnTridentTickCount;
            }
        }
        super.m_8119_();
    }

    private boolean isAcceptibleReturnOwner() {
        Entity entity = this.m_19749_();
        if (entity != null && entity.m_6084_()) {
            return !(entity instanceof ServerPlayer) || !entity.m_5833_();
        }
        return false;
    }

    @NotNull
    protected ItemStack m_7941_() {
        return this.getSpearItem().m_41777_();
    }

    public boolean isFoil() {
        return (Boolean)this.f_19804_.m_135370_(ID_FOIL);
    }

    @Nullable
    protected EntityHitResult m_6351_(@NotNull Vec3 pStartVec, @NotNull Vec3 pEndVec) {
        return this.dealtDamage ? null : super.m_6351_(pStartVec, pEndVec);
    }

    protected void m_5790_(EntityHitResult pResult) {
        float damage;
        Entity entity = pResult.m_82443_();
        Item item = this.getSpearItem().m_41720_();
        if (item instanceof TwoHandedWeaponItem) {
            TwoHandedWeaponItem twoHandedWeapon = (TwoHandedWeaponItem)item;
            v0 = (float)twoHandedWeapon.getDamage();
        } else {
            v0 = damage = 0.0f;
        }
        if (entity instanceof LivingEntity) {
            LivingEntity livingentity = (LivingEntity)entity;
            damage += EnchantmentHelper.m_44833_((ItemStack)this.getSpearItem(), (MobType)livingentity.m_6336_());
        }
        Entity entity1 = this.m_19749_();
        DamageSource damagesource = StormwardDamageSources.spear(this.m_9236_(), (Entity)this, (Entity)(entity1 == null ? this : entity1));
        this.dealtDamage = true;
        if (entity.m_6469_(damagesource, damage)) {
            if (entity.m_6095_() == EntityType.f_20566_) {
                return;
            }
            if (entity instanceof LivingEntity) {
                LivingEntity livingentity1 = (LivingEntity)entity;
                if (entity1 instanceof LivingEntity) {
                    EnchantmentHelper.m_44823_((LivingEntity)livingentity1, (Entity)entity1);
                    EnchantmentHelper.m_44896_((LivingEntity)((LivingEntity)entity1), (Entity)livingentity1);
                }
                this.m_7761_(livingentity1);
            }
        }
        this.m_20256_(this.m_20184_().m_82542_(-0.01, -0.1, -0.01));
        this.m_5496_((SoundEvent)StormwardSoundEvents.SPEAR_HIT.get(), 1.0f, 1.0f);
    }

    protected boolean m_142470_(@NotNull Player pPlayer) {
        return super.m_142470_(pPlayer) || this.m_36797_() && this.m_150171_((Entity)pPlayer) && pPlayer.m_150109_().m_36054_(this.m_7941_());
    }

    @NotNull
    protected SoundEvent m_7239_() {
        return (SoundEvent)StormwardSoundEvents.SPEAR_HIT_GROUND.get();
    }

    public void m_6123_(@NotNull Player pEntity) {
        if (this.m_150171_((Entity)pEntity) || this.m_19749_() == null) {
            super.m_6123_(pEntity);
        }
    }

    public void m_6901_() {
        byte i = (Byte)this.f_19804_.m_135370_(ID_LOYALTY);
        if (this.f_36705_ != AbstractArrow.Pickup.ALLOWED || i <= 0) {
            super.m_6901_();
        }
    }

    public boolean m_6000_(double pX, double pY, double pZ) {
        return true;
    }
}

