/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import us.amon.stormward.capability.tusks.TusksHelper;
import us.amon.stormward.entity.StormwardEntities;
import us.amon.stormward.entity.duel.Duel;
import us.amon.stormward.entity.duel.IDuelist;
import us.amon.stormward.entity.goal.FleeHighstormGoal;
import us.amon.stormward.entity.goal.RestrictHighstormGoal;
import us.amon.stormward.entity.navigation.WideMobPathNavigation;
import us.amon.stormward.item.StormwardItems;
import us.amon.stormward.sound.StormwardSoundEvents;

public class Whitespine
extends Monster
implements IDuelist {
    private static final EntityDataAccessor<Integer> DATA_TUSKS = SynchedEntityData.m_135353_(Whitespine.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private Duel duel;

    protected Whitespine(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Whitespine.m_33035_().m_22268_(Attributes.f_22276_, 60.0).m_22268_(Attributes.f_22279_, 0.44).m_22268_(Attributes.f_22277_, 16.0).m_22268_(Attributes.f_22278_, 0.5).m_22268_(Attributes.f_22281_, 8.0).m_22268_(Attributes.f_22284_, 2.0);
    }

    public static boolean checkSpawnRules(EntityType<Whitespine> type, ServerLevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return Whitespine.m_217057_(type, (LevelAccessor)level, (MobSpawnType)spawnType, (BlockPos)pos, (RandomSource)random);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_TUSKS, (Object)0);
    }

    public void m_7380_(@NotNull CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128405_("Tusks", this.getTusks());
        this.addDuelistSaveData(pCompound);
    }

    public void m_7378_(@NotNull CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.setTusks(pCompound.m_128451_("Tusks"));
        this.readDuelistSaveData(this.m_9236_(), pCompound);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(1, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new WhitespineAttackGoal(this, 1.0, true));
        this.f_21345_.m_25352_(3, (Goal)new FleeHighstormGoal((PathfinderMob)this, 0.5));
        this.f_21345_.m_25352_(4, (Goal)new RestrictHighstormGoal((PathfinderMob)this));
        this.f_21345_.m_25352_(5, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.8));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true, false));
        this.f_21346_.m_25352_(3, (Goal)new NearestAttackableTargetGoal((Mob)this, Mob.class, 10, true, false, entity -> {
            EntityType type = entity.m_6095_();
            return type == StormwardEntities.ALETHI_SOLDIER.get() || type == StormwardEntities.WARFORM_LISTENER.get() || type == EntityType.f_20492_;
        }));
        this.registerDuelistGoals();
    }

    @NotNull
    protected PathNavigation m_6037_(@NotNull Level pLevel) {
        return new WideMobPathNavigation((Mob)this, pLevel);
    }

    @Nullable
    public SpawnGroupData m_6518_(@NotNull ServerLevelAccessor pLevel, @NotNull DifficultyInstance pDifficulty, @NotNull MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        this.setTusks(2);
        return super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }

    public float m_5610_(@NotNull BlockPos pPos, @NotNull LevelReader pLevel) {
        return 0.0f;
    }

    public boolean m_7327_(Entity pEntity) {
        float damage = this.getAttackDamage();
        damage = (int)damage > 0 ? damage / 2.0f + (float)this.f_19796_.m_188503_((int)damage) : damage;
        boolean result = pEntity.m_6469_(this.m_269291_().m_269333_((LivingEntity)this), damage);
        if (result) {
            double knockbackResist;
            if (pEntity instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)pEntity;
                knockbackResist = living.m_21133_(Attributes.f_22278_);
            } else {
                knockbackResist = 0.0;
            }
            double knockback = Math.max(0.0, (double)0.8f - knockbackResist);
            pEntity.m_20256_(pEntity.m_20184_().m_82520_(0.0, (double)0.4f * knockback, 0.0));
            this.m_19970_((LivingEntity)this, pEntity);
        }
        return result;
    }

    private float getAttackDamage() {
        return (float)this.m_21133_(Attributes.f_22281_);
    }

    protected float m_6431_(@NotNull Pose pPose, @NotNull EntityDimensions pDimensions) {
        return pDimensions.f_20378_ * 0.7f;
    }

    public int getTusks() {
        return (Integer)this.f_19804_.m_135370_(DATA_TUSKS);
    }

    public void setTusks(int pTusks) {
        this.f_19804_.m_135381_(DATA_TUSKS, (Object)pTusks);
    }

    protected void m_7472_(@NotNull DamageSource pSource, int pLooting, boolean pRecentlyHit) {
        super.m_7472_(pSource, pLooting, pRecentlyHit);
        if (pRecentlyHit && this.getTusks() > 0) {
            ItemStack tusks = new ItemStack((ItemLike)StormwardItems.WHITESPINE_TUSK.get());
            tusks.m_41764_(this.f_19796_.m_188503_(this.getTusks() + 1));
            if (tusks.m_41613_() > 0) {
                this.m_19983_(tusks);
            }
        }
    }

    @Override
    @Nullable
    public Duel getDuel() {
        return this.duel;
    }

    @Override
    public void setDuel(Duel pDuel) {
        this.duel = pDuel;
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return (SoundEvent)StormwardSoundEvents.WHITESPINE_AMBIENT.get();
    }

    @NotNull
    protected SoundEvent m_7975_(@NotNull DamageSource pDamageSource) {
        return (SoundEvent)StormwardSoundEvents.WHITESPINE_HURT.get();
    }

    @NotNull
    protected SoundEvent m_5592_() {
        return (SoundEvent)StormwardSoundEvents.WHITESPINE_DEATH.get();
    }

    protected void m_7355_(@NotNull BlockPos pPos, @NotNull BlockState pState) {
        this.m_5496_((SoundEvent)StormwardSoundEvents.WHITESPINE_STEP.get(), 1.0f, (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f);
    }

    private static class WhitespineAttackGoal
    extends MeleeAttackGoal {
        private static final int IMPALE_CHANCE = 4;
        private final Whitespine whitespine;

        public WhitespineAttackGoal(Whitespine pWhitespine, double pSpeedModifier, boolean pFollowingTargetEvenIfNotSeen) {
            super((PathfinderMob)pWhitespine, pSpeedModifier, pFollowingTargetEvenIfNotSeen);
            this.whitespine = pWhitespine;
        }

        protected void m_6739_(@NotNull LivingEntity pTarget) {
            if (this.m_295195_(pTarget)) {
                this.m_25563_();
                this.whitespine.m_6674_(InteractionHand.MAIN_HAND);
                if (this.whitespine.m_7327_((Entity)pTarget) && this.whitespine.getTusks() > 0 && this.whitespine.m_217043_().m_188503_(4) == 0 && pTarget instanceof ServerPlayer) {
                    ServerPlayer serverPlayer = (ServerPlayer)pTarget;
                    TusksHelper.impale(this.whitespine, serverPlayer);
                }
            }
        }
    }
}

