/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.entity.brain;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.behavior.BackUpIfTooClose;
import net.minecraft.world.entity.ai.behavior.BehaviorControl;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.behavior.DoNothing;
import net.minecraft.world.entity.ai.behavior.InteractWith;
import net.minecraft.world.entity.ai.behavior.InteractWithDoor;
import net.minecraft.world.entity.ai.behavior.LookAtTargetSink;
import net.minecraft.world.entity.ai.behavior.MeleeAttack;
import net.minecraft.world.entity.ai.behavior.MoveToTargetSink;
import net.minecraft.world.entity.ai.behavior.OneShot;
import net.minecraft.world.entity.ai.behavior.RandomStroll;
import net.minecraft.world.entity.ai.behavior.RunOne;
import net.minecraft.world.entity.ai.behavior.SetEntityLookTarget;
import net.minecraft.world.entity.ai.behavior.SetLookAndInteract;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromAttackTargetIfTargetOutOfReach;
import net.minecraft.world.entity.ai.behavior.SetWalkTargetFromLookTarget;
import net.minecraft.world.entity.ai.behavior.StartAttacking;
import net.minecraft.world.entity.ai.behavior.StopAttackingIfTargetInvalid;
import net.minecraft.world.entity.ai.behavior.StopBeingAngryIfTargetDead;
import net.minecraft.world.entity.ai.behavior.Swim;
import net.minecraft.world.entity.ai.behavior.declarative.BehaviorBuilder;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.schedule.Activity;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ProjectileWeaponItem;
import us.amon.stormward.entity.StormwardEntities;
import us.amon.stormward.entity.brain.ShardbearerAi;
import us.amon.stormward.entity.brain.activity.StormwardActivities;
import us.amon.stormward.entity.brain.behavior.BowAttack;
import us.amon.stormward.entity.brain.behavior.ExtractGemheart;
import us.amon.stormward.entity.brain.behavior.JumpWhileCelebrating;
import us.amon.stormward.entity.brain.behavior.NoShelterPanic;
import us.amon.stormward.entity.brain.behavior.SetWalkTargetFromGemheartIfOutOfRange;
import us.amon.stormward.entity.brain.behavior.SetWalkTargetToShelter;
import us.amon.stormward.entity.brain.behavior.StartCelebratingIfPlateauRunLoss;
import us.amon.stormward.entity.brain.behavior.StopRunIfGemheartInvalid;
import us.amon.stormward.entity.brain.memory.StormwardMemoryModules;
import us.amon.stormward.entity.plateaurun.PlateauRunner;
import us.amon.stormward.entity.shardbearer.WarformListener;
import us.amon.stormward.item.armor.StormwardArmorMaterial;
import us.amon.stormward.sound.StormwardSoundEvents;

public class WarformAi
extends ShardbearerAi {
    private static final int EXTRACT_GEMHEART_RANGE = 12;
    private static final int DEFEND_RANGE = 16;

    public static Brain<?> makeBrain(WarformListener pWarform, Brain<WarformListener> pBrain) {
        WarformAi.initCoreActivity(pBrain);
        WarformAi.initIdleActivity(pBrain);
        WarformAi.initFightActivity(pWarform, pBrain);
        WarformAi.initExtractGemheartActivity(pBrain);
        WarformAi.initDefendActivity(pBrain);
        WarformAi.initCelebrateActivity(pBrain);
        WarformAi.initHideActivity(pBrain);
        pBrain.m_21930_((Set)ImmutableSet.of((Object)Activity.f_37978_));
        pBrain.m_21944_(Activity.f_37979_);
        pBrain.m_21962_();
        return pBrain;
    }

    public static void initMemories(WarformListener pWarform, RandomSource pRandom) {
    }

    private static void initCoreActivity(Brain<WarformListener> pBrain) {
        pBrain.m_21891_(Activity.f_37978_, 0, ImmutableList.of((Object)new LookAtTargetSink(45, 90), (Object)new MoveToTargetSink(), (Object)new Swim(0.8f), (Object)InteractWithDoor.m_257893_(), StartCelebratingIfPlateauRunLoss.create(300), (Object)StopBeingAngryIfTargetDead.m_257993_()));
    }

    private static void initIdleActivity(Brain<WarformListener> pBrain) {
        pBrain.m_21891_(Activity.f_37979_, 10, ImmutableList.of((Object)StartAttacking.m_257741_(WarformListener::canStartAttacking, WarformAi::findNearestValidAttackTarget), WarformAi.createIdleLookBehaviors(), WarformAi.createIdleMovementBehaviors(), (Object)SetLookAndInteract.m_257430_((EntityType)EntityType.f_20532_, (int)4)));
    }

    private static void initFightActivity(WarformListener pWarform, Brain<WarformListener> pBrain) {
        pBrain.m_21895_(Activity.f_37988_, 10, ImmutableList.of((Object)StopAttackingIfTargetInvalid.m_257990_(entity -> !WarformAi.isNearestValidAttackTarget(pWarform, entity)), (Object)BehaviorBuilder.m_257845_(ShardbearerAi::hasBow, (OneShot)BackUpIfTooClose.m_257698_((int)5, (float)0.75f)), (Object)SetWalkTargetFromAttackTargetIfTargetOutOfReach.m_257469_((float)1.0f), (Object)MeleeAttack.m_257733_((int)20), new BowAttack()), MemoryModuleType.f_26372_);
    }

    private static void initExtractGemheartActivity(Brain<WarformListener> pBrain) {
        pBrain.m_21895_((Activity)StormwardActivities.EXTRACT_GEMHEART.get(), 10, ImmutableList.of(StopRunIfGemheartInvalid.create(), SetWalkTargetFromGemheartIfOutOfRange.create(0.9f, 12), new ExtractGemheart(12)), (MemoryModuleType)StormwardMemoryModules.EXTRACTOR.get());
    }

    private static void initDefendActivity(Brain<WarformListener> pBrain) {
        pBrain.m_21903_((Activity)StormwardActivities.DEFEND.get(), ImmutableList.of((Object)Pair.of((Object)10, (Object)StartAttacking.m_257741_(WarformListener::canStartAttacking, WarformAi::findNearestValidAttackTarget)), (Object)Pair.of((Object)11, WarformAi.createDefendLookBehaviors()), (Object)Pair.of((Object)12, WarformAi.createDefendMovementBehaviors())), Set.of(Pair.of((Object)((MemoryModuleType)StormwardMemoryModules.GEMHEART.get()), (Object)MemoryStatus.VALUE_PRESENT)));
    }

    private static void initCelebrateActivity(Brain<WarformListener> pBrain) {
        pBrain.m_21895_(Activity.f_37989_, 10, ImmutableList.of((Object)StartAttacking.m_257741_(WarformListener::canStartAttacking, WarformAi::findNearestValidAttackTarget), JumpWhileCelebrating.create(50), (Object)SetEntityLookTarget.m_258096_((EntityType)((EntityType)StormwardEntities.WARFORM_LISTENER.get()), (float)8.0f)), (MemoryModuleType)StormwardMemoryModules.CELEBRATING.get());
    }

    private static void initHideActivity(Brain<WarformListener> pBrain) {
        pBrain.m_21895_(Activity.f_37987_, 10, ImmutableList.of((Object)StartAttacking.m_257741_(WarformListener::canStartAttacking, WarformAi::findNearestValidAttackTarget), SetWalkTargetToShelter.create(1.0f), (Object)((Object)new NoShelterPanic(1.0f))), (MemoryModuleType)StormwardMemoryModules.EXPOSED_TO_HIGHSTORM.get());
    }

    public static void updateActivity(WarformListener pWarform) {
        Brain<WarformListener> brain = pWarform.m_6274_();
        Activity prevActivity = brain.m_21968_().orElse(null);
        brain.m_21926_((List)ImmutableList.of((Object)((Activity)StormwardActivities.EXTRACT_GEMHEART.get()), (Object)Activity.f_37988_, (Object)Activity.f_37987_, (Object)Activity.f_37989_, (Object)((Activity)StormwardActivities.DEFEND.get()), (Object)Activity.f_37979_));
        Activity activity = brain.m_21968_().orElse(null);
        if (prevActivity != activity) {
            WarformAi.getSoundForCurrentActivity(pWarform).ifPresent(pWarform::playSoundEvent);
        }
        pWarform.m_21561_(brain.m_21874_(MemoryModuleType.f_26372_));
        if (!brain.m_21874_((MemoryModuleType)StormwardMemoryModules.GEMHEART.get())) {
            brain.m_21936_((MemoryModuleType)StormwardMemoryModules.EXTRACTOR.get());
        }
        if (!brain.m_21874_((MemoryModuleType)StormwardMemoryModules.EXTRACTOR.get())) {
            brain.m_21936_((MemoryModuleType)StormwardMemoryModules.EXTRACTING_GEMHEART.get());
        }
        pWarform.setCelebrating(brain.m_21874_((MemoryModuleType)StormwardMemoryModules.CELEBRATING.get()));
        pWarform.setExtractor(brain.m_21874_((MemoryModuleType)StormwardMemoryModules.EXTRACTOR.get()));
        pWarform.setExtractingGemheart(brain.m_21874_((MemoryModuleType)StormwardMemoryModules.EXTRACTING_GEMHEART.get()));
    }

    public static void wasHurtBy(WarformListener pWarform, LivingEntity pTarget) {
        if (!(pTarget instanceof WarformListener)) {
            Brain<WarformListener> brain = pWarform.m_6274_();
            brain.m_21936_((MemoryModuleType)StormwardMemoryModules.CELEBRATING.get());
            WarformAi.maybeRetaliate(pWarform, pTarget, WarformAi.getWarformListeners(pWarform));
        }
    }

    private static Optional<? extends LivingEntity> findNearestValidAttackTarget(WarformListener pWarform) {
        Brain<WarformListener> brain = pWarform.m_6274_();
        BlockPos gemheartPos = brain.m_21952_((MemoryModuleType)StormwardMemoryModules.GEMHEART.get()).orElse(null);
        Optional nearestPlayerWearingCarapace = brain.m_21952_((MemoryModuleType)StormwardMemoryModules.NEAREST_TARGETABLE_PLAYER_WEARING_CARAPACE.get());
        if (nearestPlayerWearingCarapace.isPresent() && WarformAi.isEntityAttackable((LivingEntity)pWarform, (LivingEntity)nearestPlayerWearingCarapace.get()) && WarformAi.isAttackableWithDefenseRestrictions(pWarform, (LivingEntity)nearestPlayerWearingCarapace.get(), gemheartPos)) {
            return nearestPlayerWearingCarapace;
        }
        Optional angryAt = BehaviorUtils.m_22610_((LivingEntity)pWarform, (MemoryModuleType)MemoryModuleType.f_26334_);
        if (angryAt.isPresent() && WarformAi.isEntityAttackableIgnoringLineOfSight((LivingEntity)pWarform, (LivingEntity)angryAt.get()) && WarformAi.isAttackableWithDefenseRestrictions(pWarform, (LivingEntity)angryAt.get(), gemheartPos)) {
            return angryAt;
        }
        Optional nearestTarget = brain.m_21952_(MemoryModuleType.f_148194_);
        if (nearestTarget.isPresent() && WarformAi.isEntityAttackable((LivingEntity)pWarform, (LivingEntity)nearestTarget.get()) && WarformAi.isAttackableWithDefenseRestrictions(pWarform, (LivingEntity)nearestTarget.get(), gemheartPos)) {
            return nearestTarget;
        }
        return Optional.empty();
    }

    private static boolean isAttackableWithDefenseRestrictions(WarformListener pWarform, LivingEntity pTarget, BlockPos pGemheartPos) {
        int n;
        if (pGemheartPos == null) {
            return true;
        }
        Item item = pWarform.m_21205_().m_41720_();
        if (item instanceof ProjectileWeaponItem) {
            ProjectileWeaponItem weapon = (ProjectileWeaponItem)item;
            n = weapon.m_6615_();
        } else {
            n = 1;
        }
        int range = 16 + n;
        return pTarget.m_20182_().m_82546_(pGemheartPos.m_252807_()).m_165925_() <= (double)(range * range);
    }

    private static BehaviorControl<LivingEntity> createIdleLookBehaviors() {
        return new RunOne((List)ImmutableList.builder().add((Object)Pair.of((Object)SetEntityLookTarget.m_258096_((EntityType)EntityType.f_20532_, (float)8.0f), (Object)1)).add((Object)Pair.of((Object)SetEntityLookTarget.m_258096_((EntityType)((EntityType)StormwardEntities.WARFORM_LISTENER.get()), (float)8.0f), (Object)1)).add((Object)Pair.of((Object)SetEntityLookTarget.m_257660_((float)8.0f), (Object)1)).add((Object)Pair.of((Object)new DoNothing(30, 60), (Object)1)).build());
    }

    private static RunOne<WarformListener> createIdleMovementBehaviors() {
        return new RunOne((List)ImmutableList.of((Object)Pair.of((Object)RandomStroll.m_257965_((float)0.6f), (Object)2), (Object)Pair.of((Object)InteractWith.m_258079_((EntityType)((EntityType)StormwardEntities.WARFORM_LISTENER.get()), (int)8, (MemoryModuleType)MemoryModuleType.f_26374_, (float)0.6f, (int)2), (Object)2), (Object)Pair.of((Object)SetWalkTargetFromLookTarget.m_257764_((float)0.6f, (int)3), (Object)2), (Object)Pair.of((Object)new DoNothing(30, 60), (Object)1)));
    }

    private static BehaviorControl<LivingEntity> createDefendLookBehaviors() {
        return new RunOne((List)ImmutableList.builder().add((Object)Pair.of((Object)SetEntityLookTarget.m_258096_((EntityType)EntityType.f_20532_, (float)16.0f), (Object)1)).add((Object)Pair.of((Object)SetEntityLookTarget.m_257836_(entity -> {
            PlateauRunner runner;
            return entity instanceof PlateauRunner && (runner = (PlateauRunner)((Object)entity)).isExtractor();
        }, (float)8.0f), (Object)1)).add((Object)Pair.of((Object)new DoNothing(30, 60), (Object)1)).build());
    }

    private static RunOne<WarformListener> createDefendMovementBehaviors() {
        return new RunOne((List)ImmutableList.of((Object)Pair.of(SetWalkTargetFromGemheartIfOutOfRange.create(0.8f, 16), (Object)2), (Object)Pair.of((Object)RandomStroll.m_257965_((float)0.8f), (Object)1), (Object)Pair.of((Object)new DoNothing(30, 60), (Object)1)));
    }

    private static boolean isNearestValidAttackTarget(WarformListener pWarform, LivingEntity pTarget) {
        return WarformAi.findNearestValidAttackTarget(pWarform).filter(entity -> entity == pTarget).isPresent();
    }

    public static Optional<SoundEvent> getSoundForCurrentActivity(WarformListener pWarform) {
        return pWarform.m_6274_().m_21968_().map(WarformAi::getSoundForActivity);
    }

    private static SoundEvent getSoundForActivity(Activity pActivity) {
        if (pActivity == Activity.f_37989_) {
            return (SoundEvent)StormwardSoundEvents.WARFORM_LISTENER_CELEBRATE.get();
        }
        if (pActivity == StormwardActivities.EXTRACT_GEMHEART.get()) {
            return (SoundEvent)StormwardSoundEvents.WARFORM_LISTENER_EXTRACT.get();
        }
        if (pActivity == Activity.f_37988_ || pActivity == StormwardActivities.DEFEND.get()) {
            return (SoundEvent)StormwardSoundEvents.WARFORM_LISTENER_ANGRY.get();
        }
        return (SoundEvent)StormwardSoundEvents.WARFORM_LISTENER_AMBIENT.get();
    }

    public static Optional<Integer> getSoundIntervalForCurrentActivity(WarformListener pWarform) {
        return pWarform.m_6274_().m_21968_().map(WarformAi::getSoundIntervalForActivity);
    }

    private static int getSoundIntervalForActivity(Activity pActivity) {
        if (pActivity == Activity.f_37989_) {
            return 100;
        }
        if (pActivity == StormwardActivities.EXTRACT_GEMHEART.get()) {
            return 60;
        }
        if (pActivity == Activity.f_37988_ || pActivity == StormwardActivities.DEFEND.get()) {
            return 120;
        }
        return 140;
    }

    public static void setGemheart(LivingEntity pEntity, BlockPos pGemheartPos) {
        if (pGemheartPos != null) {
            pEntity.m_6274_().m_21879_((MemoryModuleType)StormwardMemoryModules.GEMHEART.get(), (Object)pGemheartPos);
        } else {
            pEntity.m_6274_().m_21936_((MemoryModuleType)StormwardMemoryModules.GEMHEART.get());
        }
    }

    public static void setExtractor(LivingEntity pEntity, boolean pExtractor) {
        if (pExtractor) {
            pEntity.m_6274_().m_21879_((MemoryModuleType)StormwardMemoryModules.EXTRACTOR.get(), (Object)pExtractor);
        } else {
            pEntity.m_6274_().m_21936_((MemoryModuleType)StormwardMemoryModules.EXTRACTOR.get());
        }
    }

    private static List<WarformListener> getWarformListeners(WarformListener pWarform) {
        return (List)pWarform.m_6274_().m_21952_((MemoryModuleType)StormwardMemoryModules.NEARBY_WARFORM_LISTENERS.get()).orElse(ImmutableList.of());
    }

    public static boolean isWearingCarapace(LivingEntity pLivingEntity) {
        for (ItemStack itemstack : pLivingEntity.m_6168_()) {
            ArmorItem armorItem;
            Item item = itemstack.m_41720_();
            if (!(item instanceof ArmorItem) || (armorItem = (ArmorItem)item).m_40401_() != StormwardArmorMaterial.CARAPACE) continue;
            return true;
        }
        return false;
    }
}

