/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.entity.brain.behavior;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.behavior.Behavior;
import net.minecraft.world.entity.ai.behavior.BehaviorUtils;
import net.minecraft.world.entity.ai.behavior.EntityTracker;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.MemoryStatus;
import net.minecraft.world.entity.monster.RangedAttackMob;
import net.minecraft.world.entity.projectile.ProjectileUtil;
import net.minecraft.world.item.BowItem;
import net.minecraft.world.item.Item;
import org.jetbrains.annotations.NotNull;
import us.amon.stormward.entity.brain.ShardbearerAi;
import us.amon.stormward.item.StormwardItems;

public class BowAttack<E extends Mob>
extends Behavior<E> {
    private boolean grandbow;
    private int attackDelay;
    private InteractionHand hand;

    public BowAttack() {
        super((Map)ImmutableMap.of((Object)MemoryModuleType.f_26371_, (Object)MemoryStatus.REGISTERED, (Object)MemoryModuleType.f_26372_, (Object)MemoryStatus.VALUE_PRESENT), 1200);
    }

    protected boolean checkExtraStartConditions(@NotNull ServerLevel pLevel, @NotNull E pOwner) {
        LivingEntity livingentity = BowAttack.getAttackTarget(pOwner);
        return ShardbearerAi.hasBow(pOwner) && BehaviorUtils.m_22667_(pOwner, (LivingEntity)livingentity) && BehaviorUtils.m_22632_(pOwner, (LivingEntity)livingentity, (int)0);
    }

    protected boolean canStillUse(@NotNull ServerLevel pLevel, E pEntity, long pGameTime) {
        return pEntity.m_6274_().m_21874_(MemoryModuleType.f_26372_) && this.checkExtraStartConditions(pLevel, pEntity);
    }

    protected void start(@NotNull ServerLevel pLevel, E pEntity, long pGameTime) {
        this.grandbow = pEntity.m_21055_((Item)StormwardItems.GRANDBOW.get());
        this.hand = this.grandbow ? ProjectileUtil.getWeaponHoldingHand(pEntity, item -> item == StormwardItems.GRANDBOW.get()) : ProjectileUtil.getWeaponHoldingHand(pEntity, item -> item instanceof BowItem);
    }

    protected void tick(@NotNull ServerLevel pLevel, @NotNull E pOwner, long pGameTime) {
        LivingEntity livingentity = BowAttack.getAttackTarget(pOwner);
        this.lookAtTarget((Mob)pOwner, livingentity);
        this.bowAttack(pOwner, livingentity);
    }

    protected void stop(@NotNull ServerLevel pLevel, E pEntity, long pGameTime) {
        if (pEntity.m_6117_()) {
            pEntity.m_5810_();
        }
    }

    private void bowAttack(E pShooter, LivingEntity pTarget) {
        if (pShooter.m_6117_()) {
            if (pShooter.m_21252_() > (this.grandbow ? 40 : 20)) {
                pShooter.m_21253_();
                ((RangedAttackMob)pShooter).m_6504_(pTarget, 1.0f);
                this.attackDelay = 20 + pShooter.m_217043_().m_188503_(20);
            }
        } else if (--this.attackDelay <= 0) {
            pShooter.m_6672_(this.hand);
        }
    }

    private void lookAtTarget(Mob pShooter, LivingEntity pTarget) {
        pShooter.m_6274_().m_21879_(MemoryModuleType.f_26371_, (Object)new EntityTracker((Entity)pTarget, true));
    }

    private static LivingEntity getAttackTarget(LivingEntity pShooter) {
        return pShooter.m_6274_().m_21952_(MemoryModuleType.f_26372_).orElse(null);
    }
}

