/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.entity.brain.sensing;

import com.google.common.collect.ImmutableSet;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.level.LevelAccessor;
import org.jetbrains.annotations.NotNull;
import us.amon.stormward.entity.brain.memory.StormwardMemoryModules;
import us.amon.stormward.weather.Highstorm;

public class HighstormSensor
extends Sensor<PathfinderMob> {
    private static final int SHELTER_RANGE = 16;
    private static final int TRIES = 10;

    @NotNull
    public Set<MemoryModuleType<?>> m_7163_() {
        return ImmutableSet.of((Object)((MemoryModuleType)StormwardMemoryModules.EXPOSED_TO_HIGHSTORM.get()), (Object)((MemoryModuleType)StormwardMemoryModules.SHELTER.get()));
    }

    protected void doTick(@NotNull ServerLevel pLevel, @NotNull PathfinderMob pEntity) {
        boolean exposedToHighstorm;
        boolean inHighstorm = Highstorm.isEntityInHighstorm((Entity)pEntity);
        PathNavigation pathNavigation = pEntity.m_21573_();
        if (pathNavigation instanceof GroundPathNavigation) {
            GroundPathNavigation navigation = (GroundPathNavigation)pathNavigation;
            navigation.m_26490_(inHighstorm);
        }
        Brain brain = pEntity.m_6274_();
        boolean bl = exposedToHighstorm = inHighstorm && Highstorm.isBlockExposed((LevelAccessor)pLevel, pEntity.m_20183_());
        if (exposedToHighstorm) {
            brain.m_21879_((MemoryModuleType)StormwardMemoryModules.EXPOSED_TO_HIGHSTORM.get(), (Object)true);
        } else {
            brain.m_21936_((MemoryModuleType)StormwardMemoryModules.EXPOSED_TO_HIGHSTORM.get());
        }
        BlockPos shelterPos = brain.m_21952_((MemoryModuleType)StormwardMemoryModules.SHELTER.get()).orElse(null);
        if (shelterPos == null) {
            if (!this.trySetShelter(pLevel, pEntity.m_20183_(), brain)) {
                RandomSource random = pEntity.m_217043_();
                BlockPos center = pEntity.m_20183_();
                for (int i = 0; i < 10; ++i) {
                    this.trySetShelter(pLevel, center.m_7918_(random.m_188503_(32) - 16, random.m_188503_(6) - 3, random.m_188503_(32) - 16), brain);
                }
            }
        } else if (!this.isShelter(pLevel, shelterPos) || pEntity.m_20238_(shelterPos.m_252807_()) > 256.0) {
            brain.m_21936_((MemoryModuleType)StormwardMemoryModules.SHELTER.get());
        }
    }

    protected boolean trySetShelter(ServerLevel pLevel, BlockPos pPos, Brain<?> brain) {
        if (this.isShelter(pLevel, pPos)) {
            brain.m_21879_((MemoryModuleType)StormwardMemoryModules.SHELTER.get(), (Object)pPos);
            return true;
        }
        return false;
    }

    protected boolean isShelter(ServerLevel pLevel, BlockPos pPos) {
        return !Highstorm.isBlockExposed((LevelAccessor)pLevel, pPos) && (double)pLevel.m_220419_(pPos) >= 0.0;
    }
}

