/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.entity.brain.sensing;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.Brain;
import net.minecraft.world.entity.ai.memory.MemoryModuleType;
import net.minecraft.world.entity.ai.memory.NearestVisibleLivingEntities;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;
import us.amon.stormward.entity.brain.memory.StormwardMemoryModules;
import us.amon.stormward.entity.duel.IDuelist;
import us.amon.stormward.entity.shardbearer.AlethiSoldier;
import us.amon.stormward.entity.shardbearer.WarformListener;

public class SoldierSpecificSensor
extends Sensor<LivingEntity> {
    public Set<MemoryModuleType<?>> m_7163_() {
        return ImmutableSet.of((Object)MemoryModuleType.f_148204_, (Object)MemoryModuleType.f_148205_, (Object)MemoryModuleType.f_148194_, (Object)MemoryModuleType.f_26335_, (Object)((MemoryModuleType)StormwardMemoryModules.NEAREST_CHALLENGER.get()), (Object)((MemoryModuleType)StormwardMemoryModules.VILLAGE_ATTACKER.get()), (Object[])new MemoryModuleType[]{(MemoryModuleType)StormwardMemoryModules.NEARBY_ALETHI_SOLDIERS.get()});
    }

    protected void m_5578_(@NotNull ServerLevel pLevel, LivingEntity pEntity) {
        IDuelist duelist;
        Brain brain = pEntity.m_6274_();
        if (pEntity instanceof IDuelist && (duelist = (IDuelist)pEntity).getDuel() != null) {
            Optional<ServerPlayer> nearestChallenger = pLevel.m_6907_().stream().filter(EntitySelector.f_20408_).filter(player -> player.m_6084_() && pEntity.m_19950_((Entity)player, 24.0) && pEntity.m_6779_((LivingEntity)player) && duelist.getDuel().isChallenger((LivingEntity)player)).min(Comparator.comparingDouble(arg_0 -> ((LivingEntity)pEntity).m_20280_(arg_0)));
            brain.m_21886_((MemoryModuleType)StormwardMemoryModules.NEAREST_CHALLENGER.get(), nearestChallenger);
        }
        NearestVisibleLivingEntities nearestVisibleLivingEntities = brain.m_21952_(MemoryModuleType.f_148205_).orElse(NearestVisibleLivingEntities.m_186106_());
        this.getAggressor(pEntity, nearestVisibleLivingEntities).ifPresent(attacker -> brain.m_21879_((MemoryModuleType)StormwardMemoryModules.VILLAGE_ATTACKER.get(), attacker));
        boolean angry = brain.m_21874_(MemoryModuleType.f_26335_);
        brain.m_21886_(MemoryModuleType.f_148194_, nearestVisibleLivingEntities.m_186128_(entity -> SoldierSpecificSensor.m_148312_((LivingEntity)pEntity, (LivingEntity)entity) && (entity instanceof WarformListener || entity instanceof Enemy || angry && entity instanceof Player)).findFirst());
        ArrayList nearbyAlethiSoldiers = Lists.newArrayList();
        for (LivingEntity entity2 : (List)brain.m_21952_(MemoryModuleType.f_148204_).orElse(ImmutableList.of())) {
            if (!(entity2 instanceof AlethiSoldier)) continue;
            AlethiSoldier alethiSoldier = (AlethiSoldier)entity2;
            nearbyAlethiSoldiers.add(alethiSoldier);
        }
        brain.m_21879_((MemoryModuleType)StormwardMemoryModules.NEARBY_ALETHI_SOLDIERS.get(), (Object)nearbyAlethiSoldiers);
    }

    private Optional<Player> getAggressor(LivingEntity pEntity, NearestVisibleLivingEntities pNearestVisibleLivingEntities) {
        Iterable villagers = pNearestVisibleLivingEntities.m_186123_(entity -> entity.m_6095_() == EntityType.f_20492_);
        Iterable players = pNearestVisibleLivingEntities.m_186123_(entity -> entity.m_6095_() == EntityType.f_20532_);
        for (LivingEntity villager : villagers) {
            for (LivingEntity entity2 : players) {
                Player player;
                if (!SoldierSpecificSensor.m_148312_((LivingEntity)pEntity, (LivingEntity)entity2) || ((Villager)villager).m_35532_(player = (Player)entity2) > -100) continue;
                return Optional.of(player);
            }
        }
        return Optional.empty();
    }
}

