/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.entity.brain.sensing;

import java.util.function.Supplier;
import net.minecraft.world.entity.ai.sensing.Sensor;
import net.minecraft.world.entity.ai.sensing.SensorType;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import us.amon.stormward.entity.brain.sensing.HighstormSensor;
import us.amon.stormward.entity.brain.sensing.PatrollerSensor;
import us.amon.stormward.entity.brain.sensing.SoldierSpecificSensor;
import us.amon.stormward.entity.brain.sensing.WarformSpecificSensor;

public class StormwardSensors {
    public static final DeferredRegister<SensorType<?>> SENSORS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.SENSOR_TYPES, (String)"stormward");
    public static final RegistryObject<SensorType<HighstormSensor>> HIGHSTORM_SENSOR = StormwardSensors.registerModule("highstorm_sensor", HighstormSensor::new);
    public static final RegistryObject<SensorType<PatrollerSensor>> PATROLLER_SENSOR = StormwardSensors.registerModule("patroller_sensor", PatrollerSensor::new);
    public static final RegistryObject<SensorType<WarformSpecificSensor>> WARFORM_SPECIFIC_SENSOR = StormwardSensors.registerModule("warform_specific_sensor", WarformSpecificSensor::new);
    public static final RegistryObject<SensorType<SoldierSpecificSensor>> SOLDIER_SPECIFIC_SENSOR = StormwardSensors.registerModule("soldier_specific_sensor", SoldierSpecificSensor::new);

    private static <U extends Sensor<?>> RegistryObject<SensorType<U>> registerModule(String pIdentifier, Supplier<U> pSensorSupplier) {
        return SENSORS.register(pIdentifier, () -> new SensorType(pSensorSupplier));
    }

    public static void register(IEventBus eventBus) {
        SENSORS.register(eventBus);
    }
}

