/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.entity.chasmfiend;

import java.util.UUID;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.CombatRules;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.gameevent.GameEvent;
import org.jetbrains.annotations.NotNull;
import us.amon.stormward.entity.chasmfiend.Chasmfiend;
import us.amon.stormward.entity.chasmfiend.ChasmfiendPart;
import us.amon.stormward.sound.StormwardSoundEvents;

public class ChasmfiendLeg
extends ChasmfiendPart {
    private static final double DEAD_LEG_SPEED_MODIFIER = -0.02;
    private final Chasmfiend.Leg leg;
    private final EntityDataAccessor<Float> healthDataAccessor;
    private final float maxHealth;
    public int hurtTime;

    public ChasmfiendLeg(Chasmfiend parent, float pWidth, float pHeight, Chasmfiend.Leg pLeg, EntityDataAccessor<Float> pHealthDataAccessor) {
        super(parent, pWidth, pHeight);
        this.leg = pLeg;
        this.healthDataAccessor = pHealthDataAccessor;
        this.maxHealth = parent.m_21233_() / 8.0f;
        this.setHealth(this.maxHealth);
    }

    public void m_7350_(@NotNull EntityDataAccessor<?> pKey) {
        if (pKey == this.healthDataAccessor) {
            if (!this.f_19803_) {
                this.handleDamageEvent();
            }
            if (this.isDead()) {
                this.setDimensions(0.0f, 0.0f);
            }
        }
    }

    public float getHealth() {
        return ((Float)((Chasmfiend)this.getParent()).m_20088_().m_135370_(this.healthDataAccessor)).floatValue();
    }

    public void setHealth(float pHealth) {
        ((Chasmfiend)this.getParent()).m_20088_().m_135381_(this.healthDataAccessor, (Object)Float.valueOf(Mth.m_14036_((float)pHealth, (float)0.0f, (float)this.maxHealth)));
    }

    public boolean isDead() {
        return this.getHealth() <= 0.0f;
    }

    @Override
    public void subEntityTick() {
        super.subEntityTick();
        if (((Chasmfiend)this.getParent()).m_6084_()) {
            if (this.f_19802_ > 0) {
                --this.f_19802_;
            }
            if (this.hurtTime > 0) {
                --this.hurtTime;
            }
        }
        this.f_19803_ = false;
    }

    @Override
    public boolean m_6469_(@NotNull DamageSource pSource, float pAmount) {
        AttributeInstance movementSpeed;
        Entity attacker;
        LivingEntity livingEntity;
        if (this.m_6673_(pSource)) {
            return false;
        }
        if (this.m_9236_().f_46443_) {
            return false;
        }
        if (((Chasmfiend)this.getParent()).m_21224_()) {
            return false;
        }
        if (pSource.m_269533_(DamageTypeTags.f_268745_) && ((Chasmfiend)this.getParent()).m_21023_(MobEffects.f_19607_)) {
            return false;
        }
        if (pSource.m_269533_(DamageTypeTags.f_268419_) && this.m_6095_().m_204039_(EntityTypeTags.f_144295_)) {
            pAmount *= 5.0f;
        }
        if (this.f_19802_ > 10) {
            return false;
        }
        this.f_19802_ = 20;
        this.hurtTime = 10;
        if (pAmount > 0.0f) {
            int resistance;
            float oldAmount;
            float delta;
            pAmount = CombatRules.m_19272_((float)pAmount, (float)((Chasmfiend)this.getParent()).m_21230_(), (float)((float)((Chasmfiend)this.getParent()).m_21133_(Attributes.f_22285_)));
            if (((Chasmfiend)this.getParent()).m_21023_(MobEffects.f_19606_) && !pSource.m_269533_(DamageTypeTags.f_268630_) && (delta = (oldAmount = pAmount) - (pAmount = Math.max(pAmount * (float)(25 - (resistance = (((Chasmfiend)this.getParent()).m_21124_(MobEffects.f_19606_).m_19564_() + 1) * 5)) / 25.0f, 0.0f))) > 0.0f && delta < 3.4028235E37f && (livingEntity = pSource.m_7639_()) instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)livingEntity;
                player.m_6278_(Stats.f_12988_.m_12902_((Object)Stats.f_12930_), Math.round(delta * 10.0f));
            }
            if (pAmount > 0.0f) {
                ((Chasmfiend)this.getParent()).m_21231_().m_289194_(pSource, pAmount);
                this.setHealth(this.getHealth() - pAmount);
                this.m_146850_(GameEvent.f_223706_);
            }
        }
        if ((attacker = pSource.m_7639_()) != null) {
            TamableAnimal tamable;
            if (attacker instanceof LivingEntity) {
                LivingEntity living = (LivingEntity)attacker;
                if (!pSource.m_269533_(DamageTypeTags.f_268718_)) {
                    ((Chasmfiend)this.getParent()).m_6703_(living);
                }
            }
            if (attacker instanceof Player) {
                Player player = (Player)attacker;
                ((Chasmfiend)this.getParent()).m_6598_(player);
            } else if (attacker instanceof TamableAnimal && (tamable = (TamableAnimal)attacker).m_21824_() && (livingEntity = tamable.m_269323_()) instanceof Player) {
                Player owner = (Player)livingEntity;
                ((Chasmfiend)this.getParent()).m_6598_(owner);
            }
        }
        if (this.isDead() && (movementSpeed = ((Chasmfiend)this.getParent()).m_21051_(Attributes.f_22279_)) != null) {
            movementSpeed.m_22125_(new AttributeModifier(UUID.randomUUID(), "Dead leg modifier", -0.02, AttributeModifier.Operation.ADDITION));
        }
        return pAmount > 0.0f;
    }

    @NotNull
    public SoundSource m_5720_() {
        return SoundSource.HOSTILE;
    }

    public void handleDamageEvent() {
        this.f_19802_ = 20;
        this.hurtTime = 10;
        if (!this.isDead()) {
            ((Chasmfiend)this.getParent()).m_5496_((SoundEvent)StormwardSoundEvents.CHASMFIEND_HURT.get(), 1.0f, (this.f_19796_.m_188501_() - this.f_19796_.m_188501_()) * 0.2f + 1.0f);
        } else {
            ((Chasmfiend)this.getParent()).m_5496_((SoundEvent)StormwardSoundEvents.CHASMFIEND_HURT.get(), 1.0f, ((Chasmfiend)this.getParent()).m_6100_());
            if (this.m_9236_().f_46443_) {
                for (int i = 0; i < 20; ++i) {
                    double d0 = this.f_19796_.m_188583_() * 0.02;
                    double d1 = this.f_19796_.m_188583_() * 0.02;
                    double d2 = this.f_19796_.m_188583_() * 0.02;
                    this.m_9236_().m_7106_((ParticleOptions)ParticleTypes.f_123759_, this.m_20208_(0.5) - d0 * 10.0, this.m_20187_() - d1 * 10.0, this.m_20262_(0.5) - d2 * 10.0, d0, d1, d2);
                }
            }
        }
    }

    public Chasmfiend.Leg getLeg() {
        return this.leg;
    }
}

