/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.entity.chasmfiend;

import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.control.BodyRotationControl;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.level.BlockCollisions;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.fluids.FluidType;
import org.jetbrains.annotations.NotNull;
import us.amon.stormward.entity.chasmfiend.LargeBodyRotationControl;
import us.amon.stormward.entity.navigation.LargePathNavigation;

public class LargeMonster
extends Monster {
    private static final float ROTATION_SPEED = 5.0f;
    private static final float ROTATE_THRESHOLD = 5.0f;
    private float nextStep = 1.0f;
    private final Set<BlockPos> groundBlocks = new HashSet<BlockPos>();
    private float goalYRot;

    protected LargeMonster(EntityType<? extends Monster> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    @NotNull
    protected PathNavigation m_6037_(@NotNull Level pLevel) {
        return new LargePathNavigation((Mob)this, pLevel);
    }

    @NotNull
    protected BodyRotationControl m_7560_() {
        return new LargeBodyRotationControl(this);
    }

    public void m_8107_() {
        super.m_146922_(this.rotateTowards(this.m_146908_(), this.goalYRot, 5.0f));
        if (Mth.m_14154_((float)(this.goalYRot - this.m_146908_())) > 5.0f) {
            this.m_7910_(0.0f);
        }
        super.m_8107_();
        if (!this.m_9236_().f_46443_ && !this.m_21224_()) {
            this.destroyBlocks();
        }
    }

    public void m_6478_(@NotNull MoverType pType, @NotNull Vec3 pDeltaMovement) {
        if (this.f_19794_) {
            this.m_6034_(this.m_20185_() + pDeltaMovement.f_82479_, this.m_20186_() + pDeltaMovement.f_82480_, this.m_20189_() + pDeltaMovement.f_82481_);
        } else {
            Vec3 collisionMovement;
            double dist;
            this.f_146810_ = this.m_6060_();
            if (pType == MoverType.PISTON && (pDeltaMovement = this.m_20133_(pDeltaMovement)).equals((Object)Vec3.f_82478_)) {
                return;
            }
            this.m_9236_().m_46473_().m_6180_("move");
            if (this.f_19865_.m_82556_() > 1.0E-7) {
                pDeltaMovement = pDeltaMovement.m_82559_(this.f_19865_);
                this.f_19865_ = Vec3.f_82478_;
                this.m_20256_(Vec3.f_82478_);
            }
            if ((dist = (collisionMovement = this.m_20272_(pDeltaMovement = this.m_5763_(pDeltaMovement, pType))).m_82556_()) > 1.0E-7) {
                BlockHitResult blockhitresult;
                if (this.f_19789_ != 0.0f && dist >= 1.0 && (blockhitresult = this.m_9236_().m_45547_(new ClipContext(this.m_20182_(), this.m_20182_().m_82549_(collisionMovement), ClipContext.Block.FALLDAMAGE_RESETTING, ClipContext.Fluid.WATER, (Entity)this))).m_6662_() != HitResult.Type.MISS) {
                    this.m_183634_();
                }
                this.m_6034_(this.m_20185_() + collisionMovement.f_82479_, this.m_20186_() + collisionMovement.f_82480_, this.m_20189_() + collisionMovement.f_82481_);
            }
            this.m_9236_().m_46473_().m_7238_();
            this.m_9236_().m_46473_().m_6180_("rest");
            boolean flag4 = !Mth.m_14082_((double)pDeltaMovement.f_82479_, (double)collisionMovement.f_82479_);
            boolean flag = !Mth.m_14082_((double)pDeltaMovement.f_82481_, (double)collisionMovement.f_82481_);
            this.f_19862_ = flag4 || flag;
            this.f_19863_ = pDeltaMovement.f_82480_ != collisionMovement.f_82480_;
            this.f_201939_ = this.f_19863_ && pDeltaMovement.f_82480_ < 0.0;
            this.f_185931_ = this.f_19862_ ? this.m_196406_(collisionMovement) : false;
            this.m_289603_(this.f_201939_, collisionMovement);
            if (this.m_213877_()) {
                this.m_9236_().m_46473_().m_7238_();
                return;
            }
            if (this.f_19862_) {
                Vec3 vec31 = this.m_20184_();
                this.m_20334_(flag4 ? 0.0 : vec31.f_82479_, vec31.f_82480_, flag ? 0.0 : vec31.f_82481_);
            }
            for (BlockPos groundPos : this.groundBlocks) {
                BlockState groundState = this.m_9236_().m_8055_(groundPos);
                Block block = groundState.m_60734_();
                if (pDeltaMovement.f_82480_ != collisionMovement.f_82480_) {
                    block.m_5548_((BlockGetter)this.m_9236_(), (Entity)this);
                }
                block.m_141947_(this.m_9236_(), groundPos, groundState, (Entity)this);
            }
            Entity.MovementEmission movementEmission = this.m_142319_();
            if (movementEmission.m_146944_() && !this.m_20159_()) {
                this.f_146794_ = (float)((double)this.f_146794_ + collisionMovement.m_82553_() * 0.6);
                this.f_19787_ += (float)collisionMovement.m_165924_() * 0.6f;
                this.f_19788_ += (float)Math.sqrt(collisionMovement.f_82479_ * collisionMovement.f_82479_ + collisionMovement.f_82480_ * collisionMovement.f_82480_ + collisionMovement.f_82481_ * collisionMovement.f_82481_) * 0.6f;
                if (this.f_19788_ > this.nextStep && this.m_20096_()) {
                    if (this.m_20069_()) {
                        if (movementEmission.m_146946_()) {
                            this.m_280447_();
                        }
                        if (movementEmission.m_146945_()) {
                            this.m_146850_(GameEvent.f_157786_);
                        }
                    } else {
                        BlockPos blockPos = this.m_20097_();
                        this.m_7355_(blockPos, this.m_9236_().m_8055_(blockPos));
                    }
                    this.nextStep = this.m_6059_();
                }
            }
            this.m_146872_();
            float speedFactor = this.m_6041_();
            this.m_20256_(this.m_20184_().m_82542_((double)speedFactor, 1.0, (double)speedFactor));
            if (this.m_9236_().m_46847_(this.m_20191_().m_82406_(1.0E-6)).noneMatch(state -> state.m_204336_(BlockTags.f_13076_) || state.m_60713_(Blocks.f_49991_))) {
                if (this.m_20094_() <= 0) {
                    this.m_7311_(-this.m_6101_());
                }
                if (this.f_146810_ && (this.f_146808_ || this.m_20071_() || this.isInFluidType((fluidType, height) -> this.canFluidExtinguish((FluidType)fluidType)))) {
                    this.m_146873_();
                }
            }
            if (this.m_6060_() && (this.f_146808_ || this.m_20071_() || this.isInFluidType((fluidType, height) -> this.canFluidExtinguish((FluidType)fluidType)))) {
                this.m_7311_(-this.m_6101_());
            }
            this.m_9236_().m_46473_().m_7238_();
        }
    }

    private Vec3 m_20272_(Vec3 pVec) {
        AABB aabb = this.getBlockCollisionBox();
        List list = this.m_9236_().m_183134_((Entity)this, aabb.m_82369_(pVec));
        Vec3 vec3 = pVec.m_82556_() == 0.0 ? pVec : LargeMonster.m_198894_((Entity)this, (Vec3)pVec, (AABB)aabb, (Level)this.m_9236_(), (List)list);
        boolean flag = pVec.f_82479_ != vec3.f_82479_;
        boolean flag1 = pVec.f_82480_ != vec3.f_82480_;
        boolean flag2 = pVec.f_82481_ != vec3.f_82481_;
        boolean flag3 = this.m_20096_() || flag1 && pVec.f_82480_ < 0.0;
        float stepHeight = this.getStepHeight();
        if (stepHeight > 0.0f && flag3 && (flag || flag2)) {
            Vec3 vec33;
            Vec3 vec31 = LargeMonster.m_198894_((Entity)this, (Vec3)new Vec3(pVec.f_82479_, (double)stepHeight, pVec.f_82481_), (AABB)aabb, (Level)this.m_9236_(), (List)list);
            Vec3 vec32 = LargeMonster.m_198894_((Entity)this, (Vec3)new Vec3(0.0, (double)stepHeight, 0.0), (AABB)aabb.m_82363_(pVec.f_82479_, 0.0, pVec.f_82481_), (Level)this.m_9236_(), (List)list);
            if (vec32.f_82480_ < (double)stepHeight && (vec33 = LargeMonster.m_198894_((Entity)this, (Vec3)new Vec3(pVec.f_82479_, 0.0, pVec.f_82481_), (AABB)aabb.m_82383_(vec32), (Level)this.m_9236_(), (List)list).m_82549_(vec32)).m_165925_() > vec31.m_165925_()) {
                vec31 = vec33;
            }
            if (vec31.m_165925_() > vec3.m_165925_()) {
                return vec31.m_82549_(LargeMonster.m_198894_((Entity)this, (Vec3)new Vec3(0.0, -vec31.f_82480_ + pVec.f_82480_, 0.0), (AABB)aabb.m_82383_(vec31), (Level)this.m_9236_(), (List)list));
            }
        }
        return vec3;
    }

    protected void m_289600_(boolean pOnGround, @Nullable Vec3 pMovement) {
        if (pOnGround) {
            AABB aabb = this.getBlockCollisionBox();
            AABB aabb1 = new AABB(aabb.f_82288_, aabb.f_82289_ - 1.0E-6, aabb.f_82290_, aabb.f_82291_, aabb.f_82289_, aabb.f_82293_);
            BlockCollisions collisions = new BlockCollisions((CollisionGetter)this.m_9236_(), (Entity)this, aabb1, false, (pos, shape) -> pos);
            this.groundBlocks.clear();
            BlockPos closestPos = null;
            double closestDist = Double.MAX_VALUE;
            while (collisions.hasNext()) {
                BlockPos pos2 = (BlockPos)collisions.next();
                this.groundBlocks.add(pos2.m_7949_());
                double dist = pos2.m_203193_((Position)this.m_20182_());
                if (!(dist < closestDist) && (dist != closestDist || closestPos != null && closestPos.compareTo((Vec3i)pos2) >= 0)) continue;
                closestPos = pos2.m_7949_();
                closestDist = dist;
            }
            this.f_285638_ = Optional.ofNullable(closestPos);
        } else {
            this.f_285638_ = Optional.empty();
            this.groundBlocks.clear();
        }
    }

    protected float m_20098_() {
        if (this.groundBlocks.isEmpty()) {
            return 0.0f;
        }
        float jumpFactor = 0.0f;
        for (BlockPos groundPos : this.groundBlocks) {
            jumpFactor += this.m_9236_().m_8055_(groundPos).m_60734_().m_49964_();
        }
        return jumpFactor / (float)this.groundBlocks.size();
    }

    protected float m_6041_() {
        if (this.groundBlocks.isEmpty()) {
            return 0.0f;
        }
        float speedFactor = 0.0f;
        for (BlockPos groundPos : this.groundBlocks) {
            speedFactor += this.m_9236_().m_8055_(groundPos).m_60734_().m_49961_();
        }
        return speedFactor / (float)this.groundBlocks.size();
    }

    protected boolean m_6046_() {
        for (BlockPos groundPos : this.groundBlocks) {
            if (!this.m_9236_().m_8055_(groundPos).m_204336_(BlockTags.f_13080_)) continue;
            return true;
        }
        return false;
    }

    public boolean m_6094_() {
        return false;
    }

    protected void destroyBlocks() {
        if (this.m_9236_().m_46469_().m_46207_(GameRules.f_46132_)) {
            BlockPos.m_121921_((AABB)this.m_20191_()).forEach(pos -> {
                if (this.canDestroyBlock((BlockGetter)this.m_9236_(), (BlockPos)pos)) {
                    this.m_9236_().m_46961_(pos, false);
                }
            });
        }
    }

    public boolean canDestroyBlock(BlockGetter pLevel, BlockPos pPos) {
        return this.canDestroyBlock(pLevel, pPos, pLevel.m_8055_(pPos));
    }

    public boolean canDestroyBlock(BlockGetter pLevel, BlockPos pPos, BlockState pState) {
        return pState.m_60800_(pLevel, pPos) <= 0.2f;
    }

    protected double getWidthMargin() {
        return 2.0;
    }

    protected double getHeightMargin() {
        return 3.0;
    }

    public AABB getBlockCollisionBox() {
        AABB aabb = this.m_20191_();
        return new AABB(aabb.f_82288_ + this.getWidthMargin(), aabb.f_82289_, aabb.f_82290_ + this.getWidthMargin(), aabb.f_82291_ - this.getWidthMargin(), aabb.f_82292_ - this.getHeightMargin(), aabb.f_82293_ - this.getWidthMargin());
    }

    public float getBlockBBWidth() {
        return this.m_20205_() - (float)this.getWidthMargin() * 2.0f;
    }

    public float getBlockBBHeight() {
        return this.m_20206_() - (float)this.getHeightMargin();
    }

    protected float m_6431_(@NotNull Pose pPose, @NotNull EntityDimensions pDimensions) {
        return pDimensions.f_20378_ - (float)this.getHeightMargin();
    }

    public boolean m_5830_() {
        if (this.f_19794_) {
            return false;
        }
        float f = this.getBlockBBWidth() * 0.8f;
        AABB aabb = AABB.m_165882_((Vec3)this.m_146892_(), (double)f, (double)1.0E-6, (double)f);
        return BlockPos.m_121921_((AABB)aabb).anyMatch(p_201942_ -> {
            BlockState blockstate = this.m_9236_().m_8055_(p_201942_);
            return !blockstate.m_60795_() && blockstate.m_60828_((BlockGetter)this.m_9236_(), p_201942_) && Shapes.m_83157_((VoxelShape)blockstate.m_60812_((BlockGetter)this.m_9236_(), p_201942_).m_83216_((double)p_201942_.m_123341_(), (double)p_201942_.m_123342_(), (double)p_201942_.m_123343_()), (VoxelShape)Shapes.m_83064_((AABB)aabb), (BooleanOp)BooleanOp.f_82689_);
        });
    }

    public void m_146922_(float pYRot) {
        if (Float.isFinite(pYRot)) {
            this.goalYRot = pYRot;
        }
    }

    public void setYRotImmediate(float pYRot) {
        if (Float.isFinite(pYRot)) {
            super.m_146922_(pYRot);
            this.goalYRot = pYRot;
        }
    }

    protected float rotateTowards(float pFrom, float pTo, float pMaxDelta) {
        float difference = Mth.m_14118_((float)pFrom, (float)pTo);
        float clamped = Mth.m_14036_((float)difference, (float)(-pMaxDelta), (float)pMaxDelta);
        return pFrom + clamped;
    }

    public double m_20204_() {
        return 3.0;
    }
}

