/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.entity.chasmfiend.goal;

import java.util.EnumSet;
import java.util.List;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import us.amon.stormward.effect.StormwardEffects;
import us.amon.stormward.entity.chasmfiend.Chasmfiend;
import us.amon.stormward.entity.chasmfiend.goal.ChasmfiendAbilityGoal;

public class RoarAttackGoal
extends ChasmfiendAbilityGoal {
    private final double range;
    List<LivingEntity> targets;

    public RoarAttackGoal(Chasmfiend pChasmfiend, int pActiveTicks, int pCooldownTicks, double pRange) {
        super(pChasmfiend, pActiveTicks, pCooldownTicks);
        this.range = pRange;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
    }

    @Override
    public boolean m_8036_() {
        if (!super.m_8036_() || this.chasmfiend.isDiggingOrEmerging()) {
            return false;
        }
        LivingEntity target = this.chasmfiend.m_5448_();
        if (target != null && this.chasmfiend.m_217066_(target) && this.chasmfiend.m_21574_().m_148306_((Entity)target)) {
            return false;
        }
        this.targets = this.getTargetsInRange(this.range);
        return this.getNumEnemies(this.targets) > 0;
    }

    @Override
    public void m_8056_() {
        super.m_8056_();
        this.chasmfiend.setRoaring(true);
        for (LivingEntity target : this.targets) {
            if (target instanceof Chasmfiend) continue;
            this.increaseEffect(target, (MobEffect)StormwardEffects.TERROR.get(), 4);
        }
        this.chasmfiend.playRoarSound();
    }

    public void increaseEffect(LivingEntity pTarget, MobEffect pEffect, int pMax) {
        MobEffectInstance instance = pTarget.m_21124_(pEffect);
        int amplifier = instance != null ? Math.min(instance.m_19564_() + 1, pMax) : 0;
        pTarget.m_7292_(new MobEffectInstance(pEffect, 600, amplifier));
    }

    @Override
    public void m_8041_() {
        super.m_8041_();
        this.chasmfiend.setRoaring(false);
    }
}

