/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.entity.client.layer;

import com.google.common.collect.ImmutableMap;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Map;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.item.DyeableHorseArmorItem;
import net.minecraft.world.item.HorseArmorItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import org.jetbrains.annotations.NotNull;
import us.amon.stormward.entity.Ryshadium;
import us.amon.stormward.entity.client.model.RyshadiumModel;

public class RyshadiumArmorLayer
extends RenderLayer<Ryshadium, RyshadiumModel<Ryshadium>> {
    private static final Map<Item, ResourceLocation> LOCATION_BY_MARKINGS = ImmutableMap.of((Object)Items.f_42654_, (Object)new ResourceLocation("stormward", "textures/entity/ryshadium/armor/leather.png"), (Object)Items.f_42651_, (Object)new ResourceLocation("stormward", "textures/entity/ryshadium/armor/iron.png"), (Object)Items.f_42652_, (Object)new ResourceLocation("stormward", "textures/entity/ryshadium/armor/gold.png"), (Object)Items.f_42653_, (Object)new ResourceLocation("stormward", "textures/entity/ryshadium/armor/diamond.png"));
    private final RyshadiumModel<Ryshadium> model;

    public RyshadiumArmorLayer(RenderLayerParent<Ryshadium, RyshadiumModel<Ryshadium>> pRenderer, EntityModelSet pModelSet) {
        super(pRenderer);
        this.model = new RyshadiumModel(pModelSet.m_171103_(RyshadiumModel.ARMOR_LAYER_LOCATION));
    }

    public void render(@NotNull PoseStack pPoseStack, @NotNull MultiBufferSource pBuffer, int pPackedLight, Ryshadium pLivingEntity, float pLimbSwing, float pLimbSwingAmount, float pPartialTicks, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        HorseArmorItem item;
        ItemStack itemstack = pLivingEntity.m_30722_();
        Item item2 = itemstack.m_41720_();
        if (item2 instanceof HorseArmorItem && LOCATION_BY_MARKINGS.containsKey(item = (HorseArmorItem)item2)) {
            float b;
            float g;
            float r;
            ((RyshadiumModel)this.m_117386_()).m_102624_((EntityModel)this.model);
            this.model.prepareMobModel(pLivingEntity, pLimbSwing, pLimbSwingAmount, pPartialTicks);
            this.model.m_6973_((AbstractHorse)pLivingEntity, pLimbSwing, pLimbSwingAmount, pAgeInTicks, pNetHeadYaw, pHeadPitch);
            if (item instanceof DyeableHorseArmorItem) {
                int i = ((DyeableHorseArmorItem)item).m_41121_(itemstack);
                r = (float)(i >> 16 & 0xFF) / 255.0f;
                g = (float)(i >> 8 & 0xFF) / 255.0f;
                b = (float)(i & 0xFF) / 255.0f;
            } else {
                r = 1.0f;
                g = 1.0f;
                b = 1.0f;
            }
            VertexConsumer vertexconsumer = pBuffer.m_6299_(RenderType.m_110458_((ResourceLocation)LOCATION_BY_MARKINGS.get(item)));
            this.model.m_7695_(pPoseStack, vertexconsumer, pPackedLight, OverlayTexture.f_118083_, r, g, b, 1.0f);
        }
    }
}

