/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.entity.client.layer;

import com.google.common.collect.Maps;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Map;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.Model;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.armortrim.ArmorTrim;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import org.jetbrains.annotations.NotNull;
import us.amon.stormward.capability.StormwardCapabilities;
import us.amon.stormward.capability.stormlightstorage.StormlightStorageHelper;
import us.amon.stormward.entity.client.model.ShardplateModel;
import us.amon.stormward.item.armor.ShardplateItem;
import us.amon.stormward.shader.StormwardRenderTypes;
import us.amon.stormward.util.IArmorTrim;

@OnlyIn(value=Dist.CLIENT)
public class ShardplateLayer<T extends LivingEntity, M extends HumanoidModel<T>>
extends RenderLayer<T, M> {
    private static final Map<String, ResourceLocation> ARMOR_LOCATION_CACHE = Maps.newHashMap();
    private final ShardplateModel<T> model;
    private final TextureAtlas armorTrimAtlas;

    public ShardplateLayer(RenderLayerParent<T, M> pRenderer, EntityModelSet pModelSet, ModelManager pModelManager) {
        super(pRenderer);
        this.model = new ShardplateModel(pModelSet.m_171103_(ShardplateModel.LAYER_LOCATION));
        this.armorTrimAtlas = pModelManager.m_119428_(Sheets.f_265912_);
    }

    public void render(@NotNull PoseStack pPoseStack, @NotNull MultiBufferSource pBuffer, int pPackedLight, @NotNull T pLivingEntity, float pLimbSwing, float pLimbSwingAmount, float pPartialTicks, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        this.renderArmorPiece(pPoseStack, pBuffer, pLivingEntity, EquipmentSlot.CHEST, pPackedLight);
        this.renderArmorPiece(pPoseStack, pBuffer, pLivingEntity, EquipmentSlot.LEGS, pPackedLight);
        this.renderArmorPiece(pPoseStack, pBuffer, pLivingEntity, EquipmentSlot.FEET, pPackedLight);
        this.renderArmorPiece(pPoseStack, pBuffer, pLivingEntity, EquipmentSlot.HEAD, pPackedLight);
    }

    private void renderArmorPiece(PoseStack pPoseStack, MultiBufferSource pBuffer, T pLivingEntity, EquipmentSlot pSlot, int pPackedLight) {
        ShardplateItem shardplateItem;
        Item item;
        ItemStack stack = pLivingEntity.m_6844_(pSlot);
        if (!StormlightStorageHelper.isDun((ICapabilityProvider)stack) && (item = stack.m_41720_()) instanceof ShardplateItem && (shardplateItem = (ShardplateItem)item).m_40402_() == pSlot) {
            ((HumanoidModel)this.m_117386_()).m_102872_(this.model);
            this.model.waist.m_104315_(((HumanoidModel)this.m_117386_()).f_102810_);
            this.model.rightFoot.m_104315_(((HumanoidModel)this.m_117386_()).f_102813_);
            this.model.leftFoot.m_104315_(((HumanoidModel)this.m_117386_()).f_102814_);
            this.model.waist.f_104204_ = this.model.f_102813_.f_104203_ * 0.1f;
            if (pLivingEntity.m_6047_()) {
                this.model.waist.f_104203_ *= 0.33f;
                this.model.waist.f_104201_ -= 2.5f;
                this.model.waist.f_104202_ += 2.75f;
            }
            this.setPartVisibility(this.model, pSlot);
            this.renderModel(pPoseStack, pBuffer, pPackedLight, (Model)this.model, shardplateItem.m_40401_());
            ArmorTrim.m_266285_((RegistryAccess)pLivingEntity.m_9236_().m_9598_(), (ItemStack)stack, (boolean)true).ifPresent(pTrim -> this.renderTrim(pPoseStack, pBuffer, pPackedLight, (Model)this.model, (ArmorTrim)pTrim, shardplateItem.m_40401_()));
            stack.getCapability(StormwardCapabilities.STORMLIGHT).ifPresent(stormlightStorage -> {
                if (!stormlightStorage.isFull()) {
                    float stormlightPercent = (float)stormlightStorage.getStormlight() / (float)stormlightStorage.getMaxStormlight();
                    int destroyStage = (int)((1.0f - stormlightPercent) * 10.0f);
                    this.renderDamage(pPoseStack, pBuffer, pPackedLight, (Model)this.model, destroyStage);
                }
            });
            if (stack.m_41790_()) {
                this.renderGlint(pPoseStack, pBuffer, pPackedLight, (Model)this.model);
            }
        }
    }

    protected void setPartVisibility(ShardplateModel<T> pModel, EquipmentSlot pSlot) {
        pModel.m_8009_(false);
        switch (pSlot) {
            case HEAD: {
                pModel.f_102808_.f_104207_ = true;
                pModel.f_102809_.f_104207_ = true;
                break;
            }
            case CHEST: {
                pModel.f_102810_.f_104207_ = true;
                pModel.f_102811_.f_104207_ = true;
                pModel.f_102812_.f_104207_ = true;
                break;
            }
            case LEGS: {
                pModel.waist.f_104207_ = true;
                pModel.f_102813_.f_104207_ = true;
                pModel.f_102814_.f_104207_ = true;
                break;
            }
            case FEET: {
                pModel.rightFoot.f_104207_ = true;
                pModel.leftFoot.f_104207_ = true;
            }
        }
    }

    private void renderModel(PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight, Model pModel, ArmorMaterial material) {
        ResourceLocation location = this.getShardplateResource(String.format("textures/models/shardplate/%s.png", material.m_6082_()));
        VertexConsumer vertexconsumer = pBuffer.m_6299_(RenderType.m_110431_((ResourceLocation)location));
        pModel.m_7695_(pPoseStack, vertexconsumer, pPackedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    private void renderDamage(PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight, Model pModel, int damageStage) {
        ResourceLocation location = this.getShardplateResource(String.format("textures/models/shardplate/destroy_stage_%s.png", damageStage));
        VertexConsumer vertexconsumer = pBuffer.m_6299_(StormwardRenderTypes.shardplateCrumbling(location));
        pModel.m_7695_(pPoseStack, vertexconsumer, pPackedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
    }

    private void renderTrim(PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight, Model pModel, ArmorTrim pTrim, ArmorMaterial material) {
        if (pTrim instanceof IArmorTrim) {
            IArmorTrim trim = (IArmorTrim)pTrim;
            TextureAtlasSprite textureatlassprite = this.armorTrimAtlas.m_118316_(trim.stormward$shardplateTexture(material));
            VertexConsumer vertexconsumer = textureatlassprite.m_118381_(pBuffer.m_6299_(StormwardRenderTypes.shardplateTrim()));
            pModel.m_7695_(pPoseStack, vertexconsumer, pPackedLight, OverlayTexture.f_118083_, 1.0f, 1.0f, 1.0f, 1.0f);
        }
    }

    private void renderGlint(PoseStack pPoseStack, MultiBufferSource pBuffer, int pPackedLight, Model pModel) {
        pModel.m_7695_(pPoseStack, pBuffer.m_6299_(RenderType.m_110484_()), pPackedLight, OverlayTexture.f_118083_, 0.5f, 1.0f, 1.0f, 1.0f);
    }

    public ResourceLocation getShardplateResource(String path) {
        ResourceLocation resourceLocation = ARMOR_LOCATION_CACHE.get(path);
        if (resourceLocation == null) {
            resourceLocation = new ResourceLocation("stormward", path);
            ARMOR_LOCATION_CACHE.put(path, resourceLocation);
        }
        return resourceLocation;
    }
}

