/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.entity.client.model;

import com.google.common.collect.ImmutableList;
import net.minecraft.client.model.AgeableListModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;
import us.amon.stormward.entity.Axehound;

public class AxehoundModel<T extends Axehound>
extends AgeableListModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("stormward", "axehound"), "main");
    private final ModelPart root;
    private final ModelPart body;
    private final ModelPart head;
    private final ModelPart leftAntenna;
    private final ModelPart rightAntenna;
    private final ModelPart tail;
    private final ModelPart leftFrontLeg;
    private final ModelPart rightFrontLeg;
    private final ModelPart leftMidLeg;
    private final ModelPart rightMidLeg;
    private final ModelPart leftBackLeg;
    private final ModelPart rightBackLeg;

    public AxehoundModel(ModelPart pRoot) {
        super(false, 7.0f, 4.5f, 2.0f, 2.0f, 24.0f);
        this.root = pRoot;
        this.body = pRoot.m_171324_("body");
        this.head = pRoot.m_171324_("head");
        this.leftAntenna = this.head.m_171324_("leftAntenna");
        this.rightAntenna = this.head.m_171324_("rightAntenna");
        this.tail = pRoot.m_171324_("tail");
        this.leftFrontLeg = pRoot.m_171324_("leftFrontLeg");
        this.rightFrontLeg = pRoot.m_171324_("rightFrontLeg");
        this.leftMidLeg = pRoot.m_171324_("leftMidLeg");
        this.rightMidLeg = pRoot.m_171324_("rightMidLeg");
        this.leftBackLeg = pRoot.m_171324_("leftBackLeg");
        this.rightBackLeg = pRoot.m_171324_("rightBackLeg");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 12).m_171488_(-5.0f, -1.0f, 4.0f, 8.0f, 9.0f, 9.0f, new CubeDeformation(0.0f)).m_171514_(34, 16).m_171488_(-4.0f, 0.0f, 13.0f, 6.0f, 6.0f, 8.0f, new CubeDeformation(0.0f)).m_171514_(0, 29).m_171488_(-1.0f, -4.0f, 4.0f, 0.0f, 4.0f, 17.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)1.0f, (float)8.0f, (float)-13.0f));
        PartDefinition head = partdefinition.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -3.0f, -7.0f, 6.0f, 5.0f, 7.0f, new CubeDeformation(0.0f)).m_171514_(26, -7).m_171488_(-1.0f, -6.0f, -7.0f, 0.0f, 3.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)1.0f, (float)11.0f, (float)-9.0f));
        PartDefinition leftAntenna = head.m_171599_("leftAntenna", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)0.0f, (float)-3.0f, (float)-4.0f, (float)0.0f, (float)0.2618f, (float)0.0f));
        PartDefinition cube_r1 = leftAntenna.m_171599_("cube_r1", CubeListBuilder.m_171558_().m_171514_(13, 0).m_171488_(-1.0f, 0.0f, 0.0f, 3.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.7395f, (float)-0.2261f, (float)0.5387f));
        PartDefinition rightAntenna = head.m_171599_("rightAntenna", CubeListBuilder.m_171558_(), PartPose.m_171423_((float)-2.0f, (float)-3.0f, (float)-4.0f, (float)0.0f, (float)-0.2618f, (float)0.0f));
        PartDefinition cube_r2 = rightAntenna.m_171599_("cube_r2", CubeListBuilder.m_171558_().m_171514_(13, 0).m_171480_().m_171488_(-2.0f, 0.0f, 0.0f, 3.0f, 0.0f, 7.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)0.0f, (float)0.0f, (float)0.0f, (float)0.7395f, (float)0.2261f, (float)-0.5387f));
        PartDefinition tail = partdefinition.m_171599_("tail", CubeListBuilder.m_171558_().m_171514_(34, 30).m_171488_(-2.5f, -1.0f, 0.0f, 3.0f, 3.0f, 9.0f, new CubeDeformation(0.0f)).m_171514_(26, 42).m_171488_(-5.5f, 0.0f, 5.0f, 9.0f, 0.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)1.0f, (float)10.0f, (float)8.0f));
        PartDefinition leftFrontLeg = partdefinition.m_171599_("leftFrontLeg", CubeListBuilder.m_171558_().m_171514_(22, 30).m_171488_(-2.0f, -1.5f, -1.5f, 3.0f, 13.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)4.0f, (float)12.5f, (float)-5.5f));
        PartDefinition rightFrontLeg = partdefinition.m_171599_("rightFrontLeg", CubeListBuilder.m_171558_().m_171514_(22, 30).m_171480_().m_171488_(-1.0f, -1.5f, -1.5f, 3.0f, 13.0f, 3.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-4.0f, (float)12.5f, (float)-5.5f));
        PartDefinition leftMidLeg = partdefinition.m_171599_("leftMidLeg", CubeListBuilder.m_171558_().m_171514_(22, 30).m_171488_(-2.0f, -1.5f, -1.5f, 3.0f, 13.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)4.0f, (float)12.5f, (float)-0.5f));
        PartDefinition rightMidLeg = partdefinition.m_171599_("rightMidLeg", CubeListBuilder.m_171558_().m_171514_(22, 30).m_171480_().m_171488_(-1.0f, -1.5f, -1.5f, 3.0f, 13.0f, 3.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-4.0f, (float)12.5f, (float)-0.5f));
        PartDefinition leftBackLeg = partdefinition.m_171599_("leftBackLeg", CubeListBuilder.m_171558_().m_171514_(22, 30).m_171488_(-2.0f, -1.5f, -1.5f, 3.0f, 13.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)3.0f, (float)12.5f, (float)5.5f));
        PartDefinition rightBackLeg = partdefinition.m_171599_("rightBackLeg", CubeListBuilder.m_171558_().m_171514_(22, 30).m_171480_().m_171488_(-1.0f, -1.5f, -1.5f, 3.0f, 13.0f, 3.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-3.0f, (float)12.5f, (float)5.5f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void setupAnim(@NotNull T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float degToRad = (float)Math.PI / 180;
        this.root.m_171331_().forEach(ModelPart::m_233569_);
        this.head.f_104203_ += headPitch * degToRad;
        this.head.f_104204_ += netHeadYaw * degToRad;
        if (entity.m_21660_()) {
            this.leftAntenna.f_104203_ -= 20.0f * degToRad;
            this.leftAntenna.f_104204_ -= 10.0f * degToRad;
            this.leftAntenna.f_104205_ -= 20.0f * degToRad;
            this.rightAntenna.f_104203_ -= 20.0f * degToRad;
            this.rightAntenna.f_104204_ += 10.0f * degToRad;
            this.rightAntenna.f_104205_ += 20.0f * degToRad;
            this.tail.f_104204_ += Mth.m_14089_((float)(limbSwing * 0.6662f)) * 1.4f * limbSwingAmount;
        } else {
            this.animateAntennae(this.rightAntenna, this.leftAntenna, ageInTicks);
        }
        if (entity.m_21825_()) {
            if (entity.m_6162_()) {
                this.head.f_104201_ -= 4.0f;
                this.head.f_104202_ += 4.0f;
            } else {
                this.head.f_104201_ -= 5.5f;
                this.head.f_104202_ += 8.0f;
            }
            this.body.f_104201_ -= 6.0f;
            this.body.f_104202_ += 11.0f;
            this.body.f_104203_ -= 65.0f * degToRad;
            this.tail.f_104201_ += 12.0f;
            this.tail.f_104202_ -= 4.0f;
            this.leftBackLeg.f_104201_ += 10.0f;
            this.leftBackLeg.f_104202_ -= 3.0f;
            this.leftBackLeg.f_104203_ -= 90.0f * degToRad;
            this.leftBackLeg.f_104204_ -= 15.0f * degToRad;
            this.rightBackLeg.f_104201_ += 10.0f;
            this.rightBackLeg.f_104202_ -= 3.0f;
            this.rightBackLeg.f_104203_ -= 90.0f * degToRad;
            this.rightBackLeg.f_104204_ += 15.0f * degToRad;
            this.leftMidLeg.f_104201_ += 2.0f;
            this.leftMidLeg.f_104202_ += 1.0f;
            this.leftMidLeg.f_104203_ -= 45.0f * degToRad;
            this.leftMidLeg.f_104204_ += 7.0f * degToRad;
            this.leftMidLeg.f_104205_ += 7.0f * degToRad;
            this.rightMidLeg.f_104201_ += 2.0f;
            this.rightMidLeg.f_104202_ += 1.0f;
            this.rightMidLeg.f_104203_ -= 45.0f * degToRad;
            this.rightMidLeg.f_104204_ -= 7.0f * degToRad;
            this.rightMidLeg.f_104205_ -= 7.0f * degToRad;
            this.leftFrontLeg.f_104201_ -= 2.0f;
            this.leftFrontLeg.f_104202_ += 3.0f;
            this.leftFrontLeg.f_104203_ -= 30.0f * degToRad;
            this.rightFrontLeg.f_104201_ -= 2.0f;
            this.rightFrontLeg.f_104202_ += 3.0f;
            this.rightFrontLeg.f_104203_ -= 30.0f * degToRad;
        } else {
            this.walkLeg(this.rightFrontLeg, limbSwing, limbSwingAmount, 0.0f);
            this.walkLeg(this.rightMidLeg, limbSwing, limbSwingAmount, 5.2359877f);
            this.walkLeg(this.rightBackLeg, limbSwing, limbSwingAmount, 4.1887903f);
            this.walkLeg(this.leftFrontLeg, limbSwing, limbSwingAmount, (float)Math.PI);
            this.walkLeg(this.leftMidLeg, limbSwing, limbSwingAmount, 2.0943952f);
            this.walkLeg(this.leftBackLeg, limbSwing, limbSwingAmount, 1.0471976f);
            this.tail.f_104203_ = ((Axehound)entity).getTailAngle();
            this.tail.f_104204_ = Mth.m_14089_((float)(limbSwing * 0.6662f)) * 0.8f * limbSwingAmount;
        }
    }

    private void animateAntennae(ModelPart pRight, ModelPart pLeft, float pAgeInTicks) {
        float t = pAgeInTicks % 120.0f;
        float flickerTime = 20.0f;
        float antennae = Mth.m_14031_((float)(t * 2.0f)) * Math.max(0.0f, flickerTime - t) / flickerTime * 0.5f;
        pLeft.f_104203_ += (antennae += Mth.m_14089_((float)(pAgeInTicks * 0.1f)) * 0.1f);
        pRight.f_104203_ += antennae;
    }

    private void walkLeg(ModelPart pLeg, float pLimbSwing, float pLimbSwingAmount, float pTheta) {
        pLeg.f_104203_ += Mth.m_14089_((float)(pLimbSwing * 0.9f + pTheta)) * 0.7f * pLimbSwingAmount * 0.5f;
    }

    @NotNull
    protected Iterable<ModelPart> m_5607_() {
        return ImmutableList.of((Object)this.head);
    }

    @NotNull
    protected Iterable<ModelPart> m_5608_() {
        return ImmutableList.of((Object)this.body, (Object)this.tail, (Object)this.leftFrontLeg, (Object)this.leftMidLeg, (Object)this.leftBackLeg, (Object)this.rightFrontLeg, (Object)this.rightMidLeg, (Object)this.rightBackLeg);
    }
}

