/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.entity.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import us.amon.stormward.entity.spren.overworld.Gravitationspren;

public class GravitationsprenModel<T extends Gravitationspren>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("stormward", "gravitationspren"), "main");
    private final ModelPart body;
    private final ModelPart satellite1;
    private final ModelPart satellite2;

    public GravitationsprenModel(ModelPart root) {
        super(RenderType::m_110446_);
        this.body = root.m_171324_("body");
        this.satellite1 = this.body.m_171324_("satellite1");
        this.satellite2 = this.body.m_171324_("satellite2");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-1.0f, -1.0f, -1.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)20.5f, (float)0.0f));
        PartDefinition satellite1 = body.m_171599_("satellite1", CubeListBuilder.m_171558_().m_171514_(0, 4).m_171488_(-1.25f, -0.5f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)3.0f, (float)0.0f, (float)0.0f));
        PartDefinition satellite2 = body.m_171599_("satellite2", CubeListBuilder.m_171558_().m_171514_(0, 6).m_171488_(-0.5f, -1.0f, -0.5f, 1.0f, 1.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)3.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)8, (int)8);
    }

    public void setupAnim(@NotNull T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.body.m_171331_().forEach(ModelPart::m_233569_);
        this.body.f_104201_ += (float)Math.cos(ageInTicks * 9.0f * ((float)Math.PI / 180)) * 0.25f - 1.5f;
        this.body.f_104203_ = headPitch * ((float)Math.PI / 180) * 0.5f;
        this.body.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
        this.satellite1.f_104200_ = 2.5f * (float)Math.cos(ageInTicks * 0.2f);
        this.satellite1.f_104201_ = 2.5f * (float)Math.sin(ageInTicks * 0.2f);
        this.satellite2.f_104202_ = 2.5f * (float)Math.cos((double)(ageInTicks * 0.2f) + Math.PI);
        this.satellite2.f_104201_ = 2.5f * (float)Math.sin((double)(ageInTicks * 0.2f) + Math.PI);
    }

    public void m_7695_(@NotNull PoseStack poseStack, @NotNull VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.body.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }
}

