/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.entity.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;
import us.amon.stormward.entity.spren.overworld.Hungerspren;

public class HungersprenModel<T extends Hungerspren>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("stormward", "hungerspren"), "main");
    private final ModelPart body;
    private final ModelPart rightWing;
    private final ModelPart leftWing;

    public HungersprenModel(ModelPart root) {
        super(RenderType::m_110446_);
        this.body = root.m_171324_("body");
        this.rightWing = this.body.m_171324_("right_wing");
        this.leftWing = this.body.m_171324_("left_wing");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-1.0f, -1.0f, -1.0f, 2.0f, 2.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)23.0f, (float)0.0f));
        PartDefinition right_wing = body.m_171599_("right_wing", CubeListBuilder.m_171558_().m_171514_(-1, 4).m_171488_(-2.0f, 0.0f, -0.5f, 2.0f, 0.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-1.5f, (float)-0.5f, (float)0.0f));
        PartDefinition left_wing = body.m_171599_("left_wing", CubeListBuilder.m_171558_().m_171514_(-1, 5).m_171488_(0.0f, 0.0f, -0.5f, 2.0f, 0.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)1.5f, (float)-0.5f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)8, (int)8);
    }

    public void setupAnim(@NotNull Hungerspren entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.body.m_171331_().forEach(ModelPart::m_233569_);
        this.body.f_104201_ += (float)Math.cos(ageInTicks * 9.0f * ((float)Math.PI / 180)) * 0.25f - 1.5f;
        this.body.f_104203_ = headPitch * ((float)Math.PI / 180);
        this.body.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
        float f = ageInTicks * 120.32113f * ((float)Math.PI / 180);
        this.rightWing.f_104204_ = 0.5f;
        this.rightWing.f_104205_ = Mth.m_14089_((float)f) * (float)Math.PI * 0.15f;
        this.leftWing.f_104203_ = this.rightWing.f_104203_;
        this.leftWing.f_104204_ = -this.rightWing.f_104204_;
        this.leftWing.f_104205_ = -this.rightWing.f_104205_;
    }

    public void m_7695_(@NotNull PoseStack poseStack, @NotNull VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.body.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }
}

