/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.entity.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import org.jetbrains.annotations.NotNull;
import us.amon.stormward.entity.spren.overworld.Painspren;

public class PainsprenModel<T extends Painspren>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("stormward", "painspren"), "main");
    private final ModelPart body;
    private final ModelPart palm;
    private final ModelPart thumb;
    private final ModelPart index;
    private final ModelPart middle;
    private final ModelPart ring;

    public PainsprenModel(ModelPart root) {
        super(RenderType::m_110446_);
        this.body = root.m_171324_("body");
        this.palm = this.body.m_171324_("palm");
        this.thumb = this.palm.m_171324_("thumb");
        this.index = this.palm.m_171324_("index");
        this.middle = this.palm.m_171324_("middle");
        this.ring = this.palm.m_171324_("ring");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-1.0f, -2.0f, -0.5f, 2.0f, 2.0f, 1.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)24.0f, (float)0.0f));
        PartDefinition palm = body.m_171599_("palm", CubeListBuilder.m_171558_().m_171514_(0, 3).m_171488_(-1.5f, -2.0f, 0.0f, 3.0f, 2.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-2.0f, (float)0.0f));
        PartDefinition thumb = palm.m_171599_("thumb", CubeListBuilder.m_171558_().m_171514_(0, 7).m_171488_(-1.0f, -0.5f, 0.0f, 1.0f, 1.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-1.5f, (float)-0.5f, (float)0.0f));
        PartDefinition index = palm.m_171599_("index", CubeListBuilder.m_171558_().m_171514_(0, 5).m_171488_(-1.0f, -2.0f, 0.0f, 1.0f, 2.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-0.5f, (float)-2.0f, (float)0.0f));
        PartDefinition middle = palm.m_171599_("middle", CubeListBuilder.m_171558_().m_171514_(2, 5).m_171488_(-0.5f, -2.0f, 0.0f, 1.0f, 2.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)-2.0f, (float)0.0f));
        PartDefinition ring = palm.m_171599_("ring", CubeListBuilder.m_171558_().m_171514_(4, 5).m_171488_(0.0f, -2.0f, 0.0f, 1.0f, 2.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.5f, (float)-2.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)8, (int)8);
    }

    public void setupAnim(@NotNull Painspren entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.body.m_171331_().forEach(ModelPart::m_233569_);
        float animTime = ageInTicks * 0.15f;
        this.body.f_104203_ = (float)Math.sin(animTime) * -0.5f;
        this.body.f_104205_ = (float)Math.cos(animTime) * 0.25f;
        this.palm.f_104203_ = (float)Math.sin(animTime - 1.0f) * -0.75f;
        this.index.f_104203_ = (float)(Math.sin(animTime - 2.0f) - 1.0) * -0.75f;
        this.index.f_104205_ = -0.2f;
        this.middle.f_104203_ = (float)(Math.sin(animTime - 2.0f) - 1.0) * -0.75f;
        this.ring.f_104203_ = (float)(Math.sin(animTime - 2.0f) - 1.0) * -0.75f;
        this.ring.f_104205_ = 0.2f;
        this.thumb.f_104204_ = (float)(Math.sin(animTime - 2.0f) - 1.0) * 0.75f;
    }

    public void m_7695_(@NotNull PoseStack poseStack, @NotNull VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.body.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }
}

