/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.entity.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;
import us.amon.stormward.entity.spren.overworld.Riverspren;

public class RiversprenModel<T extends Riverspren>
extends EntityModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("stormward", "riverspren"), "main");
    private final ModelPart body;
    private final ModelPart middle;
    private final ModelPart tail;

    public RiversprenModel(ModelPart root) {
        super(RenderType::m_110452_);
        this.body = root.m_171324_("body");
        this.middle = this.body.m_171324_("middle");
        this.tail = this.middle.m_171324_("tail");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-0.5f, -1.5f, -1.5f, 1.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(10, 1).m_171488_(0.0f, -2.5f, -0.5f, 0.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)22.5f, (float)0.0f));
        PartDefinition middle = body.m_171599_("middle", CubeListBuilder.m_171558_().m_171514_(0, 7).m_171488_(-0.5f, -1.5f, 0.0f, 1.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(10, 2).m_171488_(0.0f, -2.5f, 0.0f, 0.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)2.5f));
        PartDefinition tail = middle.m_171599_("tail", CubeListBuilder.m_171558_().m_171514_(8, -4).m_171488_(0.0f, -1.5f, 0.0f, 0.0f, 3.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)0.0f, (float)4.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)16, (int)16);
    }

    public void setupAnim(@NotNull Riverspren entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.body.m_171331_().forEach(ModelPart::m_233569_);
        this.body.f_104201_ += (float)Math.cos(ageInTicks * 9.0f * ((float)Math.PI / 180)) * 0.25f - 1.5f;
        this.body.f_104203_ = headPitch * ((float)Math.PI / 180);
        this.body.f_104204_ = netHeadYaw * ((float)Math.PI / 180);
        this.body.f_104204_ -= 0.45f * Mth.m_14031_((float)(0.3f * ageInTicks));
        this.middle.f_104204_ = 0.45f * Mth.m_14031_((float)(0.3f * ageInTicks + 1.0f));
        this.tail.f_104204_ = 0.45f * Mth.m_14031_((float)(0.3f * ageInTicks + 2.0f));
    }

    public void m_7695_(@NotNull PoseStack poseStack, @NotNull VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.body.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }
}

