/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.entity.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.model.AnimationUtils;
import net.minecraft.client.model.ArmedModel;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HeadedModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.HumanoidArm;
import org.jetbrains.annotations.NotNull;
import us.amon.stormward.entity.thaylenmerchant.ThaylenMerchant;

public class ThaylenMerchantModel<T extends ThaylenMerchant>
extends EntityModel<T>
implements ArmedModel,
HeadedModel {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("stormward", "thaylen_merchant"), "main");
    private final ModelPart body;
    private final ModelPart head;
    private final ModelPart rightArm;
    private final ModelPart leftArm;
    private final ModelPart rightLeg;
    private final ModelPart leftLeg;
    private final ModelPart nose;

    public ThaylenMerchantModel(ModelPart root) {
        this.body = root.m_171324_("body");
        this.head = this.body.m_171324_("head");
        this.rightArm = this.body.m_171324_("rightArm");
        this.leftArm = this.body.m_171324_("leftArm");
        this.rightLeg = this.body.m_171324_("rightLeg");
        this.leftLeg = this.body.m_171324_("leftLeg");
        this.nose = this.head.m_171324_("nose");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(16, 20).m_171488_(-3.0f, -12.0f, -3.0f, 8.0f, 12.0f, 6.0f, new CubeDeformation(0.0f)).m_171514_(0, 38).m_171488_(-3.0f, -12.0f, -3.0f, 8.0f, 20.0f, 6.0f, new CubeDeformation(0.5f)), PartPose.m_171419_((float)-1.0f, (float)12.0f, (float)0.0f));
        PartDefinition head = body.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-4.0f, -10.0f, -4.0f, 8.0f, 10.0f, 8.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)1.0f, (float)-12.0f, (float)0.0f));
        PartDefinition rightBrow_r1 = head.m_171599_("rightBrow_r1", CubeListBuilder.m_171558_().m_171514_(32, 12).m_171480_().m_171488_(-4.0f, -6.0f, 0.0f, 4.0f, 6.0f, 0.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)-4.0f, (float)0.0f, (float)-4.0f, (float)0.0f, (float)0.3927f, (float)0.0f));
        PartDefinition leftBrow_r1 = head.m_171599_("leftBrow_r1", CubeListBuilder.m_171558_().m_171514_(32, 12).m_171488_(0.0f, -6.0f, 0.0f, 4.0f, 6.0f, 0.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)4.0f, (float)0.0f, (float)-4.0f, (float)0.0f, (float)-0.3927f, (float)0.0f));
        PartDefinition nose = head.m_171599_("nose", CubeListBuilder.m_171558_().m_171514_(24, 0).m_171481_(-1.0f, -1.0f, -6.0f, 2.0f, 4.0f, 2.0f), PartPose.m_171419_((float)0.0f, (float)-2.0f, (float)0.0f));
        PartDefinition rightArm = body.m_171599_("rightArm", CubeListBuilder.m_171558_().m_171514_(44, 22).m_171488_(-3.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(44, 38).m_171488_(-3.0f, -2.0f, -2.0f, 4.0f, 10.0f, 4.0f, new CubeDeformation(0.5f)), PartPose.m_171419_((float)-4.0f, (float)-10.0f, (float)0.0f));
        PartDefinition leftArm = body.m_171599_("leftArm", CubeListBuilder.m_171558_().m_171514_(44, 22).m_171488_(-1.0f, -2.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(44, 38).m_171480_().m_171488_(-1.0f, -2.0f, -2.0f, 4.0f, 10.0f, 4.0f, new CubeDeformation(0.5f)).m_171555_(false), PartPose.m_171419_((float)6.0f, (float)-10.0f, (float)0.0f));
        PartDefinition rightLeg = body.m_171599_("rightLeg", CubeListBuilder.m_171558_().m_171514_(0, 22).m_171488_(-2.1f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)-0.9f, (float)0.0f, (float)0.0f));
        PartDefinition leftLeg = body.m_171599_("leftLeg", CubeListBuilder.m_171558_().m_171514_(0, 22).m_171480_().m_171488_(-1.9f, 0.0f, -2.0f, 4.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)2.9f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)64, (int)64);
    }

    public void m_7695_(@NotNull PoseStack poseStack, @NotNull VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        this.body.m_104306_(poseStack, vertexConsumer, packedLight, packedOverlay, red, green, blue, alpha);
    }

    public void m_6002_(@NotNull HumanoidArm pSide, @NotNull PoseStack pPoseStack) {
        this.body.m_104299_(pPoseStack);
        this.getArm(pSide).m_104299_(pPoseStack);
    }

    protected ModelPart getArm(HumanoidArm pSide) {
        return pSide == HumanoidArm.LEFT ? this.leftArm : this.rightArm;
    }

    @NotNull
    public ModelPart m_5585_() {
        return this.head;
    }

    public void setupAnim(@NotNull T pEntity, float pLimbSwing, float pLimbSwingAmount, float pAgeInTicks, float pNetHeadYaw, float pHeadPitch) {
        this.head.f_104204_ = pNetHeadYaw * ((float)Math.PI / 180);
        this.head.f_104203_ = pHeadPitch * ((float)Math.PI / 180);
        this.head.f_104205_ = 0.0f;
        this.rightArm.f_104203_ = Mth.m_14089_((float)(pLimbSwing * 0.6662f + (float)Math.PI)) * 2.0f * pLimbSwingAmount * 0.5f;
        this.leftArm.f_104203_ = Mth.m_14089_((float)(pLimbSwing * 0.6662f)) * 2.0f * pLimbSwingAmount * 0.5f;
        this.rightArm.f_104205_ = 0.0f;
        this.leftArm.f_104205_ = 0.0f;
        this.rightArm.f_104204_ = 0.0f;
        this.leftArm.f_104204_ = 0.0f;
        this.rightLeg.f_104203_ = Mth.m_14089_((float)(pLimbSwing * 0.6662f)) * 1.4f * pLimbSwingAmount * 0.5f;
        this.leftLeg.f_104203_ = Mth.m_14089_((float)(pLimbSwing * 0.6662f + (float)Math.PI)) * 1.4f * pLimbSwingAmount * 0.5f;
        this.rightLeg.f_104204_ = 0.0f;
        this.leftLeg.f_104204_ = 0.0f;
        AnimationUtils.m_102082_((ModelPart)this.rightArm, (ModelPart)this.leftArm, (float)pAgeInTicks);
    }
}

