/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.entity.client.model;

import net.minecraft.client.model.AnimationUtils;
import net.minecraft.client.model.HierarchicalModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.model.geom.PartPose;
import net.minecraft.client.model.geom.builders.CubeDeformation;
import net.minecraft.client.model.geom.builders.CubeListBuilder;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.client.model.geom.builders.MeshDefinition;
import net.minecraft.client.model.geom.builders.PartDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.NotNull;
import us.amon.stormward.entity.Whitespine;

public class WhitespineModel<T extends Whitespine>
extends HierarchicalModel<T> {
    public static final ModelLayerLocation LAYER_LOCATION = new ModelLayerLocation(new ResourceLocation("stormward", "whitespine"), "main");
    private final ModelPart root;
    private final ModelPart body;
    private final ModelPart neck;
    private final ModelPart head;
    private final ModelPart leftTusk;
    private final ModelPart rightTusk;
    private final ModelPart leftFrontArm;
    private final ModelPart rightFrontArm;
    private final ModelPart leftBackArm;
    private final ModelPart rightBackArm;
    private final ModelPart leftLeg;
    private final ModelPart rightLeg;
    private final ModelPart tail;

    public WhitespineModel(ModelPart pRoot) {
        this.root = pRoot;
        this.body = this.root.m_171324_("body");
        this.neck = this.body.m_171324_("neck");
        this.head = this.neck.m_171324_("head");
        this.leftTusk = this.head.m_171324_("leftTusk");
        this.rightTusk = this.head.m_171324_("rightTusk");
        this.leftFrontArm = this.neck.m_171324_("leftFrontArm");
        this.rightFrontArm = this.neck.m_171324_("rightFrontArm");
        this.leftBackArm = this.body.m_171324_("leftBackArm");
        this.rightBackArm = this.body.m_171324_("rightBackArm");
        this.leftLeg = this.body.m_171324_("leftLeg");
        this.rightLeg = this.body.m_171324_("rightLeg");
        this.tail = this.body.m_171324_("tail");
    }

    public static LayerDefinition createBodyLayer() {
        MeshDefinition meshdefinition = new MeshDefinition();
        PartDefinition partdefinition = meshdefinition.m_171576_();
        PartDefinition body = partdefinition.m_171599_("body", CubeListBuilder.m_171558_().m_171514_(28, 3).m_171488_(-6.0f, -7.0f, -8.0f, 12.0f, 15.0f, 16.0f, new CubeDeformation(0.0f)).m_171514_(57, 34).m_171488_(-5.0f, -5.0f, 8.0f, 10.0f, 11.0f, 8.0f, new CubeDeformation(0.0f)).m_171514_(68, 0).m_171488_(-2.0f, -15.0f, -7.0f, 4.0f, 8.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(57, 33).m_171488_(0.0f, -13.0f, -7.0f, 0.0f, 8.0f, 23.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)0.0f, (float)4.0f, (float)-1.0f));
        PartDefinition cube_r1 = body.m_171599_("cube_r1", CubeListBuilder.m_171558_().m_171514_(116, 0).m_171488_(-1.0f, -6.0f, 0.0f, 3.0f, 8.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)-0.5f, (float)-7.0f, (float)8.0f, (float)-0.3491f, (float)0.0f, (float)0.0f));
        PartDefinition cube_r2 = body.m_171599_("cube_r2", CubeListBuilder.m_171558_().m_171514_(84, 0).m_171488_(-2.0f, -8.0f, 0.0f, 4.0f, 8.0f, 4.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-7.0f, (float)0.0f, (float)-0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition neck = body.m_171599_("neck", CubeListBuilder.m_171558_().m_171514_(89, 8).m_171488_(-4.0f, 0.0f, -11.0f, 8.0f, 9.0f, 11.0f, new CubeDeformation(0.0f)).m_171514_(42, 24).m_171488_(0.0f, -7.0f, -8.0f, 0.0f, 7.0f, 10.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-4.0f, (float)-8.0f, (float)0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition head = neck.m_171599_("head", CubeListBuilder.m_171558_().m_171514_(0, 0).m_171488_(-5.0f, -5.0f, -8.0f, 10.0f, 11.0f, 8.0f, new CubeDeformation(0.0f)).m_171514_(28, -8).m_171488_(0.0f, -9.0f, -8.0f, 0.0f, 4.0f, 8.0f, new CubeDeformation(0.0f)).m_171514_(14, 19).m_171488_(-2.0f, -5.0f, -11.0f, 4.0f, 7.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)4.0f, (float)-9.0f, (float)-0.2618f, (float)0.0f, (float)0.0f));
        PartDefinition leftTusk = head.m_171599_("leftTusk", CubeListBuilder.m_171558_().m_171514_(36, 6).m_171488_(0.0f, 0.0f, -1.0f, 2.0f, 11.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)2.0f, (float)-2.0f, (float)-9.0f));
        PartDefinition rightTusk = head.m_171599_("rightTusk", CubeListBuilder.m_171558_().m_171514_(36, 6).m_171480_().m_171488_(-2.0f, -1.0f, -1.0f, 2.0f, 11.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-2.0f, (float)-1.0f, (float)-9.0f));
        PartDefinition leftFrontArm = neck.m_171599_("leftFrontArm", CubeListBuilder.m_171558_().m_171514_(0, 38).m_171488_(0.0f, -1.5f, -1.5f, 2.0f, 10.0f, 3.0f, new CubeDeformation(0.0f)).m_171514_(0, 51).m_171488_(0.0f, 7.5f, 1.5f, 2.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)4.0f, (float)7.5f, (float)-5.5f, (float)-0.6109f, (float)0.0f, (float)0.0f));
        PartDefinition rightFrontArm = neck.m_171599_("rightFrontArm", CubeListBuilder.m_171558_().m_171514_(0, 38).m_171480_().m_171488_(-2.0f, -1.5f, -1.5f, 2.0f, 10.0f, 3.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(0, 51).m_171480_().m_171488_(-2.0f, 7.5f, 1.5f, 2.0f, 1.0f, 2.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)-4.0f, (float)7.5f, (float)-5.5f, (float)-0.6109f, (float)0.0f, (float)0.0f));
        PartDefinition leftBackArm = body.m_171599_("leftBackArm", CubeListBuilder.m_171558_().m_171514_(0, 19).m_171488_(0.0f, -2.0f, -2.0f, 3.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).m_171514_(14, 31).m_171488_(0.0f, 9.0f, 2.0f, 3.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)6.0f, (float)5.0f, (float)-5.0f, (float)-0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition rightBackArm = body.m_171599_("rightBackArm", CubeListBuilder.m_171558_().m_171514_(0, 19).m_171480_().m_171488_(-3.0f, -2.0f, -2.0f, 3.0f, 12.0f, 4.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(14, 31).m_171480_().m_171488_(-3.0f, 9.0f, 2.0f, 3.0f, 1.0f, 3.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171423_((float)-6.0f, (float)5.0f, (float)-5.0f, (float)-0.1745f, (float)0.0f, (float)0.0f));
        PartDefinition leftLeg = body.m_171599_("leftLeg", CubeListBuilder.m_171558_().m_171514_(94, 28).m_171488_(4.0f, -4.0f, -4.0f, 5.0f, 8.0f, 12.0f, new CubeDeformation(0.0f)).m_171514_(106, 48).m_171488_(4.0f, 4.0f, 2.0f, 5.0f, 10.0f, 6.0f, new CubeDeformation(0.0f)), PartPose.m_171419_((float)2.0f, (float)6.0f, (float)3.0f));
        PartDefinition rightLeg = body.m_171599_("rightLeg", CubeListBuilder.m_171558_().m_171514_(94, 28).m_171480_().m_171488_(-9.0f, -4.0f, -4.0f, 5.0f, 8.0f, 12.0f, new CubeDeformation(0.0f)).m_171555_(false).m_171514_(106, 48).m_171480_().m_171488_(-9.0f, 4.0f, 2.0f, 5.0f, 10.0f, 6.0f, new CubeDeformation(0.0f)).m_171555_(false), PartPose.m_171419_((float)-2.0f, (float)6.0f, (float)3.0f));
        PartDefinition tail = body.m_171599_("tail", CubeListBuilder.m_171558_().m_171514_(0, 41).m_171488_(-3.0f, 0.0f, 0.0f, 6.0f, 6.0f, 17.0f, new CubeDeformation(0.0f)).m_171514_(8, 18).m_171488_(0.0f, -6.0f, 0.0f, 0.0f, 6.0f, 17.0f, new CubeDeformation(0.0f)).m_171514_(13, 42).m_171488_(-7.0f, 3.0f, 11.0f, 14.0f, 0.0f, 16.0f, new CubeDeformation(0.0f)), PartPose.m_171423_((float)0.0f, (float)-3.0f, (float)16.0f, (float)-0.0873f, (float)0.0f, (float)0.0f));
        return LayerDefinition.m_171565_((MeshDefinition)meshdefinition, (int)128, (int)64);
    }

    public void setupAnim(@NotNull T entity, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.m_142109_().m_171331_().forEach(ModelPart::m_233569_);
        int tusks = ((Whitespine)entity).getTusks();
        boolean leftHanded = entity.m_21526_();
        this.leftTusk.f_104207_ = tusks > (leftHanded ? 1 : 0);
        this.rightTusk.f_104207_ = tusks > (leftHanded ? 0 : 1);
        this.animateWalk(limbSwing * 0.4f, limbSwingAmount);
        AnimationUtils.m_102082_((ModelPart)this.rightBackArm, (ModelPart)this.leftBackArm, (float)ageInTicks);
        AnimationUtils.m_102082_((ModelPart)this.rightFrontArm, (ModelPart)this.leftFrontArm, (float)ageInTicks);
        float xNeckRot = headPitch * ((float)Math.PI / 180) / 2.0f;
        float yNeckRot = netHeadYaw * ((float)Math.PI / 180) / 2.0f;
        this.neck.f_104203_ += xNeckRot;
        this.neck.f_104204_ += yNeckRot;
        this.head.f_104203_ += xNeckRot;
        this.head.f_104204_ += yNeckRot;
    }

    private void animateWalk(float pLimbSwing, float pLimbSwingAmount) {
        this.body.f_104201_ -= (Mth.m_14089_((float)(pLimbSwing * 2.0f)) * 2.0f + 2.0f) * pLimbSwingAmount;
        this.rightLeg.f_104203_ += Mth.m_14089_((float)pLimbSwing) * 1.4f * 0.5f * pLimbSwingAmount;
        this.leftLeg.f_104203_ += Mth.m_14089_((float)(pLimbSwing + (float)Math.PI)) * 1.4f * 0.5f * pLimbSwingAmount;
        this.rightLeg.f_104201_ -= (Mth.m_14031_((float)pLimbSwing) * 4.0f + 2.0f) * pLimbSwingAmount;
        this.leftLeg.f_104201_ -= (Mth.m_14031_((float)(pLimbSwing + (float)Math.PI)) * 4.0f + 2.0f) * pLimbSwingAmount;
        this.neck.f_104203_ -= Mth.m_14089_((float)(pLimbSwing * 2.0f - 8.0f)) * 5.0f * ((float)Math.PI / 180) * pLimbSwingAmount;
        this.head.f_104203_ += Mth.m_14089_((float)(pLimbSwing * 2.0f - 9.0f)) * 5.0f * ((float)Math.PI / 180) * pLimbSwingAmount;
        this.tail.f_104203_ -= Mth.m_14089_((float)(pLimbSwing * 2.0f + 8.0f)) * 5.0f * ((float)Math.PI / 180) * pLimbSwingAmount;
        float armRot = ((Mth.m_14089_((float)(pLimbSwing * 2.0f - 8.0f)) + 1.0f) * 5.0f + 5.0f) * ((float)Math.PI / 180) * pLimbSwingAmount;
        this.rightBackArm.f_104203_ -= armRot;
        this.rightFrontArm.f_104203_ -= armRot;
        this.leftBackArm.f_104203_ -= armRot;
        this.leftFrontArm.f_104203_ -= armRot;
    }

    @NotNull
    public ModelPart m_142109_() {
        return this.root;
    }
}

