/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.entity.client.renderer;

import com.google.common.collect.ImmutableMap;
import com.mojang.datafixers.util.Pair;
import java.util.Map;
import java.util.stream.Stream;
import net.minecraft.client.model.BoatModel;
import net.minecraft.client.model.ChestBoatModel;
import net.minecraft.client.model.ListModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.client.renderer.entity.BoatRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.vehicle.Boat;
import org.jetbrains.annotations.NotNull;
import us.amon.stormward.entity.wood.StormwardBoatEntity;
import us.amon.stormward.entity.wood.StormwardChestBoatEntity;

public class StormwardBoatRenderer
extends BoatRenderer {
    private final Map<StormwardBoatEntity.Type, Pair<ResourceLocation, ListModel<Boat>>> boatResources = (Map)Stream.of(StormwardBoatEntity.Type.values()).collect(ImmutableMap.toImmutableMap(type -> type, type -> Pair.of((Object)new ResourceLocation("stormward", StormwardBoatRenderer.getTextureLocation(type, pChestBoat)), this.createBoatModel(pContext, (StormwardBoatEntity.Type)((Object)type), pChestBoat))));

    public StormwardBoatRenderer(EntityRendererProvider.Context pContext, boolean pChestBoat) {
        super(pContext, pChestBoat);
    }

    private static String getTextureLocation(StormwardBoatEntity.Type pType, boolean pChestBoat) {
        return pChestBoat ? "textures/entity/chest_boat/" + pType.getName() + ".png" : "textures/entity/boat/" + pType.getName() + ".png";
    }

    private ListModel<Boat> createBoatModel(EntityRendererProvider.Context pContext, StormwardBoatEntity.Type pType, boolean pChestBoat) {
        ModelLayerLocation modellayerlocation = pChestBoat ? StormwardBoatRenderer.createChestBoatModelName(pType) : StormwardBoatRenderer.createBoatModelName(pType);
        ModelPart modelpart = pContext.m_174023_(modellayerlocation);
        return pChestBoat ? new ChestBoatModel(modelpart) : new BoatModel(modelpart);
    }

    public static ModelLayerLocation createBoatModelName(StormwardBoatEntity.Type pType) {
        return StormwardBoatRenderer.createLocation("boat/" + pType.getName(), "main");
    }

    public static ModelLayerLocation createChestBoatModelName(StormwardBoatEntity.Type pType) {
        return StormwardBoatRenderer.createLocation("chest_boat/" + pType.getName(), "main");
    }

    private static ModelLayerLocation createLocation(String pPath, String pModel) {
        return new ModelLayerLocation(new ResourceLocation("stormward", pPath), pModel);
    }

    @NotNull
    public Pair<ResourceLocation, ListModel<Boat>> getModelWithLocation(@NotNull Boat pBoat) {
        if (pBoat instanceof StormwardBoatEntity) {
            StormwardBoatEntity modBoat = (StormwardBoatEntity)pBoat;
            return this.boatResources.get((Object)modBoat.getStormwardVariant());
        }
        if (pBoat instanceof StormwardChestBoatEntity) {
            StormwardChestBoatEntity modChestBoatEntity = (StormwardChestBoatEntity)pBoat;
            return this.boatResources.get((Object)modChestBoatEntity.getStormlightVariant());
        }
        return null;
    }
}

