/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.entity.duel;

import java.util.EnumSet;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.ai.targeting.TargetingConditions;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import us.amon.stormward.entity.duel.Duel;
import us.amon.stormward.level.Duels;

public interface IDuelist {
    default public PathfinderMob asMob() {
        return (PathfinderMob)this;
    }

    default public void addDuelistSaveData(CompoundTag pNbt) {
        if (this.getDuel() != null) {
            pNbt.m_128405_("DuelId", this.getDuel().getId());
        }
    }

    default public void readDuelistSaveData(Level pLevel, CompoundTag pTag) {
        if (pTag.m_128425_("DuelId", 3)) {
            if (pLevel instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)pLevel;
                this.setDuel(Duels.get(serverLevel).getById(pTag.m_128451_("DuelId")));
            }
            if (this.getDuel() != null) {
                this.getDuel().addMob(this);
            }
        }
    }

    default public void registerDuelistGoals() {
        this.asMob().f_21346_.m_25352_(0, (Goal)new NearestChallengerTargetGoal(this));
    }

    @Nullable
    public Duel getDuel();

    public void setDuel(Duel var1);

    public static class NearestChallengerTargetGoal
    extends TargetGoal {
        protected final int randomInterval = NearestChallengerTargetGoal.m_186073_((int)10);
        protected LivingEntity target;
        protected TargetingConditions targetConditions;

        public NearestChallengerTargetGoal(IDuelist pDuelist) {
            super((Mob)pDuelist.asMob(), false, false);
            this.m_7021_(EnumSet.of(Goal.Flag.TARGET));
            this.targetConditions = TargetingConditions.m_148352_().m_148355_().m_26883_(24.0).m_26888_(entity -> pDuelist.getDuel() != null && pDuelist.getDuel().isChallenger((LivingEntity)entity));
        }

        public boolean m_8036_() {
            if (this.randomInterval > 0 && this.f_26135_.m_217043_().m_188503_(this.randomInterval) != 0) {
                return false;
            }
            this.target = this.f_26135_.m_9236_().m_45949_(this.targetConditions, (LivingEntity)this.f_26135_, this.f_26135_.m_20185_(), this.f_26135_.m_20188_(), this.f_26135_.m_20189_());
            return this.target != null;
        }

        public void m_8056_() {
            this.f_26135_.m_6710_(this.target);
            super.m_8056_();
        }
    }
}

