/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.entity.goal;

import java.util.EnumSet;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import us.amon.stormward.entity.Chull;
import us.amon.stormward.sound.StormwardSoundEvents;
import us.amon.stormward.weather.Highstorm;

public class ChullHideGoal
extends Goal {
    protected final Chull mob;
    protected final int maxHideTime;
    private int hideTime;
    private int ticks;

    public ChullHideGoal(Chull pMob, int pMaxHideTime) {
        this.mob = pMob;
        this.maxHideTime = pMaxHideTime;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.JUMP, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        return this.mob.f_20916_ > 0 || Highstorm.isEntityExposedToHighstorm((Entity)this.mob);
    }

    public boolean m_8045_() {
        this.hideTime -= this.m_183277_(1);
        if (this.m_8036_()) {
            this.hideTime = this.maxHideTime;
            if (this.mob.getState() == Chull.State.REVEALING) {
                this.ticks = 0;
                this.mob.setState(Chull.State.HIDING);
            }
        }
        return this.hideTime > 0;
    }

    public void m_8056_() {
        this.ticks = 0;
        this.hideTime = this.maxHideTime;
        this.mob.setState(Chull.State.HIDING);
        this.mob.m_21573_().m_26573_();
        this.mob.m_5496_((SoundEvent)StormwardSoundEvents.CHULL_HIDE.get(), 1.0f, (this.mob.m_217043_().m_188501_() - this.mob.m_217043_().m_188501_()) * 0.2f + 1.0f);
    }

    public void m_8041_() {
        this.mob.setState(Chull.State.IDLING);
    }

    public void m_8037_() {
        this.ticks += this.m_183277_(1);
        if (this.mob.getState() == Chull.State.HIDING && this.ticks > 8) {
            this.mob.setState(Chull.State.HIDDEN);
        } else if (this.mob.getState() == Chull.State.HIDDEN && this.hideTime <= 8) {
            this.mob.setState(Chull.State.REVEALING);
            this.mob.m_5496_((SoundEvent)StormwardSoundEvents.CHULL_EMERGE.get(), 1.0f, (this.mob.m_217043_().m_188501_() - this.mob.m_217043_().m_188501_()) * 0.2f + 1.0f);
        }
    }
}

