/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.entity.goal;

import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import us.amon.stormward.entity.spren.shadesmar.TrueSprenShadesmar;

public class TrueSprenFollowBondGoal
extends Goal {
    public static final int TELEPORT_WHEN_DISTANCE_IS = 12;
    private static final int MIN_HORIZONTAL_DISTANCE_FROM_PLAYER_WHEN_TELEPORTING = 2;
    private static final int MAX_HORIZONTAL_DISTANCE_FROM_PLAYER_WHEN_TELEPORTING = 3;
    private static final int MAX_VERTICAL_DISTANCE_FROM_PLAYER_WHEN_TELEPORTING = 1;
    private final TrueSprenShadesmar spren;
    private final LevelReader level;
    private final double speedModifier;
    private final PathNavigation navigation;
    private final float stopDistance;
    private final float startDistance;
    private Entity bondedEntity;
    private int timeToRecalcPath;
    private float oldWaterCost;

    public TrueSprenFollowBondGoal(TrueSprenShadesmar pSpren, double pSpeedModifier, float pStartDistance, float pStopDistance) {
        this.spren = pSpren;
        this.level = pSpren.m_9236_();
        this.speedModifier = pSpeedModifier;
        this.navigation = pSpren.m_21573_();
        this.startDistance = pStartDistance;
        this.stopDistance = pStopDistance;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        Entity entity = this.spren.getBondedEntity();
        if (entity == null) {
            return false;
        }
        if (entity.m_5833_()) {
            return false;
        }
        if (this.spren.m_20280_(entity) < (double)(this.startDistance * this.startDistance)) {
            return false;
        }
        this.bondedEntity = entity;
        return true;
    }

    public boolean m_8045_() {
        if (this.navigation.m_26571_()) {
            return false;
        }
        return !(this.spren.m_20280_(this.bondedEntity) <= (double)(this.stopDistance * this.stopDistance));
    }

    public void m_8056_() {
        this.timeToRecalcPath = 0;
        this.oldWaterCost = this.spren.m_21439_(BlockPathTypes.WATER);
        this.spren.m_21441_(BlockPathTypes.WATER, 0.0f);
    }

    public void m_8041_() {
        this.bondedEntity = null;
        this.navigation.m_26573_();
        this.spren.m_21441_(BlockPathTypes.WATER, this.oldWaterCost);
    }

    public void m_8037_() {
        this.spren.m_21563_().m_24960_(this.bondedEntity, 10.0f, (float)this.spren.m_8132_());
        if (--this.timeToRecalcPath <= 0) {
            this.timeToRecalcPath = this.m_183277_(10);
            if (this.spren.m_20280_(this.bondedEntity) >= 144.0) {
                if (TrueSprenFollowBondGoal.teleport(this.spren, this.bondedEntity)) {
                    this.navigation.m_26573_();
                }
            } else {
                this.navigation.m_5624_(this.bondedEntity, this.speedModifier);
            }
        }
    }

    public static boolean teleport(TrueSprenShadesmar pSpren, Entity pBondedEntity) {
        BlockPos pos = pBondedEntity.m_20183_();
        for (int i = 0; i < 10; ++i) {
            int x = TrueSprenFollowBondGoal.randomIntInclusive(pSpren, -3, 3);
            int y = TrueSprenFollowBondGoal.randomIntInclusive(pSpren, -1, 1);
            int z = TrueSprenFollowBondGoal.randomIntInclusive(pSpren, -3, 3);
            if (!TrueSprenFollowBondGoal.maybeTeleportTo(pSpren, pBondedEntity, pos.m_123341_() + x, pos.m_123342_() + y, pos.m_123343_() + z)) continue;
            return true;
        }
        return false;
    }

    private static boolean maybeTeleportTo(TrueSprenShadesmar pSpren, Entity pBondedEntity, int pX, int pY, int pZ) {
        if (Math.abs((double)pX - pBondedEntity.m_20185_()) < 2.0 && Math.abs((double)pZ - pBondedEntity.m_20189_()) < 2.0) {
            return false;
        }
        if (!TrueSprenFollowBondGoal.canTeleportTo(pSpren, new BlockPos(pX, pY, pZ))) {
            return false;
        }
        pSpren.m_7678_((double)pX + 0.5, pY, (double)pZ + 0.5, pSpren.m_146908_(), pSpren.m_146909_());
        return true;
    }

    public static boolean canTeleportTo(TrueSprenShadesmar pSpren, BlockPos pPos) {
        BlockPathTypes blockpathtypes = WalkNodeEvaluator.m_77604_((BlockGetter)pSpren.m_9236_(), (BlockPos.MutableBlockPos)pPos.m_122032_());
        if (blockpathtypes != BlockPathTypes.WALKABLE) {
            return false;
        }
        BlockPos pos = pPos.m_121996_((Vec3i)pSpren.m_20183_());
        return pSpren.m_9236_().m_45756_((Entity)pSpren, pSpren.m_20191_().m_82338_(pos));
    }

    private static int randomIntInclusive(TrueSprenShadesmar pSpren, int pMin, int pMax) {
        return pSpren.m_217043_().m_188503_(pMax - pMin + 1) + pMin;
    }
}

