/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.entity.navigation;

import it.unimi.dsi.fastutil.objects.Object2BooleanMap;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.Node;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;
import net.minecraft.world.phys.AABB;
import org.jetbrains.annotations.NotNull;
import us.amon.stormward.attribute.StormwardAttributes;

public class JumpNodeEvaluator
extends WalkNodeEvaluator {
    private final Object2BooleanMap<AABB> jumpCollisionCache = new Object2BooleanOpenHashMap();

    public void m_6802_() {
        super.m_6802_();
        this.jumpCollisionCache.clear();
    }

    public int m_6065_(Node @NotNull [] pOutputArray, @NotNull Node pNode) {
        Node node7;
        Node node6;
        Node node5;
        Node node4;
        Node northNode;
        Node northJumpNode;
        Node eastNode;
        Node eastJumpNode;
        Node westNode;
        Node westJumpNode;
        double d0;
        Node southNode;
        Node southJumpNode;
        int i = 0;
        int verticalLimit = 0;
        BlockPathTypes blockpathtypes = this.m_77567_(this.f_77313_, pNode.f_77271_, pNode.f_77272_ + 1, pNode.f_77273_);
        BlockPathTypes blockpathtypes1 = this.m_77567_(this.f_77313_, pNode.f_77271_, pNode.f_77272_, pNode.f_77273_);
        if (this.f_77313_.m_21439_(blockpathtypes) >= 0.0f && blockpathtypes1 != BlockPathTypes.STICKY_HONEY) {
            verticalLimit = Mth.m_14107_((double)Math.max((double)Math.max(1.0f, this.f_77313_.getStepHeight()), this.m_255203_()));
        }
        if (this.m_77626_(southJumpNode = this.maybeFindJump(southNode = this.m_164725_(pNode.f_77271_, pNode.f_77272_, pNode.f_77273_ + 1, verticalLimit, d0 = this.m_142213_(new BlockPos(pNode.f_77271_, pNode.f_77272_, pNode.f_77273_)), Direction.SOUTH, blockpathtypes1), pNode, Direction.SOUTH), pNode)) {
            pOutputArray[i++] = southJumpNode;
        }
        if (this.m_77626_(westJumpNode = this.maybeFindJump(westNode = this.m_164725_(pNode.f_77271_ - 1, pNode.f_77272_, pNode.f_77273_, verticalLimit, d0, Direction.WEST, blockpathtypes1), pNode, Direction.WEST), pNode)) {
            pOutputArray[i++] = westJumpNode;
        }
        if (this.m_77626_(eastJumpNode = this.maybeFindJump(eastNode = this.m_164725_(pNode.f_77271_ + 1, pNode.f_77272_, pNode.f_77273_, verticalLimit, d0, Direction.EAST, blockpathtypes1), pNode, Direction.EAST), pNode)) {
            pOutputArray[i++] = eastJumpNode;
        }
        if (this.m_77626_(northJumpNode = this.maybeFindJump(northNode = this.m_164725_(pNode.f_77271_, pNode.f_77272_, pNode.f_77273_ - 1, verticalLimit, d0, Direction.NORTH, blockpathtypes1), pNode, Direction.NORTH), pNode)) {
            pOutputArray[i++] = northJumpNode;
        }
        if (this.m_77629_(pNode, westNode, northNode, node4 = this.m_164725_(pNode.f_77271_ - 1, pNode.f_77272_, pNode.f_77273_ - 1, verticalLimit, d0, Direction.NORTH, blockpathtypes1))) {
            pOutputArray[i++] = node4;
        }
        if (this.m_77629_(pNode, eastNode, northNode, node5 = this.m_164725_(pNode.f_77271_ + 1, pNode.f_77272_, pNode.f_77273_ - 1, verticalLimit, d0, Direction.NORTH, blockpathtypes1))) {
            pOutputArray[i++] = node5;
        }
        if (this.m_77629_(pNode, westNode, southNode, node6 = this.m_164725_(pNode.f_77271_ - 1, pNode.f_77272_, pNode.f_77273_ + 1, verticalLimit, d0, Direction.SOUTH, blockpathtypes1))) {
            pOutputArray[i++] = node6;
        }
        if (this.m_77629_(pNode, eastNode, southNode, node7 = this.m_164725_(pNode.f_77271_ + 1, pNode.f_77272_, pNode.f_77273_ + 1, verticalLimit, d0, Direction.SOUTH, blockpathtypes1))) {
            pOutputArray[i++] = node7;
        }
        return i;
    }

    private double m_255203_() {
        AttributeInstance jumpHeight = this.f_77313_.m_21051_((Attribute)StormwardAttributes.JUMP_HEIGHT_ADDITION.get());
        return 1.0 + (jumpHeight != null ? jumpHeight.m_22135_() : 0.0);
    }

    private double getMobJumpRange() {
        return this.f_77313_.m_21133_(Attributes.f_22279_) * this.f_77313_.m_21566_().m_24999_() * 10.0;
    }

    protected Node m_164725_(int pX, int pY, int pZ, int pVerticalDeltaLimit, double pNodeFloorLevel, @NotNull Direction pDirection, @NotNull BlockPathTypes pPathType) {
        return super.m_164725_(pX, pY, pZ, pVerticalDeltaLimit, (double)pY, pDirection, pPathType);
    }

    private Node maybeFindJump(Node pNeighbor, Node pNode, Direction pDirection) {
        if (this.shouldFindJump(pNeighbor, pNode)) {
            return this.findJumpNode(pNeighbor, pNode.f_77271_ + pDirection.m_122429_(), pNode.f_77272_, pNode.f_77273_ + pDirection.m_122431_(), pDirection);
        }
        return pNeighbor;
    }

    private boolean shouldFindJump(Node pNeighbor, Node pNode) {
        return !this.m_77626_(pNeighbor, pNode) || pNeighbor.f_77272_ < pNode.f_77272_;
    }

    private Node findJumpNode(Node pFallback, int pX, int pY, int pZ, Direction pDirection) {
        int maxJumpRange = Mth.m_14107_((double)this.getMobJumpRange());
        int maxJumpHeight = Mth.m_14107_((double)this.m_255203_());
        int x = pX;
        int z = pZ;
        for (int i = 1; i < maxJumpRange; ++i) {
            int height;
            Node node = this.findHighestReachableBlock(x += pDirection.m_122429_(), pY, z += pDirection.m_122431_(), height = Mth.m_14107_((double)((double)maxJumpHeight * (1.0 - (double)i / (double)maxJumpRange) + 0.5)));
            if (node == null) continue;
            if (node.f_77272_ >= pY) {
                if (node.f_77281_ >= 0.0f && node.f_77282_ == BlockPathTypes.WALKABLE) {
                    if (this.hasJumpCollision(pX, pY, pZ, node.f_77271_, node.f_77272_, node.f_77273_)) continue;
                    return node;
                }
                return null;
            }
            if (!(node.f_77281_ >= 0.0f) || node.f_77282_ != BlockPathTypes.WALKABLE || pFallback != null && pFallback.f_77272_ > node.f_77272_) continue;
            pFallback = node;
        }
        return pFallback;
    }

    private Node findHighestReachableBlock(int pX, int pY, int pZ, int jumpHeight) {
        for (int i = jumpHeight; i > -this.f_77313_.m_6056_(); --i) {
            BlockPathTypes blockpathtypes = this.m_77567_(this.f_77313_, pX, pY + i, pZ);
            if (blockpathtypes == BlockPathTypes.OPEN) continue;
            Node node = this.m_5676_(pX, pY + i, pZ);
            node.f_77282_ = blockpathtypes;
            node.f_77281_ = this.f_77313_.m_21439_(blockpathtypes);
            return node;
        }
        return null;
    }

    private boolean hasJumpCollision(int pStartX, int pStartY, int pStartZ, int pEndX, int pEndY, int pEndZ) {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        double radius = (double)this.f_77313_.m_20205_() / 2.0;
        double x1 = (double)Math.min(pStartX, pEndX) + 0.5 - radius;
        double y1 = Math.max(this.m_142213_((BlockPos)pos.m_122178_(pStartX, pStartY, pStartZ)), this.m_142213_((BlockPos)pos.m_122178_(pEndX, pEndY, pEndZ))) + 0.001;
        double z1 = (double)Math.min(pStartZ, pEndZ) + 0.5 - radius;
        double x2 = (double)Math.max(pStartX, pEndX) + 0.5 + radius;
        double y2 = y1 + this.m_255203_() + (double)this.f_77313_.m_20206_() - 0.002;
        double z2 = (double)Math.max(pStartZ, pEndZ) + 0.5 + radius;
        AABB aabb = new AABB(x1, y1, z1, x2, y2, z2);
        return this.m_77634_(aabb);
    }

    private boolean m_77634_(AABB pBoundingBox) {
        return this.jumpCollisionCache.computeIfAbsent((Object)pBoundingBox, p_192973_ -> !this.f_77312_.m_45756_((Entity)this.f_77313_, pBoundingBox));
    }
}

