/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.entity.plateaurun;

import javax.annotation.Nullable;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;
import us.amon.stormward.command.StormwardGameRules;
import us.amon.stormward.entity.plateaurun.PlateauRun;
import us.amon.stormward.entity.shardbearer.Shardbearer;
import us.amon.stormward.level.PlateauRuns;
import us.amon.stormward.particle.StormwardParticles;

public class PlateauRunner
extends Shardbearer {
    private static final int OMEN_CHANCE = 50;
    private static final EntityDataAccessor<Boolean> DATA_IS_EXTRACTING_GEMHEART = SynchedEntityData.m_135353_(PlateauRunner.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected static final EntityDataAccessor<Boolean> DATA_IS_CELEBRATING = SynchedEntityData.m_135353_(PlateauRunner.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    protected PlateauRun plateauRun;
    protected boolean extractor;

    protected PlateauRunner(EntityType<? extends PlateauRunner> pEntityType, Level pLevel) {
        super((EntityType<? extends Shardbearer>)pEntityType, pLevel);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_IS_EXTRACTING_GEMHEART, (Object)false);
        this.f_19804_.m_135372_(DATA_IS_CELEBRATING, (Object)false);
    }

    public void setCurrentPlateauRun(@Nullable PlateauRun pPlateauRun) {
        this.plateauRun = pPlateauRun;
    }

    @Nullable
    public PlateauRun getCurrentPlateauRun() {
        return this.plateauRun;
    }

    public boolean hasActivePlateauRun() {
        return this.getCurrentPlateauRun() != null && this.getCurrentPlateauRun().isActive();
    }

    public boolean canBeExtractor() {
        return !this.isShardbearer();
    }

    public void setExtractor(boolean pExtractor) {
        this.extractor = pExtractor;
    }

    public boolean isExtractor() {
        return this.extractor;
    }

    @Override
    public void m_7380_(@NotNull CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128379_("Extractor", this.extractor);
        if (this.plateauRun != null) {
            pCompound.m_128405_("PlateauRunId", this.plateauRun.getId());
        }
    }

    @Override
    public void m_7378_(@NotNull CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.extractor = pCompound.m_128471_("Extractor");
        if (pCompound.m_128425_("PlateauRunId", 3)) {
            Level level = this.m_9236_();
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                this.plateauRun = PlateauRuns.get(serverLevel).get(pCompound.m_128451_("PlateauRunId"));
            }
            if (this.plateauRun != null) {
                this.plateauRun.addMob(this);
                if (this.isShardbearer()) {
                    this.plateauRun.setShardbearer(this);
                } else if (this.isExtractor()) {
                    this.plateauRun.setExtractor(this);
                }
            }
        }
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (this.isExtractingGemheart() && !this.m_21224_() && this.f_19796_.m_188503_(4) == 0) {
            double x = this.m_20185_() + (this.f_19796_.m_188500_() - 0.5) * 2.0;
            double y = this.m_20188_() + (this.f_19796_.m_188500_() - 0.5) * 2.0;
            double z = this.m_20189_() + (this.f_19796_.m_188500_() - 0.5) * 2.0;
            this.m_9236_().m_7106_((ParticleOptions)StormwardParticles.STORMLIGHT.get(), x, y, z, 0.01 * (Math.random() * 2.0 - 1.0), 0.01 * (Math.random() * 2.0 - 1.0), 0.01 * (Math.random() * 2.0 - 1.0));
        }
    }

    public void m_6667_(@NotNull DamageSource pDamageSource) {
        if (this.m_9236_() instanceof ServerLevel) {
            Entity entity = pDamageSource.m_7639_();
            PlateauRun run = this.getCurrentPlateauRun();
            if (run != null) {
                if (entity != null && entity.m_6095_() == EntityType.f_20532_) {
                    run.addParticipant(entity);
                }
                run.removeMob(this);
            } else if (entity instanceof Player) {
                Player player = (Player)entity;
                if (!this.m_9236_().m_46469_().m_46207_(StormwardGameRules.RULE_DISABLE_PLATEAU_RUNS) && this.f_19796_.m_188503_(50) == 0) {
                    MobEffectInstance effect = player.m_21124_(MobEffects.f_19594_);
                    int amplifier = 1;
                    if (effect != null) {
                        amplifier += effect.m_19564_();
                        player.m_6234_(MobEffects.f_19594_);
                    } else {
                        --amplifier;
                    }
                    amplifier = Mth.m_14045_((int)amplifier, (int)0, (int)4);
                    player.m_7292_(new MobEffectInstance(MobEffects.f_19594_, 120000, amplifier, false, false, true));
                }
            }
        }
        super.m_6667_(pDamageSource);
    }

    public boolean isCelebrating() {
        return (Boolean)this.f_19804_.m_135370_(DATA_IS_CELEBRATING);
    }

    public void setCelebrating(boolean pCelebrating) {
        this.f_19804_.m_135381_(DATA_IS_CELEBRATING, (Object)pCelebrating);
    }

    public boolean isExtractingGemheart() {
        return (Boolean)this.f_19804_.m_135370_(DATA_IS_EXTRACTING_GEMHEART);
    }

    public void setExtractingGemheart(boolean pExtractingGemheart) {
        this.f_19804_.m_135381_(DATA_IS_EXTRACTING_GEMHEART, (Object)pExtractingGemheart);
    }
}

