/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.entity.spren.overworld;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.VariantHolder;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraftforge.event.VanillaGameEvent;
import org.jetbrains.annotations.NotNull;
import us.amon.stormward.entity.StormwardEntities;
import us.amon.stormward.entity.spren.overworld.MusicsprenVariant;
import us.amon.stormward.entity.spren.overworld.SprenOverworld;
import us.amon.stormward.particle.StormwardParticles;

public class Musicspren
extends SprenOverworld
implements VariantHolder<MusicsprenVariant> {
    public static final int SPAWN_CHANCE = 15;
    private static final EntityDataAccessor<Integer> DATA_VARIANT = SynchedEntityData.m_135353_(Musicspren.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public Musicspren(Level pLevel) {
        this((EntityType)StormwardEntities.MUSICSPREN.get(), pLevel);
    }

    public Musicspren(EntityType<?> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    @Override
    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_VARIANT, (Object)MusicsprenVariant.RED.getId());
    }

    @Override
    public void finalizeSpawn() {
        super.finalizeSpawn();
        this.setVariant(this.f_19796_.m_188503_(MusicsprenVariant.values().length));
    }

    @Override
    public void m_8119_() {
        super.m_8119_();
        if (!this.m_213877_() && this.f_19796_.m_188503_(12) == 0) {
            double x = this.m_20208_(0.5);
            double y = this.m_20187_() + 0.125;
            double z = this.m_20262_(0.5);
            this.m_9236_().m_7106_((ParticleOptions)StormwardParticles.MUSICSPREN.get(), x, y, z, (double)this.getVariant().getRed(), (double)this.getVariant().getGreen(), (double)this.getVariant().getBlue());
        }
    }

    @Override
    protected void m_7378_(@NotNull CompoundTag pCompound) {
        super.m_7378_(pCompound);
        this.setVariant(pCompound.m_128451_("Variant"));
    }

    @Override
    protected void m_7380_(@NotNull CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128405_("Variant", this.getVariant().getId());
    }

    public void setVariant(int pVariant) {
        this.f_19804_.m_135381_(DATA_VARIANT, (Object)pVariant);
    }

    public void setVariant(@NotNull MusicsprenVariant pVariant) {
        this.setVariant(pVariant.getId());
    }

    @NotNull
    public MusicsprenVariant getVariant() {
        return MusicsprenVariant.byId((Integer)this.f_19804_.m_135370_(DATA_VARIANT));
    }

    @Override
    protected void updateRotation() {
    }

    @Override
    protected boolean isBlockValidOrigin(BlockPos pPos) {
        BlockState belowState = this.m_9236_().m_8055_(pPos.m_7495_());
        return super.isBlockValidOrigin(pPos) && belowState.m_60713_(Blocks.f_50065_) || belowState.m_60713_(Blocks.f_50131_);
    }

    public static void tryAddAtBlock(Level pLevel, BlockPos pPos) {
        if (!pLevel.m_5776_() && Musicspren.spawnChance(pLevel.f_46441_, 15)) {
            SprenOverworld.addAtBlock((EntityType)StormwardEntities.MUSICSPREN.get(), pLevel, pPos.m_7494_());
        }
    }

    public static void onVanillaGameEvent(VanillaGameEvent event) {
        if (event.getVanillaEvent() == GameEvent.f_223699_ || event.getVanillaEvent() == GameEvent.f_238690_) {
            Musicspren.tryAddAtBlock(event.getLevel(), BlockPos.m_274446_((Position)event.getEventPosition()));
        }
    }
}

