/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.entity.spren.shadesmar;

import java.util.OptionalInt;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsRestrictionGoal;
import net.minecraft.world.entity.ai.goal.OpenDoorGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.navigation.GroundPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.scores.Team;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import us.amon.stormward.entity.goal.LookAtStormlightTradingPlayerGoal;
import us.amon.stormward.entity.goal.TrueSprenFollowBondGoal;
import us.amon.stormward.entity.spren.shadesmar.SprenShadesmar;
import us.amon.stormward.entity.stormlighttrader.IStormlightTrade;
import us.amon.stormward.entity.stormlighttrader.IStormlightTrader;
import us.amon.stormward.entity.stormlighttrader.TrueSprenTrades;
import us.amon.stormward.item.shard.ISprenShardItem;
import us.amon.stormward.sound.StormwardSoundEvents;

public class TrueSprenShadesmar
extends SprenShadesmar
implements IStormlightTrader {
    private static final EntityDataAccessor<Boolean> DATA_DEADEYE = SynchedEntityData.m_135353_(TrueSprenShadesmar.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final EntityDataAccessor<OptionalInt> DATA_NAHEL_BOND = SynchedEntityData.m_135353_(TrueSprenShadesmar.class, (EntityDataSerializer)EntityDataSerializers.f_135044_);
    private static final float DEFAULT_HEALTH = 50.0f;
    private static final float DEADEYE_HEALTH = 200.0f;
    private static final float DEFAULT_SPEED = 0.3f;
    private static final float DEADEYE_SPEED = 0.23f;
    private static final int RESTRICT_DISTANCE = 16;
    private UUID nahelBondUUID;
    private ItemStack tradeItem;
    private int tradeCost;
    private Player tradingPlayer;
    private int screamDelay;

    public TrueSprenShadesmar(EntityType<? extends PathfinderMob> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.m_21573_().m_7008_(true);
        PathNavigation pathNavigation = this.m_21573_();
        if (pathNavigation instanceof GroundPathNavigation) {
            GroundPathNavigation groundNavigation = (GroundPathNavigation)pathNavigation;
            groundNavigation.m_26477_(true);
        }
    }

    public static AttributeSupplier.Builder createAttributes() {
        return TrueSprenShadesmar.m_21552_().m_22268_(Attributes.f_22276_, 50.0).m_22268_(Attributes.f_22279_, (double)0.3f).m_22268_(Attributes.f_22284_, 40.0);
    }

    public static boolean checkSpawnRules(EntityType<? extends TrueSprenShadesmar> type, ServerLevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return TrueSprenShadesmar.checkShadesmarSpawnRules(type, level, spawnType, pos, random);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_DEADEYE, (Object)false);
        this.f_19804_.m_135372_(DATA_NAHEL_BOND, (Object)OptionalInt.empty());
    }

    protected void m_8099_() {
        super.m_8099_();
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(0, (Goal)new TrueSprenPanicGoal(this, 1.25));
        this.f_21345_.m_25352_(1, (Goal)new OpenDoorGoal((Mob)this, true));
        this.f_21345_.m_25352_(2, (Goal)new TrueSprenFollowBondGoal(this, 1.0, 10.0f, 2.0f));
        this.f_21345_.m_25352_(3, (Goal)new LookAtStormlightTradingPlayerGoal((Mob)this));
        this.f_21345_.m_25352_(4, (Goal)new MoveTowardsRestrictionGoal((PathfinderMob)this, (double)0.8f));
        this.f_21345_.m_25352_(5, (Goal)new TrueSprenRandomStrollGoal(this, 0.8f));
        this.f_21345_.m_25352_(6, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
    }

    public void m_7380_(@NotNull CompoundTag pCompound) {
        super.m_7380_(pCompound);
        if (this.isDeadeye()) {
            pCompound.m_128379_("Deadeye", true);
        }
        if (this.nahelBondUUID != null) {
            pCompound.m_128362_("NahelBond", this.nahelBondUUID);
        }
        if (this.tradeItem != null && !this.tradeItem.m_41619_()) {
            pCompound.m_128365_("TradeItem", (Tag)this.tradeItem.m_41739_(new CompoundTag()));
            pCompound.m_128405_("TradeCost", this.tradeCost);
        }
        if (this.m_21534_() != BlockPos.f_121853_) {
            pCompound.m_128365_("Stall", (Tag)NbtUtils.m_129224_((BlockPos)this.m_21534_()));
        }
    }

    public void m_7378_(@NotNull CompoundTag pCompound) {
        super.m_7378_(pCompound);
        if (pCompound.m_128441_("Deadeye")) {
            this.setDeadeye(true);
        }
        if (pCompound.m_128403_("NahelBond")) {
            this.nahelBondUUID = pCompound.m_128342_("NahelBond");
        }
        if (pCompound.m_128441_("TradeItem")) {
            this.tradeItem = ItemStack.m_41712_((CompoundTag)pCompound.m_128469_("TradeItem"));
            this.tradeCost = pCompound.m_128451_("TradeCost");
        }
        if (pCompound.m_128441_("Stall")) {
            this.m_21446_(NbtUtils.m_129239_((CompoundTag)pCompound.m_128469_("Stall")), 16);
        }
    }

    @Nullable
    public SpawnGroupData m_6518_(@NotNull ServerLevelAccessor pLevel, @NotNull DifficultyInstance pDifficulty, @NotNull MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        SpawnGroupData result = super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
        if (!this.isDeadeye() && !this.hasNahelBond()) {
            IStormlightTrade trade = TrueSprenTrades.TRADES[this.f_19796_.m_188503_(TrueSprenTrades.TRADES.length)];
            this.tradeItem = trade.getItem(this.f_19796_);
            this.tradeCost = trade.getCost(this.f_19796_);
            this.m_21446_(this.m_20183_(), 16);
        }
        return result;
    }

    public void m_6075_() {
        if (this.f_19803_) {
            this.syncNahelBond();
        }
        if (this.screamDelay > 0) {
            --this.screamDelay;
        }
        super.m_6075_();
    }

    private void syncNahelBond() {
        Level level = this.m_9236_();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (this.nahelBondUUID != null) {
                Entity bondedEntity = serverLevel.m_8791_(this.nahelBondUUID);
                if (bondedEntity != null) {
                    this.setNahelBond(bondedEntity);
                }
            } else if (this.isDeadeye()) {
                this.m_146870_();
            }
        }
    }

    public boolean isDeadeye() {
        return (Boolean)this.f_19804_.m_135370_(DATA_DEADEYE);
    }

    public void setDeadeye(boolean pDeadeye) {
        this.f_19804_.m_135381_(DATA_DEADEYE, (Object)pDeadeye);
        if (pDeadeye) {
            this.m_21051_(Attributes.f_22276_).m_22100_(200.0);
            this.m_21153_(200.0f);
            this.m_21051_(Attributes.f_22279_).m_22100_((double)0.23f);
        } else {
            this.m_21051_(Attributes.f_22276_).m_22100_(50.0);
            this.m_21051_(Attributes.f_22279_).m_22100_((double)0.3f);
        }
    }

    public OptionalInt getNahelBond() {
        return (OptionalInt)this.f_19804_.m_135370_(DATA_NAHEL_BOND);
    }

    public boolean hasNahelBond() {
        return this.getNahelBond().isPresent();
    }

    public Entity getBondedEntity() {
        OptionalInt id = this.getNahelBond();
        return id.isEmpty() ? null : this.m_9236_().m_6815_(id.getAsInt());
    }

    public void setNahelBond(Entity pEntity) {
        if (pEntity != null) {
            this.nahelBondUUID = pEntity.m_20148_();
            this.f_19804_.m_135381_(DATA_NAHEL_BOND, (Object)OptionalInt.of(pEntity.m_19879_()));
        } else {
            this.nahelBondUUID = null;
            this.f_19804_.m_135381_(DATA_NAHEL_BOND, (Object)OptionalInt.empty());
        }
    }

    public Team m_5647_() {
        Entity entity;
        if (this.hasNahelBond() && (entity = this.getBondedEntity()) != null) {
            return entity.m_5647_();
        }
        return super.m_5647_();
    }

    public boolean m_7307_(@NotNull Entity pEntity) {
        if (this.hasNahelBond()) {
            Entity entity = this.getBondedEntity();
            if (pEntity == entity) {
                return true;
            }
            if (entity != null) {
                return entity.m_7307_(pEntity);
            }
        }
        return super.m_7307_(pEntity);
    }

    public void m_6667_(@NotNull DamageSource pCause) {
        Component deathMessage = this.m_21231_().m_19293_();
        super.m_6667_(pCause);
        this.stopTrading();
        if (this.f_20890_ && !this.m_9236_().f_46443_) {
            Entity entity;
            if (this.m_9236_().m_46469_().m_46207_(GameRules.f_46142_) && (entity = this.getBondedEntity()) instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)entity;
                serverPlayer.m_213846_(deathMessage);
            }
            ISprenShardItem.getShardFromSpren(this).m_41764_(0);
            this.setNahelBond(null);
        }
    }

    public void m_6593_(@Nullable Component pName) {
        super.m_6593_(pName);
        ItemStack shard = ISprenShardItem.getShardFromSpren(this);
        if (!shard.m_41619_()) {
            shard.m_41714_(pName);
        }
    }

    @NotNull
    protected InteractionResult m_6071_(@NotNull Player pPlayer, @NotNull InteractionHand pHand) {
        if (this.isDeadeye()) {
            if (!this.m_20067_() && this.screamDelay <= 0) {
                this.m_9236_().m_6263_(pPlayer, this.m_20185_(), this.m_20186_(), this.m_20189_(), (SoundEvent)StormwardSoundEvents.DEADEYE_SCREAM.get(), this.m_5720_(), 1.0f, this.m_6100_());
                this.m_21551_();
                this.screamDelay = 40;
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        if (this.m_6084_() && !this.isTrading()) {
            if (this.hasTrade() && !this.m_9236_().f_46443_ && pPlayer instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)pPlayer;
                this.setTradingPlayer((Player)serverPlayer);
                this.openTradingScreen(serverPlayer, this.m_5446_());
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        return super.m_6071_(pPlayer, pHand);
    }

    @Override
    public Player getTradingPlayer() {
        return this.tradingPlayer;
    }

    @Override
    public void setTradingPlayer(@Nullable Player pPlayer) {
        this.tradingPlayer = pPlayer;
    }

    @Override
    public ItemStack getTradeItem() {
        return this.tradeItem;
    }

    @Override
    public int getTradeCost() {
        return this.tradeCost;
    }

    @Override
    public void setTrade(ItemStack pItem, int pCost) {
        this.tradeItem = pItem;
        this.tradeCost = pCost;
    }

    @Override
    public boolean isClientSide() {
        return this.m_9236_().f_46443_;
    }

    @Override
    public void notifyTrade() {
        this.m_8032_();
        this.m_21551_();
    }

    private void m_21551_() {
        this.f_21363_ = -this.m_8100_();
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return this.isDeadeye() ? (SoundEvent)StormwardSoundEvents.DEADEYE_AMBIENT.get() : (SoundEvent)StormwardSoundEvents.SPREN_SHADESMAR_AMBIENT.get();
    }

    public int m_8100_() {
        return this.isDeadeye() ? 160 : super.m_8100_();
    }

    @Nullable
    protected SoundEvent m_7975_(@NotNull DamageSource pDamageSource) {
        return this.isDeadeye() ? (SoundEvent)StormwardSoundEvents.DEADEYE_HURT.get() : (SoundEvent)StormwardSoundEvents.SPREN_SHADESMAR_HURT.get();
    }

    public boolean m_6785_(double pDistanceToClosestPlayer) {
        return false;
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return this.isDeadeye() ? (SoundEvent)StormwardSoundEvents.DEADEYE_DEATH.get() : (SoundEvent)StormwardSoundEvents.SPREN_SHADESMAR_DEATH.get();
    }

    private static class TrueSprenPanicGoal
    extends PanicGoal {
        private final TrueSprenShadesmar spren;

        public TrueSprenPanicGoal(TrueSprenShadesmar pSpren, double pSpeedModifier) {
            super((PathfinderMob)pSpren, pSpeedModifier);
            this.spren = pSpren;
        }

        public boolean m_8036_() {
            return super.m_8036_() && !this.spren.isDeadeye();
        }

        public void m_8056_() {
            super.m_8056_();
            this.spren.stopTrading();
        }
    }

    private static class TrueSprenRandomStrollGoal
    extends WaterAvoidingRandomStrollGoal {
        private final TrueSprenShadesmar spren;

        public TrueSprenRandomStrollGoal(TrueSprenShadesmar pSpren, double pSpeedModifier) {
            super((PathfinderMob)pSpren, pSpeedModifier);
            this.spren = pSpren;
        }

        public boolean m_8036_() {
            return super.m_8036_() && !this.spren.isDeadeye() && !this.spren.isTrading();
        }
    }
}

