/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.entity.thaylenmerchant;

import java.util.EnumSet;
import java.util.OptionalInt;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ExperienceOrb;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.goal.AvoidEntityGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.InteractGoal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.LookAtTradingPlayerGoal;
import net.minecraft.world.entity.ai.goal.MoveTowardsRestrictionGoal;
import net.minecraft.world.entity.ai.goal.PanicGoal;
import net.minecraft.world.entity.ai.goal.TradeWithPlayerGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.monster.Evoker;
import net.minecraft.world.entity.monster.Illusioner;
import net.minecraft.world.entity.monster.Pillager;
import net.minecraft.world.entity.monster.Vex;
import net.minecraft.world.entity.monster.Vindicator;
import net.minecraft.world.entity.monster.Zoglin;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.VillagerTrades;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.Merchant;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.item.trading.MerchantOffers;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import us.amon.stormward.entity.goal.FleeHighstormGoal;
import us.amon.stormward.entity.goal.RestrictHighstormGoal;
import us.amon.stormward.entity.goal.UseRegrowerGoal;
import us.amon.stormward.entity.thaylenmerchant.ThaylenMerchantTrades;
import us.amon.stormward.entity.villager.SphereMerchantOffer;
import us.amon.stormward.item.StormwardItems;
import us.amon.stormward.menu.SphereMerchantMenu;
import us.amon.stormward.sound.StormwardSoundEvents;

public class ThaylenMerchant
extends AbstractVillager {
    private BlockPos wanderTarget;
    private int despawnDelay;

    public ThaylenMerchant(EntityType<? extends AbstractVillager> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public static boolean checkSpawnRules(EntityType<ThaylenMerchant> type, ServerLevelAccessor level, MobSpawnType spawnType, BlockPos pos, RandomSource random) {
        return ThaylenMerchant.m_217057_(type, (LevelAccessor)level, (MobSpawnType)spawnType, (BlockPos)pos, (RandomSource)random);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return ThaylenMerchant.m_21552_();
    }

    @Nullable
    public SpawnGroupData m_6518_(@NotNull ServerLevelAccessor pLevel, @NotNull DifficultyInstance pDifficulty, @NotNull MobSpawnType pReason, @Nullable SpawnGroupData pSpawnData, @Nullable CompoundTag pDataTag) {
        this.m_8061_(EquipmentSlot.MAINHAND, new ItemStack((ItemLike)StormwardItems.STEERING_POLE.get()));
        return super.m_6518_(pLevel, pDifficulty, pReason, pSpawnData, pDataTag);
    }

    @Nullable
    public AgeableMob m_142606_(@NotNull ServerLevel pLevel, @NotNull AgeableMob pOtherParent) {
        return null;
    }

    public boolean m_7826_() {
        return false;
    }

    protected void m_8058_(MerchantOffer pOffer) {
        if (pOffer.m_45383_()) {
            int i = 3 + this.f_19796_.m_188503_(4);
            this.m_9236_().m_7967_((Entity)new ExperienceOrb(this.m_9236_(), this.m_20185_(), this.m_20186_() + 0.5, this.m_20189_(), i));
        }
    }

    protected void m_7604_() {
        MerchantOffers offers = this.m_6616_();
        int numExchanges = this.f_19796_.m_216332_(1, 2);
        this.m_35277_(offers, ThaylenMerchantTrades.EXCHANGES, numExchanges);
        this.m_35277_(offers, ThaylenMerchantTrades.TRADES, 6 - numExchanges);
        int i = this.f_19796_.m_188503_(ThaylenMerchantTrades.RARE_TRADES.length);
        VillagerTrades.ItemListing rareTrade = ThaylenMerchantTrades.RARE_TRADES[i];
        MerchantOffer rareOffer = rareTrade.m_213663_((Entity)this, this.f_19796_);
        if (rareOffer != null) {
            offers.add((Object)rareOffer);
        }
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(0, (Goal)new UseRegrowerGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new TradeWithPlayerGoal((AbstractVillager)this));
        this.f_21345_.m_25352_(1, (Goal)new AvoidEntityGoal((PathfinderMob)this, Zombie.class, 8.0f, 0.5, 0.5));
        this.f_21345_.m_25352_(1, (Goal)new AvoidEntityGoal((PathfinderMob)this, Evoker.class, 12.0f, 0.5, 0.5));
        this.f_21345_.m_25352_(1, (Goal)new AvoidEntityGoal((PathfinderMob)this, Vindicator.class, 8.0f, 0.5, 0.5));
        this.f_21345_.m_25352_(1, (Goal)new AvoidEntityGoal((PathfinderMob)this, Vex.class, 8.0f, 0.5, 0.5));
        this.f_21345_.m_25352_(1, (Goal)new AvoidEntityGoal((PathfinderMob)this, Pillager.class, 15.0f, 0.5, 0.5));
        this.f_21345_.m_25352_(1, (Goal)new AvoidEntityGoal((PathfinderMob)this, Illusioner.class, 12.0f, 0.5, 0.5));
        this.f_21345_.m_25352_(1, (Goal)new AvoidEntityGoal((PathfinderMob)this, Zoglin.class, 10.0f, 0.5, 0.5));
        this.f_21345_.m_25352_(2, (Goal)new FleeHighstormGoal((PathfinderMob)this, 0.5));
        this.f_21345_.m_25352_(3, (Goal)new RestrictHighstormGoal((PathfinderMob)this));
        this.f_21345_.m_25352_(4, (Goal)new PanicGoal((PathfinderMob)this, 0.5));
        this.f_21345_.m_25352_(5, (Goal)new LookAtTradingPlayerGoal((AbstractVillager)this));
        this.f_21345_.m_25352_(6, (Goal)new WanderToPositionGoal(this, 2.0, 0.3));
        this.f_21345_.m_25352_(7, (Goal)new MoveTowardsRestrictionGoal((PathfinderMob)this, 0.3));
        this.f_21345_.m_25352_(8, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.3));
        this.f_21345_.m_25352_(9, (Goal)new InteractGoal((Mob)this, Player.class, 3.0f, 1.0f));
        this.f_21345_.m_25352_(10, (Goal)new LookAtPlayerGoal((Mob)this, Mob.class, 8.0f));
    }

    @NotNull
    protected InteractionResult m_6071_(@NotNull Player pPlayer, @NotNull InteractionHand pHand) {
        if (this.m_6084_() && !this.m_35306_()) {
            if (!this.m_6616_().isEmpty() && !this.m_9236_().f_46443_) {
                this.m_7189_(pPlayer);
                this.m_45301_(pPlayer, this.m_5446_(), 1);
            }
            return InteractionResult.m_19078_((boolean)this.m_9236_().f_46443_);
        }
        return super.m_6071_(pPlayer, pHand);
    }

    public void m_45301_(Player pPlayer, @NotNull Component pDisplayName, int pLevel) {
        MerchantOffers merchantoffers;
        OptionalInt optionalint = pPlayer.m_5893_((MenuProvider)new SimpleMenuProvider((id, inventory, player) -> new SphereMerchantMenu(id, inventory, (Merchant)this), pDisplayName));
        if (optionalint.isPresent() && !(merchantoffers = this.m_6616_()).isEmpty()) {
            pPlayer.m_7662_(optionalint.getAsInt(), merchantoffers, pLevel, this.m_7809_(), this.m_7826_(), this.m_7862_());
        }
    }

    public void m_7380_(CompoundTag pCompound) {
        super.m_7380_(pCompound);
        pCompound.m_128405_("DespawnDelay", this.despawnDelay);
        if (this.wanderTarget != null) {
            pCompound.m_128365_("WanderTarget", (Tag)NbtUtils.m_129224_((BlockPos)this.wanderTarget));
        }
    }

    public void m_7378_(@NotNull CompoundTag pCompound) {
        super.m_7378_(pCompound);
        if (pCompound.m_128425_("DespawnDelay", 99)) {
            this.despawnDelay = pCompound.m_128451_("DespawnDelay");
        }
        if (pCompound.m_128441_("WanderTarget")) {
            this.wanderTarget = NbtUtils.m_129239_((CompoundTag)pCompound.m_128469_("WanderTarget"));
        }
        if (pCompound.m_128425_("Offers", 10)) {
            this.f_35261_ = new MerchantOffers();
            ListTag listtag = pCompound.m_128469_("Offers").m_128437_("Recipes", 10);
            for (int i = 0; i < listtag.size(); ++i) {
                this.f_35261_.add((Object)new SphereMerchantOffer(listtag.m_128728_(i)));
            }
        }
    }

    public boolean m_6785_(double pDistanceToClosestPlayer) {
        return false;
    }

    public void m_6996_(MerchantOffer pOffer) {
        pOffer.m_45374_();
        this.f_21363_ = -this.m_8100_();
        this.m_8058_(pOffer);
    }

    @NotNull
    public Vec3 m_7398_(float pPartialTicks) {
        double d0 = 0.22 * (this.m_5737_() == HumanoidArm.RIGHT ? -1.0 : 1.0);
        float f = Mth.m_14179_((float)(pPartialTicks * 0.5f), (float)this.m_146909_(), (float)this.f_19860_) * ((float)Math.PI / 180);
        float f1 = Mth.m_14179_((float)pPartialTicks, (float)this.f_20884_, (float)this.f_20883_) * ((float)Math.PI / 180);
        double d5 = this.m_20191_().m_82376_() - 1.0;
        double d6 = this.m_6047_() ? -0.2 : 0.07;
        return this.m_20318_(pPartialTicks).m_82549_(new Vec3(d0, d5, d6).m_82524_(-f1));
    }

    public void setDespawnDelay(int pDespawnDelay) {
        this.despawnDelay = pDespawnDelay;
    }

    public int getDespawnDelay() {
        return this.despawnDelay;
    }

    public void setWanderTarget(@Nullable BlockPos pWanderTarget) {
        this.wanderTarget = pWanderTarget;
    }

    public BlockPos getWanderTarget() {
        return this.wanderTarget;
    }

    public void m_8107_() {
        super.m_8107_();
        if (!this.m_9236_().f_46443_) {
            this.maybeDespawn();
        }
    }

    private void maybeDespawn() {
        if (this.despawnDelay > 0 && !this.m_35306_() && --this.despawnDelay == 0) {
            this.m_146870_();
        }
    }

    protected SoundEvent m_7515_() {
        return (SoundEvent)StormwardSoundEvents.THAYLEN_MERCHANT_AMBIENT.get();
    }

    @Nullable
    protected SoundEvent m_7975_(@NotNull DamageSource pDamageSource) {
        return (SoundEvent)StormwardSoundEvents.THAYLEN_MERCHANT_HURT.get();
    }

    @Nullable
    protected SoundEvent m_5592_() {
        return (SoundEvent)StormwardSoundEvents.THAYLEN_MERCHANT_DEATH.get();
    }

    static class WanderToPositionGoal
    extends Goal {
        final ThaylenMerchant merchant;
        final double stopDistance;
        final double speedModifier;

        WanderToPositionGoal(ThaylenMerchant pMerchant, double pStopDistance, double pSpeedModifier) {
            this.merchant = pMerchant;
            this.stopDistance = pStopDistance;
            this.speedModifier = pSpeedModifier;
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public void m_8041_() {
            this.merchant.setWanderTarget(null);
            this.merchant.f_21344_.m_26573_();
        }

        public boolean m_8036_() {
            BlockPos blockpos = this.merchant.getWanderTarget();
            return blockpos != null && this.isTooFarAway(blockpos, this.stopDistance);
        }

        public void m_8037_() {
            BlockPos blockpos = this.merchant.getWanderTarget();
            if (blockpos != null && this.merchant.f_21344_.m_26571_()) {
                if (this.isTooFarAway(blockpos, 10.0)) {
                    Vec3 vec3 = new Vec3((double)blockpos.m_123341_() - this.merchant.m_20185_(), (double)blockpos.m_123342_() - this.merchant.m_20186_(), (double)blockpos.m_123343_() - this.merchant.m_20189_()).m_82541_();
                    Vec3 vec31 = vec3.m_82490_(10.0).m_82520_(this.merchant.m_20185_(), this.merchant.m_20186_(), this.merchant.m_20189_());
                    this.merchant.f_21344_.m_26519_(vec31.f_82479_, vec31.f_82480_, vec31.f_82481_, this.speedModifier);
                } else {
                    this.merchant.f_21344_.m_26519_((double)blockpos.m_123341_(), (double)blockpos.m_123342_(), (double)blockpos.m_123343_(), this.speedModifier);
                }
            }
        }

        private boolean isTooFarAway(BlockPos pPos, double pDistance) {
            return !pPos.m_203195_((Position)this.merchant.m_20182_(), pDistance);
        }
    }
}

