/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.entity.thaylenmerchant;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.SpawnPlacements;
import net.minecraft.world.entity.ai.village.poi.PoiManager;
import net.minecraft.world.entity.ai.village.poi.PoiTypes;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.CustomSpawner;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import org.jetbrains.annotations.NotNull;
import us.amon.stormward.command.StormwardGameRules;
import us.amon.stormward.entity.Chull;
import us.amon.stormward.entity.StormwardEntities;
import us.amon.stormward.entity.thaylenmerchant.ThaylenMerchant;
import us.amon.stormward.level.ThaylenMerchantData;
import us.amon.stormward.tag.StormwardBiomeTags;

public class ThaylenMerchantSpawner
implements CustomSpawner {
    private static final int DEFAULT_TICK_DELAY = 1200;
    public static final int DEFAULT_SPAWN_DELAY = 24000;
    private static final int MIN_SPAWN_CHANCE = 25;
    private static final int MAX_SPAWN_CHANCE = 75;
    private static final int SPAWN_CHANCE_INCREASE = 25;
    private static final int SPAWN_ONE_IN_X_CHANCE = 10;
    private static final int NUMBER_OF_SPAWN_ATTEMPTS = 10;
    private static final ResourceLocation CHULL_CHEST_LOOT = new ResourceLocation("stormward", "chests/chull_chest");
    private final RandomSource random = RandomSource.m_216327_();
    private ThaylenMerchantData thaylenMerchantData;
    private int tickDelay = 1200;
    private int spawnDelay = 24000;
    private int spawnChance = 25;

    public int m_7995_(@NotNull ServerLevel pLevel, boolean pSpawnHostiles, boolean pSpawnPassives) {
        if (this.thaylenMerchantData == null) {
            this.thaylenMerchantData = ThaylenMerchantData.get(pLevel);
            if (this.thaylenMerchantData.getSpawnDelay() != 0 || this.thaylenMerchantData.getSpawnChance() != 0) {
                this.spawnDelay = this.thaylenMerchantData.getSpawnDelay();
                this.spawnChance = this.thaylenMerchantData.getSpawnChance();
            }
        }
        if (!pLevel.m_46469_().m_46207_(StormwardGameRules.DO_MERCHANT_SPAWNING)) {
            return 0;
        }
        if (--this.tickDelay > 0) {
            return 0;
        }
        this.tickDelay = 1200;
        this.spawnDelay -= 1200;
        if (this.spawnDelay > 0) {
            this.thaylenMerchantData.setSpawnDelay(this.spawnDelay);
            return 0;
        }
        this.spawnDelay = 24000;
        this.thaylenMerchantData.setSpawnDelay(this.spawnDelay);
        if (!pLevel.m_46469_().m_46207_(GameRules.f_46134_)) {
            return 0;
        }
        int i = this.spawnChance;
        this.spawnChance = Mth.m_14045_((int)(this.spawnChance + 25), (int)25, (int)75);
        this.thaylenMerchantData.setSpawnChance(this.spawnChance);
        if (this.random.m_188503_(100) > i) {
            return 0;
        }
        if (this.spawn(pLevel)) {
            this.spawnChance = 25;
            return 1;
        }
        return 0;
    }

    private boolean spawn(ServerLevel pServerLevel) {
        ServerPlayer player = pServerLevel.m_8890_();
        if (player == null) {
            return true;
        }
        if (this.random.m_188503_(10) != 0) {
            return false;
        }
        BlockPos playerPos = player.m_20183_();
        PoiManager poimanager = pServerLevel.m_8904_();
        Optional meetingPos = poimanager.m_27186_(type -> type.m_203565_(PoiTypes.f_218061_), pos -> true, playerPos, 48, PoiManager.Occupancy.ANY);
        BlockPos blockpos1 = meetingPos.orElse(playerPos);
        BlockPos blockpos2 = this.findSpawnPositionNear((LevelReader)pServerLevel, blockpos1, 48, (EntityType<? extends LivingEntity>)((EntityType)StormwardEntities.THAYLEN_MERCHANT.get()));
        if (blockpos2 != null && this.hasEnoughSpace((BlockGetter)pServerLevel, blockpos2)) {
            if (pServerLevel.m_204166_(blockpos2).m_203656_(StormwardBiomeTags.WITHOUT_MERCHANT_SPAWNS)) {
                return false;
            }
            ThaylenMerchant merchant = (ThaylenMerchant)((EntityType)StormwardEntities.THAYLEN_MERCHANT.get()).m_262496_(pServerLevel, blockpos2, MobSpawnType.EVENT);
            if (merchant != null) {
                this.tryToSpawnChullFor(pServerLevel, merchant, 4);
                this.thaylenMerchantData.setId(merchant.m_20148_());
                merchant.setDespawnDelay(48000);
                merchant.setWanderTarget(blockpos1);
                merchant.m_21446_(blockpos1, 16);
                return true;
            }
        }
        return false;
    }

    private void tryToSpawnChullFor(ServerLevel pServerLevel, ThaylenMerchant pMerchant, int pMaxDistance) {
        Chull chull;
        BlockPos blockpos = this.findSpawnPositionNear((LevelReader)pServerLevel, pMerchant.m_20183_(), pMaxDistance, (EntityType<? extends LivingEntity>)((EntityType)StormwardEntities.CHULL.get()));
        if (blockpos != null && (chull = (Chull)((EntityType)StormwardEntities.CHULL.get()).m_262496_(pServerLevel, blockpos, MobSpawnType.EVENT)) != null) {
            chull.m_21463_((Entity)pMerchant, true);
            chull.setChest(true);
            chull.getCapability(ForgeCapabilities.ITEM_HANDLER).ifPresent(itemHandler -> {
                LootTable table = pServerLevel.m_7654_().m_278653_().m_278676_(CHULL_CHEST_LOOT);
                LootParams params = new LootParams.Builder(pServerLevel).m_287286_(LootContextParams.f_81460_, (Object)Vec3.m_82512_((Vec3i)blockpos)).m_287286_(LootContextParams.f_81455_, (Object)chull).m_287235_(LootContextParamSets.f_81411_);
                ObjectArrayList items = table.m_287214_(params, blockpos.m_121878_());
                for (ItemStack item : items) {
                    itemHandler.insertItem(this.random.m_188503_(itemHandler.getSlots()), item, false);
                }
            });
        }
    }

    @Nullable
    private BlockPos findSpawnPositionNear(LevelReader pLevel, BlockPos pPos, int pMaxDistance, EntityType<? extends LivingEntity> pEntityType) {
        BlockPos blockpos = null;
        for (int i = 0; i < 10; ++i) {
            int k;
            int l;
            int j = pPos.m_123341_() + this.random.m_188503_(pMaxDistance * 2) - pMaxDistance;
            BlockPos blockpos1 = new BlockPos(j, l = pLevel.m_6924_(Heightmap.Types.WORLD_SURFACE, j, k = pPos.m_123343_() + this.random.m_188503_(pMaxDistance * 2) - pMaxDistance), k);
            if (!NaturalSpawner.m_47051_((SpawnPlacements.Type)SpawnPlacements.Type.ON_GROUND, (LevelReader)pLevel, (BlockPos)blockpos1, pEntityType)) continue;
            blockpos = blockpos1;
            break;
        }
        return blockpos;
    }

    private boolean hasEnoughSpace(BlockGetter pLevel, BlockPos pPos) {
        for (BlockPos blockpos : BlockPos.m_121940_((BlockPos)pPos, (BlockPos)pPos.m_7918_(1, 2, 1))) {
            if (pLevel.m_8055_(blockpos).m_60812_(pLevel, blockpos).m_83281_()) continue;
            return false;
        }
        return true;
    }
}

