/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.entity.villager;

import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.Mth;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.trading.MerchantOffer;
import org.jetbrains.annotations.NotNull;
import us.amon.stormward.entity.villager.SphereOfferTier;
import us.amon.stormward.gemstone.Gemstone;
import us.amon.stormward.item.stormlightstorage.SphereItem;

public class SphereMerchantOffer
extends MerchantOffer {
    private final Optional<SphereOfferTier> tier;
    private final Optional<Gemstone> gemstoneA;
    private final Optional<Gemstone> gemstoneB;

    public SphereMerchantOffer(ItemStack pCostA, ItemStack pCostB, ItemStack pResult, int pMaxUses, int pXp, float pPriceMultiplier) {
        this(pCostA, pCostB, pResult, 0, pMaxUses, pXp, pPriceMultiplier, 0);
    }

    public SphereMerchantOffer(ItemStack pCostA, ItemStack pCostB, ItemStack pResult, int pUses, int pMaxUses, int pXp, float pPriceMultiplier, int pDemand) {
        super(pCostA, pCostB, pResult, pUses, pMaxUses, pXp, pPriceMultiplier, pDemand);
        this.tier = Optional.empty();
        this.gemstoneA = Optional.empty();
        this.gemstoneB = Optional.empty();
    }

    public SphereMerchantOffer(SphereOfferTier pTier, Gemstone pGemstoneA, ItemStack pCostB, ItemStack pResult, int pMaxUses, int pXp, float pPriceMultiplier) {
        this(pTier, pGemstoneA, pCostB, pResult, 0, pMaxUses, pXp, pPriceMultiplier, 0);
    }

    public SphereMerchantOffer(SphereOfferTier pTier, Gemstone pGemstoneA, ItemStack pCostB, ItemStack pResult, int pUses, int pMaxUses, int pXp, float pPriceMultiplier, int pDemand) {
        super(pTier.getCostA(pGemstoneA), pCostB, pResult, pUses, pMaxUses, pXp, pPriceMultiplier, pDemand);
        SphereOfferTier singleItemTier = pTier;
        while (singleItemTier.getDenomB() != SphereItem.Denomination.NONE) {
            singleItemTier = pTier.decrease();
        }
        this.tier = Optional.of(singleItemTier);
        this.gemstoneA = Optional.of(pGemstoneA);
        this.gemstoneB = Optional.empty();
    }

    public SphereMerchantOffer(SphereOfferTier pTier, Gemstone pGemstoneA, Gemstone pGemstoneB, ItemStack pResult, int pMaxUses, int pXp, float pPriceMultiplier) {
        this(pTier, pGemstoneA, pGemstoneB, pResult, 0, pMaxUses, pXp, pPriceMultiplier, 0);
    }

    public SphereMerchantOffer(SphereOfferTier pTier, Gemstone pGemstoneA, Gemstone pGemstoneB, ItemStack pResult, int pUses, int pMaxUses, int pXp, float pPriceMultiplier, int pDemand) {
        super(pTier.getCostA(pGemstoneA), pTier.getCostB(pGemstoneB), pResult, pUses, pMaxUses, pXp, pPriceMultiplier, pDemand);
        this.tier = Optional.of(pTier);
        this.gemstoneA = Optional.of(pGemstoneA);
        this.gemstoneB = Optional.of(pGemstoneB);
    }

    public SphereMerchantOffer(CompoundTag pCompoundTag) {
        super(pCompoundTag);
        this.tier = pCompoundTag.m_128441_("tier") ? Optional.of(SphereOfferTier.valueOf(pCompoundTag.m_128461_("tier"))) : Optional.empty();
        this.gemstoneA = pCompoundTag.m_128441_("gemstoneA") ? Optional.of(Gemstone.valueOf(pCompoundTag.m_128461_("gemstoneA"))) : Optional.empty();
        this.gemstoneB = pCompoundTag.m_128441_("gemstoneB") ? Optional.of(Gemstone.valueOf(pCompoundTag.m_128461_("gemstoneB"))) : Optional.empty();
    }

    private SphereMerchantOffer(SphereMerchantOffer pOther) {
        super(pOther.m_45384_());
        this.tier = pOther.tier;
        this.gemstoneA = pOther.gemstoneA;
        this.gemstoneB = pOther.gemstoneB;
    }

    @NotNull
    public CompoundTag m_45384_() {
        CompoundTag tag = super.m_45384_();
        this.tier.ifPresent(tier -> tag.m_128359_("tier", tier.name()));
        this.gemstoneA.ifPresent(gemstone -> tag.m_128359_("gemstoneA", gemstone.name()));
        this.gemstoneB.ifPresent(gemstone -> tag.m_128359_("gemstoneB", gemstone.name()));
        return tag;
    }

    public ItemStack getBaseCostB() {
        return super.m_45364_();
    }

    @NotNull
    public ItemStack m_45358_() {
        return this.gemstoneA.map(gemstone -> this.tier.get().increase(this.getPriceDiff()).getCostA((Gemstone)((Object)gemstone))).orElse(super.m_45358_());
    }

    @NotNull
    public ItemStack m_45364_() {
        return this.gemstoneB.map(gemstone -> this.tier.get().increase(this.getPriceDiff()).getCostB((Gemstone)((Object)gemstone))).orElse(super.m_45364_());
    }

    private int getPriceDiff() {
        return Math.max(0, Mth.m_14143_((float)((float)this.m_45375_() * this.m_45378_()))) + this.m_45377_();
    }

    @NotNull
    public MerchantOffer m_301673_() {
        return new SphereMerchantOffer(this);
    }
}

