/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.entity.villager;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import net.minecraft.util.Mth;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import org.jetbrains.annotations.NotNull;
import us.amon.stormward.capability.stormlightstorage.StormlightStorageHelper;
import us.amon.stormward.gemstone.Gemstone;
import us.amon.stormward.item.StormwardItems;
import us.amon.stormward.item.stormlightstorage.SphereItem;

public enum SphereOfferTier implements StringRepresentable
{
    CHIP("chip", SphereItem.Denomination.CHIP, SphereItem.Denomination.NONE),
    CHIP_CHIP("chip_chip", SphereItem.Denomination.CHIP, SphereItem.Denomination.CHIP),
    MARK("chip_mark", SphereItem.Denomination.MARK, SphereItem.Denomination.NONE),
    MARK_CHIP("mark_chip", SphereItem.Denomination.MARK, SphereItem.Denomination.CHIP),
    MARK_MARK("mark_mark", SphereItem.Denomination.MARK, SphereItem.Denomination.MARK),
    BROAM("broam", SphereItem.Denomination.BROAM, SphereItem.Denomination.NONE),
    BROAM_CHIP("broam_chip", SphereItem.Denomination.BROAM, SphereItem.Denomination.CHIP),
    BROAM_MARK("broam_mark", SphereItem.Denomination.BROAM, SphereItem.Denomination.MARK),
    BROAM_BROAM("broam_broam", SphereItem.Denomination.BROAM, SphereItem.Denomination.BROAM);

    public static final Map<SphereItem.Denomination, Map<Gemstone, SphereItem>> SPHERE_TYPES;
    private static final SphereOfferTier[] values;
    private final String name;
    private final SphereItem.Denomination denomA;
    private final SphereItem.Denomination denomB;

    private SphereOfferTier(String pName, SphereItem.Denomination pDenomA, SphereItem.Denomination pDenomB) {
        this.name = pName;
        this.denomA = pDenomA;
        this.denomB = pDenomB;
    }

    public SphereOfferTier increase() {
        return this.increase(1);
    }

    public SphereOfferTier increase(int pAmount) {
        return values[Mth.m_14045_((int)(this.ordinal() + pAmount), (int)0, (int)(values.length - 1))];
    }

    public SphereOfferTier decrease() {
        return this.decrease(1);
    }

    public SphereOfferTier decrease(int pAmount) {
        return values[Mth.m_14045_((int)(this.ordinal() - pAmount), (int)0, (int)(values.length - 1))];
    }

    public SphereItem.Denomination getDenomA() {
        return this.denomA;
    }

    public SphereItem.Denomination getDenomB() {
        return this.denomB;
    }

    public ItemStack getCostA(Gemstone pGemstone) {
        ItemStack stack = new ItemStack((ItemLike)SPHERE_TYPES.get((Object)this.denomA).get((Object)pGemstone));
        StormlightStorageHelper.setFull((ICapabilityProvider)stack);
        return stack;
    }

    public ItemStack getCostB(Gemstone pGemstone) {
        if (this.denomB == SphereItem.Denomination.NONE) {
            return ItemStack.f_41583_;
        }
        ItemStack stack = new ItemStack((ItemLike)SPHERE_TYPES.get((Object)this.denomB).get((Object)pGemstone));
        StormlightStorageHelper.setFull((ICapabilityProvider)stack);
        return stack;
    }

    public String toString() {
        return this.m_7912_();
    }

    @NotNull
    public String m_7912_() {
        return this.name;
    }

    static {
        SPHERE_TYPES = ImmutableMap.of((Object)((Object)SphereItem.Denomination.CHIP), (Object)ImmutableMap.of((Object)((Object)Gemstone.SMOKESTONE), (Object)((SphereItem)StormwardItems.SMOKESTONE_CHIP.get()), (Object)((Object)Gemstone.TOPAZ), (Object)((SphereItem)StormwardItems.TOPAZ_CHIP.get()), (Object)((Object)Gemstone.GARNET), (Object)((SphereItem)StormwardItems.GARNET_CHIP.get()), (Object)((Object)Gemstone.RUBY), (Object)((SphereItem)StormwardItems.RUBY_CHIP.get()), (Object)((Object)Gemstone.AMETHYST), (Object)((SphereItem)StormwardItems.AMETHYST_CHIP.get()), (Object)((Object)Gemstone.SAPPHIRE), (Object)((SphereItem)StormwardItems.SAPPHIRE_CHIP.get()), (Object)((Object)Gemstone.ZIRCON), (Object)((SphereItem)StormwardItems.ZIRCON_CHIP.get()), (Object)((Object)Gemstone.DIAMOND), (Object)((SphereItem)StormwardItems.DIAMOND_CHIP.get()), (Object)((Object)Gemstone.EMERALD), (Object)((SphereItem)StormwardItems.EMERALD_CHIP.get())), (Object)((Object)SphereItem.Denomination.MARK), (Object)ImmutableMap.of((Object)((Object)Gemstone.SMOKESTONE), (Object)((SphereItem)StormwardItems.SMOKESTONE_MARK.get()), (Object)((Object)Gemstone.TOPAZ), (Object)((SphereItem)StormwardItems.TOPAZ_MARK.get()), (Object)((Object)Gemstone.GARNET), (Object)((SphereItem)StormwardItems.GARNET_MARK.get()), (Object)((Object)Gemstone.RUBY), (Object)((SphereItem)StormwardItems.RUBY_MARK.get()), (Object)((Object)Gemstone.AMETHYST), (Object)((SphereItem)StormwardItems.AMETHYST_MARK.get()), (Object)((Object)Gemstone.SAPPHIRE), (Object)((SphereItem)StormwardItems.SAPPHIRE_MARK.get()), (Object)((Object)Gemstone.ZIRCON), (Object)((SphereItem)StormwardItems.ZIRCON_MARK.get()), (Object)((Object)Gemstone.DIAMOND), (Object)((SphereItem)StormwardItems.DIAMOND_MARK.get()), (Object)((Object)Gemstone.EMERALD), (Object)((SphereItem)StormwardItems.EMERALD_MARK.get())), (Object)((Object)SphereItem.Denomination.BROAM), (Object)ImmutableMap.of((Object)((Object)Gemstone.SMOKESTONE), (Object)((SphereItem)StormwardItems.SMOKESTONE_BROAM.get()), (Object)((Object)Gemstone.TOPAZ), (Object)((SphereItem)StormwardItems.TOPAZ_BROAM.get()), (Object)((Object)Gemstone.GARNET), (Object)((SphereItem)StormwardItems.GARNET_BROAM.get()), (Object)((Object)Gemstone.RUBY), (Object)((SphereItem)StormwardItems.RUBY_BROAM.get()), (Object)((Object)Gemstone.AMETHYST), (Object)((SphereItem)StormwardItems.AMETHYST_BROAM.get()), (Object)((Object)Gemstone.SAPPHIRE), (Object)((SphereItem)StormwardItems.SAPPHIRE_BROAM.get()), (Object)((Object)Gemstone.ZIRCON), (Object)((SphereItem)StormwardItems.ZIRCON_BROAM.get()), (Object)((Object)Gemstone.DIAMOND), (Object)((SphereItem)StormwardItems.DIAMOND_BROAM.get()), (Object)((Object)Gemstone.EMERALD), (Object)((SphereItem)StormwardItems.EMERALD_BROAM.get())));
        values = SphereOfferTier.values();
    }
}

