/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.entity.wood;

import java.util.function.IntFunction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;
import us.amon.stormward.block.StormwardBlocks;
import us.amon.stormward.entity.StormwardEntities;
import us.amon.stormward.item.StormwardItems;

public class StormwardBoatEntity
extends Boat {
    private static final EntityDataAccessor<Integer> DATA_ID = SynchedEntityData.m_135353_(StormwardBoatEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);

    public StormwardBoatEntity(EntityType<? extends Boat> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    public StormwardBoatEntity(Level pLevel, double pX, double pY, double pZ) {
        this((EntityType<? extends Boat>)((EntityType)StormwardEntities.BOAT.get()), pLevel);
        this.m_6034_(pX, pY, pZ);
        this.f_19854_ = pX;
        this.f_19855_ = pY;
        this.f_19856_ = pZ;
    }

    @NotNull
    public Item m_38369_() {
        return switch (this.getStormwardVariant()) {
            default -> throw new IncompatibleClassChangeError();
            case Type.MARKEL -> (Item)StormwardItems.MARKEL_BOAT.get();
            case Type.STUMPWEIGHT -> (Item)StormwardItems.STUMPWEIGHT_BOAT.get();
        };
    }

    public void setVariant(Type pVariant) {
        this.f_19804_.m_135381_(DATA_ID, (Object)pVariant.ordinal());
    }

    public Type getStormwardVariant() {
        return Type.byId((Integer)this.f_19804_.m_135370_(DATA_ID));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_ID, (Object)Type.MARKEL.ordinal());
    }

    protected void m_7380_(CompoundTag pCompound) {
        pCompound.m_128359_("Type", this.getStormwardVariant().m_7912_());
    }

    protected void m_7378_(CompoundTag pCompound) {
        if (pCompound.m_128425_("Type", 8)) {
            this.setVariant(Type.byName(pCompound.m_128461_("Type")));
        }
    }

    public static enum Type implements StringRepresentable
    {
        MARKEL((Block)StormwardBlocks.MARKEL_PLANKS.get(), "markel"),
        STUMPWEIGHT((Block)StormwardBlocks.STUMPWEIGHT_PLANKS.get(), "stumpweight");

        private final String name;
        private final Block planks;
        public static final StringRepresentable.EnumCodec<Type> CODEC;
        private static final IntFunction<Type> BY_ID;

        private Type(Block pPlanks, String pName) {
            this.name = pName;
            this.planks = pPlanks;
        }

        @NotNull
        public String m_7912_() {
            return this.name;
        }

        public String getName() {
            return this.name;
        }

        public Block getPlanks() {
            return this.planks;
        }

        public String toString() {
            return this.name;
        }

        public static Type byId(int pId) {
            return BY_ID.apply(pId);
        }

        public static Type byName(String pName) {
            return (Type)CODEC.m_262792_(pName, (Enum)MARKEL);
        }

        static {
            CODEC = StringRepresentable.m_216439_(Type::values);
            BY_ID = ByIdMap.m_262839_(Enum::ordinal, (Object[])Type.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.ZERO);
        }
    }
}

