/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.function.loot;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Set;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.functions.LootItemConditionalFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.parameters.LootContextParam;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.NumberProviders;
import org.jetbrains.annotations.NotNull;
import us.amon.stormward.capability.StormwardCapabilities;
import us.amon.stormward.function.loot.StormwardLootItemFunctions;

public class SetStormlightPercentFunction
extends LootItemConditionalFunction {
    public static final Codec<SetStormlightPercentFunction> CODEC = RecordCodecBuilder.create(builder -> SetStormlightPercentFunction.m_294820_((RecordCodecBuilder.Instance)builder).and((App)NumberProviders.f_291751_.fieldOf("percent").forGetter(function -> function.percent)).apply((Applicative)builder, SetStormlightPercentFunction::new));
    private final NumberProvider percent;

    public SetStormlightPercentFunction(List<LootItemCondition> p_300823_, NumberProvider p_165428_) {
        super(p_300823_);
        this.percent = p_165428_;
    }

    @NotNull
    public LootItemFunctionType m_7162_() {
        return (LootItemFunctionType)StormwardLootItemFunctions.SET_STORMLIGHT_PERCENT.get();
    }

    @NotNull
    public Set<LootContextParam<?>> m_6231_() {
        return this.percent.m_6231_();
    }

    @NotNull
    public ItemStack m_7372_(ItemStack pStack, @NotNull LootContext pContext) {
        pStack.getCapability(StormwardCapabilities.STORMLIGHT).ifPresent(stormlightStorage -> stormlightStorage.setStormlight((int)((float)stormlightStorage.getMaxStormlight() * this.percent.m_142688_(pContext))));
        return pStack;
    }

    public static LootItemConditionalFunction.Builder<?> setPercent(NumberProvider pStormlightPercent) {
        return SetStormlightPercentFunction.m_80683_(p_297153_ -> new SetStormlightPercentFunction((List<LootItemCondition>)p_297153_, pStormlightPercent));
    }
}

