/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.item;

import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.entity.living.LivingDamageEvent;
import org.jetbrains.annotations.NotNull;
import us.amon.stormward.capability.stormlightstorage.StormlightStorageHelper;
import us.amon.stormward.item.StormwardItems;
import us.amon.stormward.item.stormlightstorage.StormlightStorageItem;
import us.amon.stormward.sound.StormwardSoundEvents;

public class RegrowerItem
extends StormlightStorageItem {
    private static final int REGROW_AMOUNT = 1;
    private static final int REGROW_RATE = 5;

    public RegrowerItem(Item.Properties pProperties) {
        super(100, pProperties.m_41497_(Rarity.RARE));
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level pLevel, Player pPlayer, @NotNull InteractionHand pUsedHand) {
        ItemStack stack = pPlayer.m_21120_(pUsedHand);
        if (StormlightStorageHelper.isDun((ICapabilityProvider)stack)) {
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        pPlayer.m_6672_(pUsedHand);
        return InteractionResultHolder.m_19092_((Object)stack, (boolean)pLevel.f_46443_);
    }

    public void m_5929_(@NotNull Level pLevel, @NotNull LivingEntity pLivingEntity, @NotNull ItemStack pStack, int pRemainingUseDuration) {
        if (StormlightStorageHelper.isDun((ICapabilityProvider)pStack)) {
            pLivingEntity.m_5810_();
        } else if (pLivingEntity.m_21223_() < pLivingEntity.m_21233_() && pRemainingUseDuration % 5 == 0) {
            pLivingEntity.m_5634_(1.0f);
            pStack.m_41622_(2, pLivingEntity, living -> living.m_21190_(pLivingEntity.m_7655_()));
            pLevel.m_6263_(null, pLivingEntity.m_20185_(), pLivingEntity.m_20186_(), pLivingEntity.m_20189_(), (SoundEvent)StormwardSoundEvents.REGROWER.get(), SoundSource.PLAYERS, 1.0f, (pLivingEntity.m_217043_().m_188501_() - pLivingEntity.m_217043_().m_188501_()) * 0.05f + 1.0f);
        }
    }

    public int m_8105_(@NotNull ItemStack pStack) {
        return 72000;
    }

    public static void onLivingEntityDamaged(LivingDamageEvent event) {
        LivingEntity entity = event.getEntity();
        ItemStack stack = entity.m_21211_();
        if (event.getAmount() >= entity.m_21223_() && stack.m_150930_((Item)StormwardItems.REGROWER.get())) {
            event.setAmount(entity.m_21223_() - 1.0f);
            stack.m_41622_(100, entity, living -> living.m_21190_(entity.m_7655_()));
        }
    }
}

