/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.item.stormlightstorage;

import net.minecraft.util.RandomSource;
import net.minecraft.world.item.Item;
import us.amon.stormward.gemstone.Gemstone;
import us.amon.stormward.gemstone.IGemstoneProvider;
import us.amon.stormward.item.stormlightstorage.StormlightStorageItem;

public class SphereItem
extends StormlightStorageItem
implements IGemstoneProvider {
    private final Gemstone gemstone;
    private final Denomination denomination;

    public SphereItem(Gemstone pGemstone, Denomination pDenomination, Item.Properties pProperties) {
        super(pDenomination.getStormlight(), pProperties);
        this.gemstone = pGemstone;
        this.denomination = pDenomination;
    }

    @Override
    public Gemstone getGemstone() {
        return this.gemstone;
    }

    public Denomination getDenomination() {
        return this.denomination;
    }

    public static enum Denomination {
        NONE(0),
        CHIP(10),
        MARK(50),
        BROAM(200);

        private static final Denomination[] values;
        private final int stormlight;

        private Denomination(int pStormlight) {
            this.stormlight = pStormlight;
        }

        public int getStormlight() {
            return this.stormlight;
        }

        public Denomination increase() {
            return this == BROAM ? BROAM : values[this.ordinal() + 1];
        }

        public Denomination decrease() {
            return this == NONE ? NONE : values[this.ordinal() - 1];
        }

        public static Denomination random(RandomSource pRandom) {
            return values[1 + pRandom.m_188503_(values.length - 1)];
        }

        static {
            values = Denomination.values();
        }
    }
}

