/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.item.stormlightstorage;

import java.util.List;
import java.util.function.Consumer;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.Style;
import net.minecraft.stats.Stats;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import us.amon.stormward.capability.StormwardCapabilities;
import us.amon.stormward.capability.stormlightstorage.StormlightStorageProvider;

public class StormlightStorageItemHelper {
    public static final int COLOR = 13232383;
    public static final Style STYLE = Style.f_131099_.m_178520_(13232383);

    public static ICapabilityProvider initCapabilities(int maxStormlight) {
        return new StormlightStorageProvider(maxStormlight);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static CompoundTag getShareTag(ItemStack stack) {
        CompoundTag nbt;
        CompoundTag compoundTag = nbt = stack.m_41784_();
        synchronized (compoundTag) {
            stack.getCapability(StormwardCapabilities.STORMLIGHT).ifPresent(stormlightStorage -> nbt.m_128405_("Stormlight", stormlightStorage.getStormlight()));
            return nbt;
        }
    }

    public static void readShareTag(ItemStack stack, @Nullable CompoundTag nbt) {
        if (nbt != null) {
            stack.getCapability(StormwardCapabilities.STORMLIGHT).ifPresent(stormlightStorage -> stormlightStorage.setStormlight(nbt.m_128451_("Stormlight")));
        }
    }

    public static boolean shouldCauseReequipAnimation(ItemStack oldStack, ItemStack newStack, boolean slotChanged) {
        return !oldStack.m_41720_().equals(newStack.m_41720_());
    }

    public static boolean isBarVisible(@NotNull ItemStack pStack) {
        return pStack.getCapability(StormwardCapabilities.STORMLIGHT).map(stormlightStorage -> stormlightStorage.getStormlight() < stormlightStorage.getMaxStormlight()).orElse(false);
    }

    public static int getBarWidth(@NotNull ItemStack pStack) {
        return pStack.getCapability(StormwardCapabilities.STORMLIGHT).map(stormlightStorage -> Math.round(13.0f * (float)stormlightStorage.getStormlight() / (float)stormlightStorage.getMaxStormlight())).orElse(0);
    }

    public static int getBarColor(@NotNull ItemStack pStack) {
        return 13232383;
    }

    public static void appendHoverText(@NotNull ItemStack pStack, @javax.annotation.Nullable Level pLevel, @NotNull List<Component> pTooltip, @NotNull TooltipFlag pFlag) {
        pStack.getCapability(StormwardCapabilities.STORMLIGHT).ifPresent(stormlightStorage -> {
            if (pFlag.m_7050_()) {
                pTooltip.add((Component)Component.m_237110_((String)"item.stormward.stormlight", (Object[])new Object[]{stormlightStorage.getStormlight(), stormlightStorage.getMaxStormlight()}).m_130948_(STYLE));
            }
        });
    }

    public static boolean canApplyAtEnchantingTable(Enchantment enchantment) {
        return enchantment != Enchantments.f_44962_ && enchantment != Enchantments.f_44986_;
    }

    public static <T extends LivingEntity> int damageItem(ItemStack stack, int amount, T entity, Consumer<T> onBroken) {
        stack.getCapability(StormwardCapabilities.STORMLIGHT).ifPresent(stormlightStorage -> {
            int stormlight = stormlightStorage.getStormlight();
            if (stormlight > 0) {
                stormlightStorage.extractStormlight(amount, false);
                if (amount >= stormlight) {
                    onBroken.accept(entity);
                    if (entity instanceof Player) {
                        ((Player)entity).m_36246_(Stats.f_12983_.m_12902_((Object)stack.m_41720_()));
                    }
                }
            }
        });
        return 0;
    }
}

