/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.item.tool;

import com.mojang.logging.LogUtils;
import com.mojang.serialization.DynamicOps;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.GlobalPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.DoubleTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import us.amon.stormward.Config;
import us.amon.stormward.block.StormwardBlocks;
import us.amon.stormward.block.pairedfabrial.PairedBlock;
import us.amon.stormward.blockentity.ascender.AscenderWinchEntity;
import us.amon.stormward.capability.stormlightstorage.StormlightConfigStorageProvider;
import us.amon.stormward.capability.stormlightstorage.StormlightStorageHelper;
import us.amon.stormward.item.stormlightstorage.StormlightStorageItem;
import us.amon.stormward.network.PacketHandler;
import us.amon.stormward.network.ServerboundSetAscenderAnglePacket;
import us.amon.stormward.sound.StormwardSoundEvents;

public class AscenderItem
extends StormlightStorageItem {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final String WINCH_POS_KEY = "WinchPos";
    private static final String WINCH_DIMENSION_KEY = "WinchDimension";
    private static final String ANGLE_KEY = "Angle";
    private static final String ACCEL_KEY = "Acceleration";
    private static final String START_TIME_KEY = "StartTime";
    private static final int COST_INTERVAL = 2;

    public AscenderItem(Item.Properties pProperties) {
        super((Integer)Config.ASCENDER_STORMLIGHT.getDefault(), pProperties.m_41497_(Rarity.RARE));
    }

    @Override
    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new StormlightConfigStorageProvider(Config.ASCENDER_STORMLIGHT);
    }

    @NotNull
    public InteractionResult m_6225_(UseOnContext pContext) {
        BlockPos pos;
        Level level = pContext.m_43725_();
        if (level.m_8055_(pos = pContext.m_8083_()).m_60713_((Block)StormwardBlocks.ASCENDER_WINCH.get())) {
            AscenderItem.saveWinchPos(pContext.m_43722_(), (ResourceKey<Level>)level.m_46472_(), pos);
            if (level.f_46443_) {
                PairedBlock.playPairEffects(level, pos, true);
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return super.m_6225_(pContext);
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level pLevel, @NotNull Player pPlayer, @NotNull InteractionHand pUsedHand) {
        ItemStack stack = pPlayer.m_21120_(pUsedHand);
        if (AscenderItem.hasWinchPos(stack) && !StormlightStorageHelper.isDun((ICapabilityProvider)stack)) {
            if (!pLevel.f_46443_) {
                AscenderWinchEntity winchEntity = this.loadWinchEntity(pLevel, AscenderItem.readWinchPos(stack));
                if (winchEntity != null && winchEntity.canFall()) {
                    this.startAscending(pLevel, (LivingEntity)pPlayer, pUsedHand, winchEntity);
                    CompoundTag tag = stack.m_41784_();
                    tag.m_128356_(START_TIME_KEY, pLevel.m_46467_());
                    tag.m_128350_(ACCEL_KEY, winchEntity.getAcceleration());
                    stack.m_41751_(tag);
                    AscenderItem.saveAngle(stack, pPlayer.m_20154_());
                }
            } else {
                PacketHandler.sendToServer(new ServerboundSetAscenderAnglePacket(pPlayer.m_20154_()));
            }
            return InteractionResultHolder.m_19092_((Object)stack, (boolean)pLevel.f_46443_);
        }
        return super.m_7203_(pLevel, pPlayer, pUsedHand);
    }

    public void m_5929_(@NotNull Level pLevel, @NotNull LivingEntity pLivingEntity, @NotNull ItemStack pStack, int pRemainingUseDuration) {
        if (pLivingEntity.m_6095_() == EntityType.f_20532_ && AscenderItem.hasWinchPos(pStack)) {
            if (!pLevel.f_46443_) {
                AscenderWinchEntity winchEntity = this.loadWinchEntity(pLevel, AscenderItem.readWinchPos(pStack));
                if (winchEntity != null) {
                    winchEntity.tickFall(pLevel);
                    if (pRemainingUseDuration % 2 == 0) {
                        pStack.m_41622_(1, pLivingEntity, living -> living.m_21190_(pLivingEntity.m_7655_()));
                    }
                    if (!winchEntity.isFalling() || StormlightStorageHelper.isDun((ICapabilityProvider)pStack)) {
                        this.stopAscending(pLivingEntity, winchEntity);
                    }
                }
            } else {
                float acceleration = AscenderItem.getAcceleration(pLevel, pStack);
                pLivingEntity.m_20256_(AscenderItem.readAngle(pStack).m_82490_((double)acceleration));
            }
        }
    }

    public void m_5551_(@NotNull ItemStack pStack, @NotNull Level pLevel, @NotNull LivingEntity pLivingEntity, int pTimeCharged) {
        AscenderWinchEntity winchEntity;
        if (!pLevel.f_46443_ && AscenderItem.hasWinchPos(pStack) && (winchEntity = this.loadWinchEntity(pLevel, AscenderItem.readWinchPos(pStack))) != null) {
            this.stopAscending(pLivingEntity, winchEntity);
        }
    }

    public void onStopUsing(ItemStack stack, LivingEntity entity, int count) {
        CompoundTag tag = stack.m_41784_();
        tag.m_128473_(ACCEL_KEY);
        tag.m_128473_(START_TIME_KEY);
        stack.m_41751_(tag);
        AscenderItem.clearAngle(stack);
    }

    public int m_8105_(@NotNull ItemStack pStack) {
        return 72000;
    }

    private static float getAcceleration(@NotNull Level pLevel, @NotNull ItemStack pStack) {
        CompoundTag tag = pStack.m_41784_();
        float acceleration = tag.m_128441_(ACCEL_KEY) ? tag.m_128457_(ACCEL_KEY) : 0.0f;
        long startTime = tag.m_128441_(START_TIME_KEY) ? tag.m_128454_(START_TIME_KEY) : pLevel.m_46467_();
        return Math.min(2.0f, acceleration + 0.08f * (float)(pLevel.m_46467_() - startTime));
    }

    protected AscenderWinchEntity loadWinchEntity(Level pLevel, GlobalPos pPos) {
        if (pLevel.m_46472_() == pPos.m_122640_()) {
            AscenderWinchEntity winchEntity;
            pLevel.m_46745_(pPos.m_122646_());
            BlockEntity blockEntity = pLevel.m_7702_(pPos.m_122646_());
            return blockEntity instanceof AscenderWinchEntity ? (winchEntity = (AscenderWinchEntity)blockEntity) : null;
        }
        return null;
    }

    protected void startAscending(Level pLevel, LivingEntity pLivingEntity, InteractionHand pUsedHand, AscenderWinchEntity pWinchEntity) {
        pLivingEntity.m_6672_(pUsedHand);
        pWinchEntity.startFalling();
        pLevel.m_6263_(null, pLivingEntity.m_20185_(), pLivingEntity.m_20186_(), pLivingEntity.m_20189_(), (SoundEvent)StormwardSoundEvents.ASCENDER_USE.get(), SoundSource.PLAYERS, 1.0f, (pLivingEntity.m_217043_().m_188501_() - pLivingEntity.m_217043_().m_188501_()) * 0.05f + 1.0f);
    }

    protected void stopAscending(LivingEntity pLivingEntity, AscenderWinchEntity pWinchEntity) {
        pLivingEntity.m_5810_();
        pWinchEntity.stopFalling();
    }

    public static boolean hasWinchPos(ItemStack pStack) {
        CompoundTag tag = pStack.m_41784_();
        return tag.m_128441_(WINCH_POS_KEY) && tag.m_128441_(WINCH_DIMENSION_KEY);
    }

    public static void saveWinchPos(ItemStack pStack, ResourceKey<Level> pDimension, BlockPos pPos) {
        CompoundTag tag = pStack.m_41784_();
        tag.m_128365_(WINCH_POS_KEY, (Tag)NbtUtils.m_129224_((BlockPos)pPos));
        Level.f_46427_.encodeStart((DynamicOps)NbtOps.f_128958_, pDimension).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).ifPresent(dimensionTag -> tag.m_128365_(WINCH_DIMENSION_KEY, dimensionTag));
        pStack.m_41751_(tag);
    }

    public static GlobalPos readWinchPos(ItemStack pStack) {
        Optional dimension;
        CompoundTag tag = pStack.m_41784_();
        if (tag.m_128441_(WINCH_POS_KEY) && tag.m_128441_(WINCH_DIMENSION_KEY) && (dimension = Level.f_46427_.parse((DynamicOps)NbtOps.f_128958_, (Object)tag.m_128423_(WINCH_DIMENSION_KEY)).result()).isPresent()) {
            BlockPos blockpos = NbtUtils.m_129239_((CompoundTag)tag.m_128469_(WINCH_POS_KEY));
            return GlobalPos.m_122643_((ResourceKey)((ResourceKey)dimension.get()), (BlockPos)blockpos);
        }
        return null;
    }

    public static void clearWinchPos(ItemStack pStack) {
        CompoundTag tag = pStack.m_41784_();
        tag.m_128473_(WINCH_POS_KEY);
        tag.m_128473_(WINCH_DIMENSION_KEY);
        pStack.m_41751_(tag);
    }

    public static boolean hasAngle(ItemStack pStack) {
        return pStack.m_41784_().m_128441_(ANGLE_KEY);
    }

    public static void saveAngle(ItemStack pStack, Vec3 pAngle) {
        ListTag list = new ListTag();
        list.add((Object)DoubleTag.m_128500_((double)pAngle.f_82479_));
        list.add((Object)DoubleTag.m_128500_((double)pAngle.f_82480_));
        list.add((Object)DoubleTag.m_128500_((double)pAngle.f_82481_));
        CompoundTag tag = pStack.m_41784_();
        tag.m_128365_(ANGLE_KEY, (Tag)list);
        pStack.m_41751_(tag);
    }

    public static Vec3 readAngle(ItemStack pStack) {
        ListTag list = pStack.m_41784_().m_128437_(ANGLE_KEY, 6);
        return new Vec3(list.m_128772_(0), list.m_128772_(1), list.m_128772_(2));
    }

    public static void clearAngle(ItemStack pStack) {
        CompoundTag tag = pStack.m_41784_();
        tag.m_128473_(ANGLE_KEY);
        pStack.m_41751_(tag);
    }

    @Override
    public void m_7373_(@NotNull ItemStack pStack, @Nullable Level pLevel, @NotNull List<Component> pTooltip, @NotNull TooltipFlag pIsAdvanced) {
        super.m_7373_(pStack, pLevel, pTooltip, pIsAdvanced);
        if (AscenderItem.hasWinchPos(pStack) && pIsAdvanced.m_7050_()) {
            pTooltip.add((Component)Component.m_237110_((String)"item.stormward.ascender_text", (Object[])new Object[]{AscenderItem.readWinchPos(pStack).m_122646_().m_123344_()}).m_130940_(ChatFormatting.GRAY));
        }
    }
}

