/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.item.tool;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import us.amon.stormward.Config;
import us.amon.stormward.block.pairedfabrial.PairedBlock;
import us.amon.stormward.capability.stormlightstorage.StormlightConfigStorageProvider;
import us.amon.stormward.item.stormlightstorage.StormlightStorageItem;
import us.amon.stormward.network.PacketHandler;
import us.amon.stormward.network.ServerboundSetDetectedEssencePacket;
import us.amon.stormward.sound.StormwardSoundEvents;

public class EssenceDetectorItem
extends StormlightStorageItem {
    private static final String BLOCK_KEY = "Block";
    private static final String POS_KEY = "Pos";
    private static final int RANGE = 12;
    private static final int SECTIONS = 20;
    private static final int COST_INTERVAL = 80;
    public static final float ROT_LIMIT = 0.125f;

    public EssenceDetectorItem(Item.Properties pProperties) {
        super((Integer)Config.ESSENCE_DETECTOR_STORMLIGHT.getDefault(), pProperties.m_41497_(Rarity.RARE));
    }

    @Override
    @Nullable
    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        return new StormlightConfigStorageProvider(Config.ESSENCE_DETECTOR_STORMLIGHT);
    }

    @NotNull
    public InteractionResult m_6225_(UseOnContext pContext) {
        Level level = pContext.m_43725_();
        ItemStack stack = pContext.m_43722_();
        BlockPos pos = pContext.m_8083_();
        BlockState state = level.m_8055_(pContext.m_8083_());
        ResourceLocation location = ForgeRegistries.BLOCKS.getKey((Object)state.m_60734_());
        if (location != null) {
            CompoundTag tag = stack.m_41784_();
            if (tag.m_128441_(BLOCK_KEY) && tag.m_128461_(BLOCK_KEY).equals(location.toString())) {
                tag.m_128473_(BLOCK_KEY);
                tag.m_128473_(POS_KEY);
            } else {
                tag.m_128359_(BLOCK_KEY, location.toString());
            }
            stack.m_41751_(tag);
            if (level.f_46443_) {
                PairedBlock.playPairEffects(level, pos, tag.m_128441_(BLOCK_KEY));
            }
            return InteractionResult.m_19078_((boolean)level.f_46443_);
        }
        return InteractionResult.PASS;
    }

    public void onInventoryTick(ItemStack stack, Level level, Player player, int slotIndex, int selectedIndex) {
        super.onInventoryTick(stack, level, player, slotIndex, selectedIndex);
        if (EssenceDetectorItem.isActive(stack, (LivingEntity)player)) {
            CompoundTag tag = stack.m_41784_();
            if (level.f_46443_) {
                BlockPos prevClosestPos;
                if (!tag.m_128441_(BLOCK_KEY)) {
                    return;
                }
                ResourceLocation location = new ResourceLocation(tag.m_128461_(BLOCK_KEY));
                Optional optionalBlock = level.m_246945_(Registries.f_256747_).m_254902_(ResourceKey.m_135785_((ResourceKey)Registries.f_256747_, (ResourceLocation)location));
                if (optionalBlock.isEmpty()) {
                    return;
                }
                Holder.Reference block = (Holder.Reference)optionalBlock.get();
                BlockPos closestPos = this.getClosestBlockPos((Holder<Block>)block, prevClosestPos = tag.m_128441_(POS_KEY) ? NbtUtils.m_129239_((CompoundTag)tag.m_128469_(POS_KEY)) : null, level, player);
                if (closestPos != null) {
                    if (prevClosestPos != closestPos) {
                        PacketHandler.sendToServer(new ServerboundSetDetectedEssencePacket(player.m_21205_() == stack ? InteractionHand.MAIN_HAND : InteractionHand.OFF_HAND, closestPos));
                    }
                    this.playTickSoundForPos(level, closestPos, player);
                }
            } else {
                BlockPos pos;
                if (level.m_46467_() % 80L == 0L) {
                    stack.m_41622_(1, (LivingEntity)player, living -> living.m_21190_(player.m_7655_()));
                }
                if (tag.m_128441_(POS_KEY) && (pos = NbtUtils.m_129239_((CompoundTag)tag.m_128469_(POS_KEY))).m_123331_((Vec3i)player.m_20183_()) > 144.0) {
                    tag.m_128473_(POS_KEY);
                    stack.m_41751_(tag);
                }
            }
        }
    }

    private void playTickSoundForPos(Level pLevel, BlockPos pPos, Player pPlayer) {
        double dist = Math.sqrt(pPos.m_203193_((Position)pPlayer.m_20182_()));
        int interval = 40;
        if (dist <= 3.0) {
            interval = 5;
        } else if (dist <= 6.0) {
            interval = 10;
        } else if (dist <= 9.0) {
            interval = 20;
        }
        if (pLevel.m_46467_() % (long)interval == 0L) {
            pLevel.m_7785_(pPlayer.m_20185_(), pPlayer.m_20186_(), pPlayer.m_20189_(), (SoundEvent)StormwardSoundEvents.ESSENCE_DETECTOR_TICK.get(), SoundSource.PLAYERS, 1.0f, (pPlayer.m_217043_().m_188501_() - pPlayer.m_217043_().m_188501_()) * 0.05f + 1.0f, false);
        }
    }

    private BlockPos getClosestBlockPos(Holder<Block> pBlock, BlockPos pPrevClosestPos, Level pLevel, Player pPlayer) {
        double prevClosestDist;
        BlockPos closestPos = null;
        double closestDist = Double.MAX_VALUE;
        if (pPrevClosestPos != null && (prevClosestDist = pPrevClosestPos.m_123331_((Vec3i)pPlayer.m_20183_())) <= 144.0) {
            closestPos = pPrevClosestPos;
            closestDist = prevClosestDist;
        }
        int length = 144;
        for (int i = (int)(pLevel.m_46467_() % 20L); i < length * length * length; i += 20) {
            int index = i;
            int x = index % (length + 1);
            int y = (index /= length + 1) % (length + 1);
            int z = index /= length + 1;
            BlockPos pos = pPlayer.m_20183_().m_7918_(x - 12, y - 12, z - 12);
            double dist = pos.m_123331_((Vec3i)pPlayer.m_20183_());
            if (!(dist <= 144.0) || !pLevel.m_8055_(pos).m_295990_(pBlock) || !(dist < closestDist)) continue;
            closestPos = pos;
            closestDist = dist;
        }
        return closestPos;
    }

    public static boolean isActive(ItemStack pStack, LivingEntity pEntity) {
        return pStack.m_41782_() && pStack.m_41783_().m_128441_(BLOCK_KEY) && pEntity != null && pEntity.m_21093_(heldStack -> heldStack == pStack);
    }

    public static BlockPos getPos(ItemStack pStack) {
        if (!pStack.m_41782_()) {
            return null;
        }
        CompoundTag tag = pStack.m_41783_();
        return tag.m_128441_(POS_KEY) ? NbtUtils.m_129239_((CompoundTag)tag.m_128469_(POS_KEY)) : null;
    }

    public static void setPos(ItemStack pStack, BlockPos pPos) {
        CompoundTag tag = pStack.m_41784_();
        tag.m_128365_(POS_KEY, (Tag)NbtUtils.m_129224_((BlockPos)pPos));
        pStack.m_41751_(tag);
    }
}

