/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.item.weapon;

import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.event.entity.living.ShieldBlockEvent;
import org.jetbrains.annotations.NotNull;
import us.amon.stormward.Config;
import us.amon.stormward.capability.stormlightstorage.StormlightStorageHelper;
import us.amon.stormward.item.armor.ShardplateItem;
import us.amon.stormward.item.weapon.StormlightStorageWeaponItem;

public class ShardhammerItem
extends StormlightStorageWeaponItem {
    public static final float ADDITIONAL_DAMAGE_PERCENT = 1.0f;

    public ShardhammerItem(Item.Properties pProperties) {
        super(-3.2f, 1.0f, 0.6f, pProperties.m_41497_(Rarity.RARE));
    }

    @Override
    public double getDamage() {
        return (Double)Config.SHARDHAMMER_DAMAGE.get();
    }

    @Override
    protected ForgeConfigSpec.ConfigValue<Integer> getUsesConfigValue() {
        return Config.SHARDHAMMER_STORMLIGHT;
    }

    public int m_6473_() {
        return 12;
    }

    @Override
    public boolean canPerformAction(ItemStack stack, ToolAction toolAction) {
        return false;
    }

    @Override
    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return super.canApplyAtEnchantingTable(stack, enchantment) && enchantment != Enchantments.f_44983_ && enchantment != Enchantments.f_44977_ && enchantment != Enchantments.f_44982_;
    }

    public boolean canDisableShield(ItemStack stack, ItemStack shield, LivingEntity entity, LivingEntity attacker) {
        return !StormlightStorageHelper.isDun((ICapabilityProvider)stack);
    }

    public float m_8102_(@NotNull ItemStack pStack, @NotNull BlockState pState) {
        return StormlightStorageHelper.isDun((ICapabilityProvider)pStack) ? 1.0f : 12.0f;
    }

    public static void onLivingEntityHurt(LivingHurtEvent event) {
        LivingEntity livingEntity;
        Entity entity = event.getSource().m_7639_();
        if (entity instanceof LivingEntity && (livingEntity = (LivingEntity)entity).m_21205_().m_41720_() instanceof ShardhammerItem) {
            if (livingEntity instanceof Player) {
                Player player = (Player)livingEntity;
                player.m_150109_().m_150072_(event.getSource(), event.getAmount() * 1.0f, Inventory.f_150068_);
            } else {
                ShardplateItem.hurtShardplate(event.getEntity(), event.getSource(), event.getAmount() * 1.0f);
            }
        }
    }

    public static void onShieldBlock(ShieldBlockEvent event) {
        Player player;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player && (player = (Player)livingEntity).m_21211_().canPerformAction(ToolActions.SHIELD_BLOCK)) {
            ItemStack item = player.m_21211_();
            float damage = event.getOriginalBlockedDamage();
            if (damage >= 3.0f) {
                int i = 1 + Mth.m_14143_((float)damage);
                InteractionHand interactionhand = player.m_7655_();
                item.m_41622_(i, (LivingEntity)player, entity -> {
                    entity.m_21190_(interactionhand);
                    player.m_5810_();
                });
                if (item.m_41619_()) {
                    if (interactionhand == InteractionHand.MAIN_HAND) {
                        player.m_8061_(EquipmentSlot.MAINHAND, ItemStack.f_41583_);
                    } else {
                        player.m_8061_(EquipmentSlot.OFFHAND, ItemStack.f_41583_);
                    }
                    player.m_5810_();
                    player.m_5496_(SoundEvents.f_12347_, 0.8f, 0.8f + player.m_9236_().f_46441_.m_188501_() * 0.4f);
                }
            }
        }
    }
}

