/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.item.weapon;

import java.util.function.Consumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.common.ToolAction;
import org.jetbrains.annotations.NotNull;
import us.amon.stormward.entity.ThrownSpear;
import us.amon.stormward.item.client.SpearItemExtensions;
import us.amon.stormward.item.weapon.TwoHandedWeaponItem;
import us.amon.stormward.sound.StormwardSoundEvents;

public class SpearItem
extends TwoHandedWeaponItem {
    private final Tier tier;

    public SpearItem(Tier pTier, Item.Properties pProperties) {
        super(-2.8f, 0.0f, 1.0f, pProperties);
        this.tier = pTier;
    }

    @Override
    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new SpearItemExtensions());
    }

    @Override
    public double getDamage() {
        return this.tier.m_6631_() + 2.0f;
    }

    @Override
    protected int getUses() {
        return this.tier.m_6609_();
    }

    public int m_6473_() {
        return this.tier.m_6601_();
    }

    public boolean m_6832_(@NotNull ItemStack pToRepair, @NotNull ItemStack pRepair) {
        return this.tier.m_6282_().test(pRepair) || super.m_6832_(pToRepair, pRepair);
    }

    @NotNull
    public UseAnim m_6164_(@NotNull ItemStack pStack) {
        return UseAnim.SPEAR;
    }

    public int m_8105_(@NotNull ItemStack pStack) {
        return 72000;
    }

    @NotNull
    public InteractionResultHolder<ItemStack> m_7203_(@NotNull Level pLevel, Player pPlayer, @NotNull InteractionHand pHand) {
        ItemStack itemstack = pPlayer.m_21120_(pHand);
        if (pHand != InteractionHand.MAIN_HAND) {
            return InteractionResultHolder.m_19100_((Object)itemstack);
        }
        if (itemstack.m_41773_() >= itemstack.m_41776_() - 1) {
            return InteractionResultHolder.m_19100_((Object)itemstack);
        }
        pPlayer.m_6672_(pHand);
        return InteractionResultHolder.m_19096_((Object)itemstack);
    }

    public void m_5551_(@NotNull ItemStack pStack, @NotNull Level pLevel, @NotNull LivingEntity pEntityLiving, int pTimeLeft) {
        if (pEntityLiving instanceof Player) {
            Player player = (Player)pEntityLiving;
            int i = this.m_8105_(pStack) - pTimeLeft;
            if (i >= 10) {
                if (!pLevel.f_46443_) {
                    pStack.m_41622_(1, (LivingEntity)player, p_43388_ -> p_43388_.m_21190_(pEntityLiving.m_7655_()));
                    ThrownSpear thrownSpear = new ThrownSpear(pLevel, (LivingEntity)player, pStack);
                    thrownSpear.m_37251_((Entity)player, player.m_146909_(), player.m_146908_(), 0.0f, 1.5f, 1.0f);
                    if (player.m_150110_().f_35937_) {
                        thrownSpear.f_36705_ = AbstractArrow.Pickup.CREATIVE_ONLY;
                    }
                    pLevel.m_7967_((Entity)thrownSpear);
                    pLevel.m_6269_(null, (Entity)thrownSpear, (SoundEvent)StormwardSoundEvents.SPEAR_THROW.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
                    if (!player.m_150110_().f_35937_) {
                        player.m_150109_().m_36057_(pStack);
                    }
                }
                player.m_36246_(Stats.f_12982_.m_12902_((Object)this));
            }
        }
    }

    @Override
    public boolean canPerformAction(ItemStack stack, ToolAction toolAction) {
        return false;
    }

    @Override
    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return (super.canApplyAtEnchantingTable(stack, enchantment) || enchantment == Enchantments.f_44955_) && enchantment != Enchantments.f_44983_;
    }

    @NotNull
    public static ResourceLocation getEntityTextureLocation(ItemStack pStack) {
        return new ResourceLocation("stormward", "textures/entity/spear/" + pStack.m_41720_() + ".png");
    }
}

