/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.item.weapon;

import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Vanishable;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentCategory;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.common.ToolAction;
import net.minecraftforge.common.ToolActions;
import net.minecraftforge.event.entity.living.LivingEntityUseItemEvent;
import org.jetbrains.annotations.NotNull;
import us.amon.stormward.item.client.TwoHandedWeaponItemExtensions;

public abstract class TwoHandedWeaponItem
extends Item
implements Vanishable {
    protected static final UUID BASE_ENTITY_REACH_UUID = UUID.fromString("6fd4ca3d-ed67-48ec-b735-f4f86a0748d2");
    protected static final UUID BASE_ATTACK_KNOCKBACK_UUID = UUID.fromString("911542c3-0bf6-49fc-9ba5-8834cad1ebab");
    private final Multimap<Attribute, AttributeModifier> defaultModifiers;

    public TwoHandedWeaponItem(float pAttackSpeedModifier, float pKnockbackModifier, float pReachModifier, Item.Properties pProperties) {
        super(pProperties);
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        builder.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", (double)pAttackSpeedModifier, AttributeModifier.Operation.ADDITION));
        if (pKnockbackModifier > 0.0f) {
            builder.put((Object)Attributes.f_22282_, (Object)new AttributeModifier(BASE_ATTACK_KNOCKBACK_UUID, "Weapon modifier", (double)pKnockbackModifier, AttributeModifier.Operation.ADDITION));
        }
        builder.put((Object)((Attribute)ForgeMod.ENTITY_REACH.get()), (Object)new AttributeModifier(BASE_ENTITY_REACH_UUID, "Weapon modifier", (double)pReachModifier, AttributeModifier.Operation.ADDITION));
        this.defaultModifiers = builder.build();
    }

    @NotNull
    public Multimap<Attribute, AttributeModifier> m_7167_(@NotNull EquipmentSlot pEquipmentSlot) {
        if (pEquipmentSlot == EquipmentSlot.MAINHAND) {
            ImmutableMultimap.Builder builder = ImmutableMultimap.builder().putAll(this.defaultModifiers);
            builder.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", this.getDamage(), AttributeModifier.Operation.ADDITION));
            return builder.build();
        }
        return super.m_7167_(pEquipmentSlot);
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new TwoHandedWeaponItemExtensions());
    }

    public abstract double getDamage();

    protected abstract int getUses();

    public int getMaxDamage(ItemStack stack) {
        return this.getUses();
    }

    public boolean m_41465_() {
        return true;
    }

    public boolean m_6777_(@NotNull BlockState pState, @NotNull Level pLevel, @NotNull BlockPos pPos, Player pPlayer) {
        return !pPlayer.m_7500_();
    }

    public boolean m_7579_(ItemStack pStack, @NotNull LivingEntity pTarget, @NotNull LivingEntity pAttacker) {
        pStack.m_41622_(1, pAttacker, entity -> entity.m_21166_(EquipmentSlot.MAINHAND));
        return true;
    }

    public boolean m_6813_(@NotNull ItemStack pStack, @NotNull Level pLevel, BlockState pState, @NotNull BlockPos pPos, @NotNull LivingEntity pEntityLiving) {
        if ((double)pState.m_60800_((BlockGetter)pLevel, pPos) != 0.0) {
            pStack.m_41622_(2, pEntityLiving, entity -> entity.m_21166_(EquipmentSlot.MAINHAND));
        }
        return true;
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return enchantment.f_44672_ == EnchantmentCategory.WEAPON || super.canApplyAtEnchantingTable(stack, enchantment);
    }

    public boolean canPerformAction(ItemStack stack, ToolAction toolAction) {
        return toolAction == ToolActions.SWORD_SWEEP;
    }

    public static void onRenderHand(RenderHandEvent event) {
        LocalPlayer player = Minecraft.m_91087_().f_91074_;
        if (player != null && event.getHand() == InteractionHand.OFF_HAND && (event.getItemStack().m_41720_() instanceof TwoHandedWeaponItem || player.m_21205_().m_41720_() instanceof TwoHandedWeaponItem)) {
            event.setCanceled(true);
        }
    }

    public static void onLivingEntityUseItemStart(LivingEntityUseItemEvent.Start event) {
        if (event.getEntity().m_21205_().m_41720_() instanceof TwoHandedWeaponItem && !(event.getItem().m_41720_() instanceof TwoHandedWeaponItem)) {
            event.setCanceled(true);
        }
    }

    public static void onLivingEntityUseItemTick(LivingEntityUseItemEvent.Tick event) {
        LivingEntity entity = event.getEntity();
        if (entity.m_7655_() == InteractionHand.OFF_HAND && entity.m_21205_().m_41720_() instanceof TwoHandedWeaponItem) {
            event.setCanceled(true);
        }
    }
}

