/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.menu;

import java.util.Optional;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundContainerSetSlotPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.RecipeBookMenu;
import net.minecraft.world.inventory.RecipeBookType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;
import us.amon.stormward.block.StormwardBlocks;
import us.amon.stormward.item.FabrialItem;
import us.amon.stormward.item.soulcaster.SoulcasterItem;
import us.amon.stormward.menu.DoubleResultContainer;
import us.amon.stormward.menu.FabrialResultSlot;
import us.amon.stormward.menu.FabrialSlot;
import us.amon.stormward.menu.StormwardMenus;
import us.amon.stormward.recipe.FabrialRecipe;
import us.amon.stormward.recipe.StormwardRecipeBookTypes;
import us.amon.stormward.recipe.StormwardRecipeTypes;

public class ArtifabriansTableMenu
extends RecipeBookMenu<CraftingContainer> {
    public static final int RESULT_SLOT_1 = 0;
    public static final int RESULT_SLOT_2 = 4;
    public final CraftingContainer craftSlots = new TransientCraftingContainer((AbstractContainerMenu)this, 3, 1);
    public final DoubleResultContainer resultSlots = new DoubleResultContainer();
    public final Player player;
    private final ContainerLevelAccess access;
    private boolean locked;

    public ArtifabriansTableMenu(int pContainerId, Inventory pPlayerInventory) {
        this(pContainerId, pPlayerInventory, ContainerLevelAccess.f_39287_);
    }

    public ArtifabriansTableMenu(int pContainerId, Inventory pPlayerInventory, ContainerLevelAccess pAccess) {
        super((MenuType)StormwardMenus.ARTIFABRIANS_TABLE_MENU.get(), pContainerId);
        this.access = pAccess;
        this.player = pPlayerInventory.f_35978_;
        this.m_38897_((Slot)new FabrialResultSlot(this, 0, 116, 21));
        this.m_38897_(new FabrialSlot((Container)this.craftSlots, 0, 56, 17));
        this.m_38897_(new Slot((Container)this.craftSlots, 1, 45, 54));
        this.m_38897_(new Slot((Container)this.craftSlots, 2, 66, 54));
        this.m_38897_((Slot)new FabrialResultSlot(this, 1, 116, 50));
        for (int k = 0; k < 3; ++k) {
            for (int i1 = 0; i1 < 9; ++i1) {
                this.m_38897_(new Slot((Container)pPlayerInventory, i1 + k * 9 + 9, 8 + i1 * 18, 84 + k * 18));
            }
        }
        for (int l = 0; l < 9; ++l) {
            this.m_38897_(new Slot((Container)pPlayerInventory, l, 8 + l * 18, 142));
        }
    }

    public boolean isLocked() {
        return this.locked;
    }

    public void setLocked(boolean pLocked) {
        this.locked = pLocked;
        if (!this.locked) {
            this.m_6199_((Container)this.craftSlots);
        }
    }

    public void m_6199_(@NotNull Container pInventory) {
        this.access.m_39292_((level, pos) -> ArtifabriansTableMenu.slotChanged(this, level, this.player, this.craftSlots, this.resultSlots));
    }

    protected static void slotChanged(ArtifabriansTableMenu pMenu, Level pLevel, Player pPlayer, CraftingContainer pContainer, DoubleResultContainer pResult) {
        if (pMenu.isLocked()) {
            return;
        }
        if (!pLevel.m_5776_() && pLevel.m_7654_() != null) {
            ServerPlayer serverplayer = (ServerPlayer)pPlayer;
            ItemStack primary = ItemStack.f_41583_;
            ItemStack secondary = ItemStack.f_41583_;
            ItemStack result = ArtifabriansTableMenu.getSoulcasterResult(pContainer);
            if (result != null) {
                primary = result;
            } else {
                Optional optional = pLevel.m_7654_().m_129894_().m_44015_((RecipeType)StormwardRecipeTypes.FABRIAL.get(), (Container)pContainer, pLevel);
                if (optional.isPresent()) {
                    RecipeHolder recipeholder = (RecipeHolder)optional.get();
                    FabrialRecipe recipe = (FabrialRecipe)recipeholder.f_291008_();
                    if (pResult.m_294416_(pLevel, serverplayer, recipeholder)) {
                        ItemStack assembledSecondary;
                        ItemStack assembledPrimary = recipe.assemble(pContainer, pLevel.m_9598_());
                        if (assembledPrimary.m_246617_(pLevel.m_246046_())) {
                            primary = assembledPrimary;
                        }
                        if ((assembledSecondary = recipe.assembleSecondary(pContainer, pLevel.m_9598_())).m_246617_(pLevel.m_246046_())) {
                            secondary = assembledSecondary;
                        }
                    }
                }
            }
            pResult.m_6836_(0, primary);
            pMenu.m_150404_(0, primary);
            serverplayer.f_8906_.m_141995_((Packet)new ClientboundContainerSetSlotPacket(pMenu.f_38840_, pMenu.m_182425_(), 0, primary));
            pResult.m_6836_(1, secondary);
            pMenu.m_150404_(4, secondary);
            serverplayer.f_8906_.m_141995_((Packet)new ClientboundContainerSetSlotPacket(pMenu.f_38840_, pMenu.m_182425_(), 4, secondary));
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private static ItemStack getSoulcasterResult(CraftingContainer pContainer) {
        Item item;
        ItemStack result = null;
        Item item2 = pContainer.m_8020_(0).m_41720_();
        if (!(item2 instanceof FabrialItem)) return result;
        FabrialItem fabrial = (FabrialItem)item2;
        ItemStack extra1 = pContainer.m_8020_(1);
        ItemStack extra2 = pContainer.m_8020_(2);
        if (extra2.m_41619_() && (item = extra1.m_41720_()) instanceof SoulcasterItem) {
            SoulcasterItem soulcaster = (SoulcasterItem)item;
            if (SoulcasterItem.canAddFabrial(extra1, fabrial)) {
                result = extra1.m_41777_();
                SoulcasterItem.addFabrial(result, fabrial);
                return result;
            }
        }
        if (!extra1.m_41619_()) return result;
        item = extra2.m_41720_();
        if (!(item instanceof SoulcasterItem)) return result;
        SoulcasterItem soulcaster = (SoulcasterItem)item;
        if (!SoulcasterItem.canAddFabrial(extra2, fabrial)) return result;
        result = extra2.m_41777_();
        SoulcasterItem.addFabrial(result, fabrial);
        return result;
    }

    public void m_5816_(@NotNull StackedContents pItemHelper) {
        this.craftSlots.m_5809_(pItemHelper);
    }

    public void m_6650_() {
        this.craftSlots.m_6211_();
        this.resultSlots.m_6211_();
    }

    public boolean m_6032_(@NotNull RecipeHolder<? extends Recipe<CraftingContainer>> pRecipe) {
        return pRecipe.f_291008_().m_5818_((Container)this.craftSlots, this.player.m_9236_());
    }

    public void m_6877_(@NotNull Player pPlayer) {
        super.m_6877_(pPlayer);
        this.access.m_39292_((level, pos) -> this.m_150411_(pPlayer, (Container)this.craftSlots));
        if (this.isLocked()) {
            this.access.m_39292_((level, pos) -> this.m_150411_(pPlayer, this.resultSlots));
        }
    }

    public int m_6636_() {
        return 0;
    }

    public int m_6635_() {
        return 3;
    }

    public int m_6656_() {
        return 1;
    }

    public int m_6653_() {
        return 5;
    }

    @NotNull
    public RecipeBookType m_5867_() {
        return StormwardRecipeBookTypes.FABRIAL;
    }

    public boolean m_142157_(int pSlotIndex) {
        return pSlotIndex != 0 && pSlotIndex != 4;
    }

    @NotNull
    public ItemStack m_7648_(@NotNull Player pPlayer, int pIndex) {
        ItemStack itemstack = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(pIndex);
        if (slot.m_6657_()) {
            ItemStack itemstack1 = slot.m_7993_();
            itemstack = itemstack1.m_41777_();
            if (pIndex == 0 || pIndex == 4) {
                this.access.m_39292_((level, pos) -> itemstack1.m_41720_().m_7836_(itemstack1, level, pPlayer));
                if (!this.m_38903_(itemstack1, 5, 41, true)) {
                    return ItemStack.f_41583_;
                }
                slot.m_40234_(itemstack1, itemstack);
            } else if (pIndex >= 5 && pIndex < 41 ? !this.m_38903_(itemstack1, 1, 4, false) && (pIndex < 32 ? !this.m_38903_(itemstack1, 32, 41, false) : !this.m_38903_(itemstack1, 5, 32, false)) : !this.m_38903_(itemstack1, 5, 41, false)) {
                return ItemStack.f_41583_;
            }
            if (itemstack1.m_41619_()) {
                slot.m_269060_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (itemstack1.m_41613_() == itemstack.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(pPlayer, itemstack1);
            if (pIndex == 0) {
                pPlayer.m_36176_(itemstack1, false);
            }
        }
        return itemstack;
    }

    public boolean m_6875_(@NotNull Player pPlayer) {
        return ArtifabriansTableMenu.m_38889_((ContainerLevelAccess)this.access, (Player)pPlayer, (Block)((Block)StormwardBlocks.ARTIFABRIANS_TABLE.get()));
    }
}

