/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.mixin;

import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import us.amon.stormward.particle.StormwardParticles;
import us.amon.stormward.util.IAbstractArrow;

@Mixin(value={AbstractArrow.class})
public abstract class AbstractArrowMixin
extends Projectile
implements IAbstractArrow {
    @Shadow
    @Final
    private static EntityDataAccessor<Byte> f_36707_;

    @Shadow
    protected abstract void m_36737_(int var1, boolean var2);

    @Shadow
    public abstract boolean m_36792_();

    protected AbstractArrowMixin(EntityType<? extends Projectile> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    @Override
    public void stormward$setShotFromGrandbow(boolean pShotFromGrandbow) {
        this.m_36737_(8, pShotFromGrandbow);
    }

    @Override
    public boolean stormward$shotFromGrandbow() {
        byte b0 = (Byte)this.f_19804_.m_135370_(f_36707_);
        return (b0 & 8) != 0;
    }

    @Inject(method={"tick"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/projectile/AbstractArrow;isCritArrow()Z")})
    private void onTick(CallbackInfo ci) {
        if (this.stormward$shotFromGrandbow() && this.m_36792_()) {
            Vec3 delta = this.m_20184_();
            Vec3 up = this.m_20289_(0.0f);
            Vec3 right = up.m_82537_(delta.m_82541_());
            double radius = delta.m_82553_() * 0.3;
            for (int i = 0; i < 4; ++i) {
                double percent = (double)i / 4.0;
                for (int j = 0; j < 2; ++j) {
                    double angle = ((double)this.f_19797_ + percent) * 3.0 + (double)((float)Math.PI * (float)j);
                    Vec3 speed = up.m_82490_(Math.sin(angle) * radius).m_82549_(right.m_82490_(Math.cos(angle) * radius));
                    this.m_9236_().m_7106_((ParticleOptions)StormwardParticles.THWOOM.get(), this.m_20185_() + delta.f_82479_ * percent, this.m_20186_() + delta.f_82480_ * percent, this.m_20189_() + delta.f_82481_ * percent, speed.f_82479_, speed.f_82480_, speed.f_82481_);
                }
            }
        }
    }

    @ModifyArg(method={"tick"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/projectile/AbstractArrow;setDeltaMovement(DDD)V", ordinal=0), index=1)
    private double injected(double y) {
        return this.stormward$shotFromGrandbow() ? y + 0.015 : y;
    }

    @Inject(method={"onHitBlock"}, at={@At(value="RETURN")})
    private void onOnHitBlock(BlockHitResult pResult, CallbackInfo ci) {
        this.stormward$setShotFromGrandbow(false);
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="RETURN")})
    private void onAddAdditionalSaveData(CompoundTag pCompound, CallbackInfo ci) {
        pCompound.m_128379_("ShotFromGrandbow", this.stormward$shotFromGrandbow());
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="RETURN")})
    private void onReadAdditionalSaveData(CompoundTag pCompound, CallbackInfo ci) {
        this.stormward$setShotFromGrandbow(pCompound.m_128471_("ShotFromGrandbow"));
    }
}

