/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.mixin;

import com.mojang.authlib.GameProfile;
import java.util.Arrays;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.HangingSignEditScreen;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import us.amon.stormward.block.StormwardBlocks;
import us.amon.stormward.blockentity.StormwardHangingSignBlockEntity;
import us.amon.stormward.util.ILocalPlayer;
import us.amon.stormward.weather.Highstorm;

@Mixin(value={LocalPlayer.class})
public abstract class LocalPlayerMixin
extends Player
implements ILocalPlayer {
    @Shadow
    @Final
    protected Minecraft f_108619_;
    @Unique
    private float stormward$highstormPercent;
    @Unique
    private boolean stormward$inCognitiveBeads;

    public LocalPlayerMixin(Level pLevel, BlockPos pPos, float pYRot, GameProfile pGameProfile) {
        super(pLevel, pPos, pYRot, pGameProfile);
    }

    @Inject(method={"tick"}, at={@At(value="RETURN")})
    private void onTick(CallbackInfo ci) {
        if (this.f_19797_ > 20) {
            if (Highstorm.isEntityInHighstorm((Entity)this)) {
                this.stormward$highstormPercent += 0.02f;
                this.stormward$highstormPercent = Math.min(this.stormward$highstormPercent, 1.0f);
            } else {
                this.stormward$highstormPercent -= 0.02f;
                this.stormward$highstormPercent = Math.max(this.stormward$highstormPercent, 0.0f);
            }
        } else if (Highstorm.isEntityInHighstorm((Entity)this)) {
            this.stormward$highstormPercent = 1.0f;
        }
        this.stormward$inCognitiveBeads = false;
        Camera camera = this.f_108619_.f_91063_.m_109153_();
        Camera.NearPlane nearPlane = camera.m_167684_();
        for (Vec3 offset : Arrays.asList(nearPlane.m_167695_(0.0f, 0.0f), nearPlane.m_167694_(), nearPlane.m_167698_(), nearPlane.m_167699_(), nearPlane.m_167700_())) {
            BlockState blockstate = this.m_9236_().m_8055_(BlockPos.m_274446_((Position)camera.m_90583_().m_82549_(offset)));
            if (!blockstate.m_60713_((Block)StormwardBlocks.COGNITIVE_BEADS.get())) continue;
            this.stormward$inCognitiveBeads = true;
            break;
        }
    }

    @Override
    public float stormward$getHighstormPercent() {
        return this.stormward$highstormPercent;
    }

    @Override
    public boolean stormward$isInCognitiveBeads() {
        return this.stormward$inCognitiveBeads;
    }

    @Inject(method={"openTextEdit"}, at={@At(value="HEAD")}, cancellable=true)
    private void onOpenTextEdit(SignBlockEntity pSignEntity, boolean pIsFrontText, CallbackInfo ci) {
        if (pSignEntity instanceof StormwardHangingSignBlockEntity) {
            StormwardHangingSignBlockEntity hangingSignBlockEntity = (StormwardHangingSignBlockEntity)pSignEntity;
            this.f_108619_.m_91152_((Screen)new HangingSignEditScreen((SignBlockEntity)hangingSignBlockEntity, pIsFrontText, this.f_108619_.m_167974_()));
            ci.cancel();
        }
    }
}

