/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.mixin;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.profiling.ProfilerFiller;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LightningBolt;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.dimension.DimensionType;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.storage.ServerLevelData;
import net.minecraft.world.level.storage.WritableLevelData;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import us.amon.stormward.block.worldgen.plant.IRosharanPlant;
import us.amon.stormward.entity.CremSludge;
import us.amon.stormward.network.ClientboundNextRainTickPacket;
import us.amon.stormward.network.PacketHandler;
import us.amon.stormward.tag.StormwardBlockTags;
import us.amon.stormward.worldgen.biome.StormwardBiomes;
import us.amon.stormward.worldgen.feature.RosharFreezeFeature;

@Mixin(value={ServerLevel.class})
public abstract class ServerLevelMixin
extends Level {
    @Shadow
    @Final
    private ServerLevelData f_8549_;
    @Unique
    private long stormward$nextRainTick;

    protected ServerLevelMixin(WritableLevelData pLevelData, ResourceKey<Level> pDimension, RegistryAccess pRegistryAccess, Holder<DimensionType> pDimensionTypeRegistration, Supplier<ProfilerFiller> pProfiler, boolean pIsClientSide, boolean pIsDebug, long pBiomeZoomSeed, int pMaxChainedNeighborUpdates) {
        super(pLevelData, pDimension, pRegistryAccess, pDimensionTypeRegistration, pProfiler, pIsClientSide, pIsDebug, pBiomeZoomSeed, pMaxChainedNeighborUpdates);
    }

    @Shadow
    protected abstract BlockPos m_143288_(BlockPos var1);

    @Inject(method={"tickChunk"}, at={@At(value="TAIL")})
    private void onTickChunk(LevelChunk pChunk, int pRandomTickSpeed, CallbackInfo ci) {
        if (this.m_46471_()) {
            ChunkPos chunkPos = pChunk.m_7697_();
            int minX = chunkPos.m_45604_();
            int minZ = chunkPos.m_45605_();
            if (this.f_46438_ >= 1.0f) {
                BlockPos blockPos = this.m_5452_(Heightmap.Types.MOTION_BLOCKING, this.m_46496_(minX, 0, minZ, 15));
                this.stormward$tickHighstormBlock(blockPos);
            }
            for (int l = 0; l < pRandomTickSpeed; ++l) {
                BlockPos xzPos = this.m_46496_(minX, 0, minZ, 15);
                BlockPos blockingPos = this.m_5452_(Heightmap.Types.MOTION_BLOCKING, xzPos).m_7495_();
                this.stormward$tickHighstormPlantBlock(blockingPos);
                BlockPos surfacePos = this.m_5452_(Heightmap.Types.WORLD_SURFACE, xzPos).m_7495_();
                if (surfacePos.equals((Object)blockingPos)) continue;
                this.stormward$tickHighstormPlantBlock(surfacePos);
            }
        }
    }

    @Unique
    private void stormward$tickHighstormBlock(BlockPos pPos) {
        if (!StormwardBiomes.isBlockInRosharanBiome(this, pPos)) {
            return;
        }
        BlockState blockState = this.m_8055_(pPos);
        if (!(blockState.m_60795_() || blockState.m_280555_() || blockState.m_61138_((Property)BlockStateProperties.f_61362_) || blockState.m_204336_(StormwardBlockTags.HIGHSTORM_CANNOT_DESTROY) || blockState.m_60734_() instanceof IRosharanPlant)) {
            this.m_46961_(pPos, true);
            return;
        }
        if (this.f_46441_.m_188503_(1000) == 0) {
            CremSludge.fallOnBlock(this, pPos);
        }
        if (this.f_46441_.m_188503_(10000) == 0) {
            BlockPos lightningPos = this.m_143288_(pPos);
            LightningBolt lightningBolt = (LightningBolt)EntityType.f_20465_.m_20615_((Level)this);
            if (lightningBolt != null) {
                lightningBolt.m_20219_(Vec3.m_82539_((Vec3i)lightningPos));
                this.m_7967_((Entity)lightningBolt);
            }
        }
    }

    @Redirect(method={"tickIceAndSnow"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/biome/Biome;shouldFreeze(Lnet/minecraft/world/level/LevelReader;Lnet/minecraft/core/BlockPos;)Z"))
    private boolean shouldFreeze(Biome instance, LevelReader pLevel, BlockPos pPos) {
        return RosharFreezeFeature.shouldFreeze((Holder<Biome>)pLevel.m_204166_(pPos), pLevel, pPos, true);
    }

    @Redirect(method={"tickIceAndSnow"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/biome/Biome;shouldSnow(Lnet/minecraft/world/level/LevelReader;Lnet/minecraft/core/BlockPos;)Z"))
    private boolean shouldSnow(Biome instance, LevelReader pLevel, BlockPos pPos) {
        return RosharFreezeFeature.shouldSnow((Holder<Biome>)pLevel.m_204166_(pPos), pLevel, pPos);
    }

    @Unique
    private void stormward$tickHighstormPlantBlock(BlockPos pPos) {
        Block block;
        BlockState blockState = this.m_8055_(pPos);
        if (StormwardBiomes.isBlockInRosharanBiome(this, pPos) && (block = blockState.m_60734_()) instanceof IRosharanPlant) {
            IRosharanPlant plantBlock = (IRosharanPlant)block;
            plantBlock.highstormTick(this, pPos, blockState);
        }
    }

    @Inject(method={"setWeatherParameters"}, at={@At(value="RETURN")})
    private void onSetWeatherParameters(int pClearTime, int pWeatherTime, boolean pIsRaining, boolean pIsThundering, CallbackInfo ci) {
        this.stormward$updateNextRainTick();
    }

    @Inject(method={"advanceWeatherCycle"}, at={@At(value="RETURN")})
    private void onAdvanceWeatherCycle(CallbackInfo ci) {
        this.stormward$updateNextRainTick();
    }

    @Inject(method={"resetWeatherCycle"}, at={@At(value="RETURN")})
    private void onResetWeatherCycle(CallbackInfo ci) {
        this.stormward$updateNextRainTick();
    }

    @Unique
    private void stormward$updateNextRainTick() {
        long nextRainTick;
        int rainDelay;
        if (!this.f_8549_.m_6533_() && (rainDelay = this.f_8549_.m_6537_() + this.f_8549_.m_6531_()) > 0 && (nextRainTick = this.m_46467_() + (long)rainDelay) != this.stormward$nextRainTick) {
            this.stormward$nextRainTick = nextRainTick;
            PacketHandler.sendToDimension(new ClientboundNextRainTickPacket(this.stormward$nextRainTick), (ResourceKey<Level>)this.m_46472_());
        }
    }

    @Inject(method={"addPlayer"}, at={@At(value="RETURN")})
    private void onAddPlayer(ServerPlayer pPlayer, CallbackInfo ci) {
        if (this.stormward$nextRainTick <= 0L) {
            this.stormward$updateNextRainTick();
        }
        PacketHandler.sendToPlayer(new ClientboundNextRainTickPacket(this.stormward$nextRainTick), pPlayer);
    }
}

