/*
 * Decompiled with CFR 0.152.
 */
package us.amon.stormward.network;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.event.network.CustomPayloadEvent;
import us.amon.stormward.capability.StormwardCapabilities;
import us.amon.stormward.entity.Chull;
import us.amon.stormward.item.book.BookItem;
import us.amon.stormward.menu.ChullMenu;
import us.amon.stormward.menu.StormlightTraderMenu;
import us.amon.stormward.network.ClientboundBookScreenOpenPacket;
import us.amon.stormward.network.ClientboundChullScreenOpenPacket;
import us.amon.stormward.network.ClientboundNextRainTickPacket;
import us.amon.stormward.network.ClientboundRotatePlayerPacket;
import us.amon.stormward.network.ClientboundStormlightTraderScreenOpenPacket;
import us.amon.stormward.network.ClientboundTuskPacket;
import us.amon.stormward.screen.ChullScreen;
import us.amon.stormward.screen.book.BookScreen;
import us.amon.stormward.util.IClientLevel;

public class ClientboundPacketHandler {
    public static void handleRotatePlayer(ClientboundRotatePlayerPacket pPacket, CustomPayloadEvent.Context pContext) {
        LocalPlayer player;
        if (pContext.isClientSide() && (player = Minecraft.m_91087_().f_91074_) != null) {
            float rot = (float)(pPacket.getYRot() * 360) / 256.0f;
            player.m_146922_(rot);
        }
    }

    public static void handleChullScreenOpen(ClientboundChullScreenOpenPacket pPacket, CustomPayloadEvent.Context pContext) {
        Entity entity;
        Minecraft minecraft = Minecraft.m_91087_();
        if (pContext.isClientSide() && minecraft.f_91073_ != null && (entity = minecraft.f_91073_.m_6815_(pPacket.getEntityId())) instanceof Chull) {
            Chull chull = (Chull)entity;
            LocalPlayer player = minecraft.f_91074_;
            ChullMenu menu = new ChullMenu(pPacket.getContainerId(), player.m_150109_(), chull);
            player.f_36096_ = menu;
            minecraft.m_91152_((Screen)new ChullScreen(menu, player.m_150109_(), chull));
        }
    }

    public static void handleNextRainTick(ClientboundNextRainTickPacket pPacket, CustomPayloadEvent.Context pContext) {
        ClientLevel clientLevel;
        if (pContext.isClientSide() && (clientLevel = Minecraft.m_91087_().f_91073_) instanceof IClientLevel) {
            IClientLevel clientLevel2 = (IClientLevel)clientLevel;
            clientLevel2.stormward$setNextRainTick(pPacket.getNextRainTick());
        }
    }

    public static void handleBookScreenOpen(ClientboundBookScreenOpenPacket pPacket, CustomPayloadEvent.Context pContext) {
        ItemStack stack;
        Minecraft minecraft = Minecraft.m_91087_();
        if (pContext.isClientSide() && minecraft.f_91074_ != null && (stack = minecraft.f_91074_.m_21120_(pPacket.getHand())).m_41720_() instanceof BookItem) {
            minecraft.m_91152_((Screen)new BookScreen((Player)minecraft.f_91074_, stack, pPacket.getHand()));
        }
    }

    public static void handleTusks(ClientboundTuskPacket pPacket, CustomPayloadEvent.Context pContext) {
        Minecraft minecraft = Minecraft.m_91087_();
        if (pContext.isClientSide() && minecraft.f_91074_ != null) {
            minecraft.f_91074_.getCapability(StormwardCapabilities.TUSKS).ifPresent(tusks -> tusks.setTusks(pPacket.getTusks()));
        }
    }

    public static void handleStormlightTraderScreenOpen(ClientboundStormlightTraderScreenOpenPacket pPacket, CustomPayloadEvent.Context pContext) {
        Minecraft minecraft = Minecraft.m_91087_();
        if (pContext.isClientSide() && minecraft.f_91073_ != null) {
            AbstractContainerMenu menu = minecraft.f_91074_.f_36096_;
            if (pPacket.getContainerId() == menu.f_38840_ && menu instanceof StormlightTraderMenu) {
                StormlightTraderMenu traderMenu = (StormlightTraderMenu)menu;
                traderMenu.setTrade(pPacket.getItem(), pPacket.getCost());
            }
        }
    }
}

